/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.explorer;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.composite.explorer.OverlayIcon;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskStateUtilities;
import org.eclipse.ui.internal.cheatsheets.composite.views.TaskEditorManager;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.osgi.framework.Bundle;

public class TreeLabelProvider
extends LabelProvider {
    private static int BLOCKED = -1;
    private Image defaultImage = null;
    private Map<String, ImageSet> imageMap = new HashMap<String, ImageSet>();

    public String getText(Object obj) {
        String result = obj instanceof ICompositeCheatSheetTask ? ((ICompositeCheatSheetTask)obj).getName() : obj.toString();
        if (result == null) {
            result = "";
        }
        return result;
    }

    public Image getImage(Object obj) {
        if (obj instanceof ICompositeCheatSheetTask) {
            ICompositeCheatSheetTask task = (ICompositeCheatSheetTask)obj;
            return this.lookupImage(task.getKind(), task.getState(), TaskStateUtilities.isBlocked(task));
        }
        return super.getImage(obj);
    }

    public Image lookupImage(String kind, int state, boolean isBlocked) {
        ImageSet images = this.imageMap.get(kind);
        if (images == null) {
            images = this.createImages(kind);
            this.imageMap.put(kind, images);
        }
        if (isBlocked) {
            return images.getImage(BLOCKED);
        }
        return images.getImage(state);
    }

    private ImageSet createImages(String kind) {
        ImageSet images = new ImageSet();
        ImageDescriptor desc = this.getPredefinedImageDescriptor(kind, true);
        if (desc == null) {
            desc = TaskEditorManager.getInstance().getImageDescriptor(kind);
        }
        if (desc != null) {
            Image baseImage = desc.createImage();
            images.put(0, baseImage);
            this.createImageWithOverlay(1, "$nl$/icons/ovr16/task_in_progress.gif", images, desc);
            this.createImageWithOverlay(2, "$nl$/icons/ovr16/task_skipped.gif", images, desc);
            this.createDisabledImage(kind, BLOCKED, images, baseImage);
            this.createImageWithOverlay(3, "$nl$/icons/ovr16/task_complete.gif", images, desc);
        }
        return images;
    }

    private ImageDescriptor getPredefinedImageDescriptor(String kind, boolean isEnabled) {
        String filename;
        if ("cheatsheet".equals(kind)) {
            filename = "cheatsheet_task.gif";
        } else if ("set".equals(kind)) {
            filename = "task_set.gif";
        } else if ("choice".equals(kind)) {
            filename = "task_choice.gif";
        } else if ("sequence".equals(kind)) {
            filename = "task_sequence.gif";
        } else {
            return null;
        }
        String iconPath = "$nl$/icons/";
        iconPath = isEnabled ? String.valueOf(iconPath) + "obj16/" : String.valueOf(iconPath) + "dlcl16/";
        iconPath = String.valueOf(iconPath) + filename;
        return this.createImageDescriptor(iconPath);
    }

    private void createImageWithOverlay(int state, String imagePath, ImageSet images, ImageDescriptor baseDescriptor) {
        ImageDescriptor descriptor = this.createImageDescriptor(imagePath);
        OverlayIcon icon = new OverlayIcon(baseDescriptor, new ImageDescriptor[][]{new ImageDescriptor[0], {descriptor}});
        images.put(state, icon.createImage());
    }

    private void createDisabledImage(String kind, int state, ImageSet images, Image baseImage) {
        ImageDescriptor desc = this.getPredefinedImageDescriptor(kind, false);
        Image disabledImage = desc != null ? desc.createImage() : this.createGrayedImage(baseImage);
        images.put(state, disabledImage);
    }

    private Image createGrayedImage(Image image) {
        return new Image(image.getDevice(), image, 1);
    }

    private ImageDescriptor createImageDescriptor(String relativePath) {
        Bundle bundle = CheatSheetPlugin.getPlugin().getBundle();
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(relativePath), null);
        if (url == null) {
            return null;
        }
        try {
            url = FileLocator.resolve((URL)url);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void dispose() {
        if (this.imageMap != null) {
            for (ImageSet nextImages : this.imageMap.values()) {
                nextImages.dispose();
            }
            this.imageMap = null;
        }
        if (this.defaultImage != null) {
            this.defaultImage.dispose();
            this.defaultImage = null;
        }
    }

    private class ImageSet {
        Map<String, Image> images = new HashMap<String, Image>();

        private ImageSet() {
        }

        public void put(int index, Image image) {
            this.images.put(Integer.toString(index), image);
        }

        public Image getImage(int index) {
            return this.images.get(Integer.toString(index));
        }

        void dispose() {
            for (Image nextImage : this.images.values()) {
                nextImage.dispose();
            }
        }
    }
}

