/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.n4js.binaries.BinariesPreferenceStore;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NpmrcBinary;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.external.TargetPlatformInstallLocationProvider;
import org.eclipse.n4js.projectModel.dependencies.ProjectDependenciesHelper;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.ui.external.ExternalLibrariesReloadHelper;
import org.eclipse.n4js.utils.N4JSDataCollectors;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.io.FileDeleter;

public class ExternalLibrariesActionsHelper {
    @Inject
    private StatusHelper statusHelper;
    @Inject
    private LibraryManager libManager;
    @Inject
    private ProjectDependenciesHelper dependenciesHelper;
    @Inject
    private BinariesPreferenceStore preferenceStore;
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    private ExternalLibrariesReloadHelper externalLibrariesReloadHelper;
    @Inject
    private TargetPlatformInstallLocationProvider locationProvider;
    @Inject
    private Provider<NpmrcBinary> npmrcBinaryProvider;

    public void cleanAndInstallAllDependencies(SubMonitor monitor, MultiStatus multiStatus) {
        this.cleanAndInstallAllDependencies((Optional<Path>)Optional.absent(), false, monitor, multiStatus);
    }

    public void cleanAndInstallAllDependencies(Optional<Path> npmrcLocation, boolean removeNpmCache, SubMonitor monitor, MultiStatus multiStatus) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (Measurement m = N4JSDataCollectors.dcInstallHelper.getMeasurement("Install Missing Dependencies");){
            Measurement mm;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            if (npmrcLocation.isPresent()) {
                this.configureNpmrc((Path)npmrcLocation.get(), multiStatus);
            }
            if (removeNpmCache) {
                this.maintenanceCleanNpmCache(multiStatus, (IProgressMonitor)subMonitor.split(1));
            }
            this.maintenanceDeleteNpms(multiStatus);
            Map dependenciesToInstall = null;
            Throwable throwable2 = null;
            Object var11_15 = null;
            try {
                mm = N4JSDataCollectors.dcCollectMissingDeps.getMeasurement("Collect Missing Dependencies");
                try {
                    dependenciesToInstall = this.dependenciesHelper.computeDependenciesOfWorkspace();
                    this.dependenciesHelper.fixDependenciesToInstall(dependenciesToInstall);
                }
                finally {
                    if (mm != null) {
                        mm.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            throwable2 = null;
            var11_15 = null;
            try {
                mm = N4JSDataCollectors.dcInstallMissingDeps.getMeasurement("Install missing dependencies");
                try {
                    IStatus status = this.libManager.installNPMs(dependenciesToInstall, true, (IProgressMonitor)subMonitor.split(9));
                    if (!status.isOK()) {
                        multiStatus.merge(status);
                    }
                }
                finally {
                    if (mm != null) {
                        mm.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public void configureNpmrc(Path npmrcLocation, MultiStatus multiStatus) {
        NpmrcBinary npmrcBinary;
        URI oldLocation;
        URI newLocation = npmrcLocation.toFile().toURI();
        if (!newLocation.equals(oldLocation = (npmrcBinary = (NpmrcBinary)this.npmrcBinaryProvider.get()).getUserConfiguredLocation())) {
            this.preferenceStore.setPath((Binary)npmrcBinary, newLocation);
            IStatus save = this.preferenceStore.save();
            multiStatus.add(save);
        }
    }

    public void maintenanceCleanNpmCache(MultiStatus multistatus, IProgressMonitor monitor) {
        IStatus status = this.libManager.cleanCache(monitor);
        if (!status.isOK()) {
            multistatus.merge(status);
        }
    }

    public void maintenanceDeleteNpms(MultiStatus multistatus) {
        File npmFolder = this.locationProvider.getTargetPlatformInstallFolder();
        if (npmFolder.exists()) {
            FileDeleter.delete((File)npmFolder, ioe -> multistatus.merge(this.statusHelper.createError("Exception during deletion of the npm folder.", (Throwable)ioe)));
        }
        if (!npmFolder.exists()) {
            if (!this.locationProvider.repairNpmFolderState()) {
                multistatus.merge(this.statusHelper.createError("The target platform location folder was not recreated correctly."));
            }
        } else {
            multistatus.merge(this.statusHelper.createError("Could not verify deletion of " + npmFolder.getAbsolutePath()));
        }
        this.externalLibraryWorkspace.updateState();
    }

    public void maintenanceUpateState(MultiStatus multistatus, IProgressMonitor monitor) {
        this.externalLibraryWorkspace.updateState();
        try {
            this.externalLibrariesReloadHelper.reloadLibraries(false, monitor);
        }
        catch (Exception e) {
            multistatus.merge(this.statusHelper.createError("Error when reloading libraries after maintenance actions.", (Throwable)e));
        }
    }
}

