/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.PluginStatusDialog;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTreeViewer;
import org.eclipse.pde.internal.ui.shared.FilteredCheckboxTree;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.ui.launcher.BundlesTab;
import org.eclipse.pde.ui.launcher.PluginsTab;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class FeatureBlock {
    private static final int COLUMN_FEATURE_NAME = 0;
    private static final int COLUMN_PLUGIN_RESOLUTION = 1;
    private static final String COLUMN_ID = "columnID";
    private static final String PROPERTY_RESOLUTION = "resolution";
    private Button fAddRequiredFeaturesButton;
    private Button fDefaultsButton;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Button fWorkspacePluginButton;
    private Button fExternalPluginButton;
    private Button fFilterButton;
    private Label fCounter;
    private Button fFeatureWorkspaceButton;
    private Button fAutoValidate;
    private Button fValidateButton;
    private Button fSelectFeaturesButton;
    private Button fAddPluginButton;
    private Button fRemovePluginButton;
    private ILaunchConfiguration fLaunchConfig;
    private ButtonSelectionListener fListener;
    private AbstractLauncherTab fTab;
    private CachedCheckboxTreeViewer fTree;
    private LaunchValidationOperation fOperation;
    private ViewerFilter fSelectedOnlyFilter;
    private boolean fIsDisposed = false;
    private PluginStatusDialog fDialog;
    private Map<String, FeatureLaunchModel> fFeatureModels;
    private List<PluginLaunchModel> fAdditionalPlugins;
    private NamedElement fAdditionalPluginsParentElement;

    public String getResolutionLabel(String pluginResolution) {
        if (pluginResolution.equalsIgnoreCase("default")) {
            return PDEUIMessages.FeatureBlock_default;
        }
        if (pluginResolution.equalsIgnoreCase("workspace")) {
            return PDEUIMessages.FeatureBlock_WorkspaceResolutionLabel;
        }
        if (pluginResolution.equalsIgnoreCase("external")) {
            return PDEUIMessages.FeatureBlock_ExternalResolutionLabel;
        }
        return "";
    }

    public FeatureBlock(AbstractLauncherTab pluginsTab) {
        Assert.isNotNull((Object)((Object)pluginsTab));
        this.fTab = pluginsTab;
        PDEPlugin.getDefault().getLabelProvider().connect(this);
    }

    public void createControl(Composite parent, int span, int indent) {
        this.fListener = new ButtonSelectionListener();
        this.fSelectedOnlyFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return FeatureBlock.this.fTree.getChecked(element);
            }
        };
        Composite composite = SWTFactory.createComposite(parent, 1, span, 1808, 0, 0);
        Composite treeGroup = SWTFactory.createComposite(composite, 2, 1, 1808, 0, 0);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = indent;
        treeGroup.setLayoutData((Object)gd);
        SWTFactory.createLabel(treeGroup, PDEUIMessages.FeatureBlock_FeatureGroupDescription, 2);
        this.createCheckBoxTree(treeGroup);
        this.createButtonContainer(treeGroup, 10);
        this.fFeatureWorkspaceButton = SWTFactory.createCheckButton(treeGroup, PDEUIMessages.FeatureBlock_UseWorkspaceFeatures, null, true, 2);
        this.fFeatureWorkspaceButton.addSelectionListener((SelectionListener)this.fListener);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        Composite validatecomp = SWTFactory.createComposite(composite, 2, 1, 768, 0, 0);
        gd = new GridData(768);
        gd.horizontalIndent = indent;
        validatecomp.setLayoutData((Object)gd);
        this.fAutoValidate = this.fTab instanceof PluginsTab ? SWTFactory.createCheckButton(validatecomp, PDEUIMessages.PluginsTabToolBar_auto_validate_plugins, null, false, 1) : (this.fTab instanceof BundlesTab ? SWTFactory.createCheckButton(validatecomp, PDEUIMessages.PluginsTabToolBar_auto_validate_bundles, null, false, 1) : SWTFactory.createCheckButton(validatecomp, NLS.bind((String)PDEUIMessages.PluginsTabToolBar_auto_validate, (Object)this.fTab.getName().replaceAll("&", "").toLowerCase(Locale.ENGLISH)), null, false, 1));
        this.fAutoValidate.addSelectionListener((SelectionListener)this.fListener);
        Composite rightAlignComp = SWTFactory.createComposite(validatecomp, 1, 1, 0, 0, 0);
        rightAlignComp.setLayoutData((Object)new GridData(131072, 1024, true, true));
        this.fValidateButton = this.fTab instanceof PluginsTab ? SWTFactory.createPushButton(rightAlignComp, PDEUIMessages.PluginsTabToolBar_validate_plugins, null) : (this.fTab instanceof BundlesTab ? SWTFactory.createPushButton(rightAlignComp, PDEUIMessages.PluginsTabToolBar_validate_bundles, null) : SWTFactory.createPushButton(rightAlignComp, NLS.bind((String)PDEUIMessages.PluginsTabToolBar_validate, (Object)this.fTab.getName().replaceAll("&", "")), null));
        this.fValidateButton.addSelectionListener((SelectionListener)this.fListener);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        this.fIsDisposed = true;
    }

    private void createCheckBoxTree(Composite parent) {
        PatternFilter filter = new PatternFilter(){

            public boolean isElementVisible(Viewer viewer, Object element) {
                if (element instanceof FeatureLaunchModel) {
                    return super.isElementVisible(viewer, (Object)((FeatureLaunchModel)element).getId());
                }
                if (element instanceof PluginLaunchModel) {
                    return super.isElementVisible(viewer, (Object)((PluginLaunchModel)element).getPluginModelId());
                }
                return super.isElementVisible(viewer, element);
            }
        };
        filter.setIncludeLeadingWildcard(true);
        FilteredCheckboxTree tree = new FilteredCheckboxTree(parent, null, 65536, filter){

            @Override
            protected WorkbenchJob doCreateRefreshJob() {
                WorkbenchJob job = super.doCreateRefreshJob();
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (event.getResult().isOK()) {
                            this.getDisplay().asyncExec(() -> {
                                FeatureBlock.this.fTree.getControl().setRedraw(false);
                                FeatureBlock.this.fTree.removeFilter(FeatureBlock.this.fSelectedOnlyFilter);
                                FeatureBlock.this.fTree.restoreLeafCheckState();
                                try {
                                    if (FeatureBlock.this.fLaunchConfig.getAttribute("show_selected_only", false)) {
                                        FeatureBlock.this.fTree.addFilter(FeatureBlock.this.fSelectedOnlyFilter);
                                    }
                                }
                                catch (CoreException coreException) {}
                                FeatureBlock.this.fTree.getControl().setRedraw(true);
                            });
                        }
                    }
                });
                return job;
            }
        };
        GridData gd = new GridData(1808);
        tree.setLayoutData(gd);
        this.fTree = tree.getCheckboxTreeViewer();
        this.fTree.getControl().setFont(parent.getFont());
        tree.getFilterControl().setFont(parent.getFont());
        TreeColumn column1 = new TreeColumn(this.fTree.getTree(), 16384);
        column1.setText(PDEUIMessages.FeatureBlock_features);
        column1.setWidth(400);
        column1.addSelectionListener((SelectionListener)this.fListener);
        column1.setData(COLUMN_ID, (Object)0);
        TreeColumn column2 = new TreeColumn(this.fTree.getTree(), 0x1000000);
        column2.setText(PDEUIMessages.FeatureBlock_pluginResolution);
        column2.setWidth(100);
        column2.addSelectionListener((SelectionListener)this.fListener);
        column2.setData(COLUMN_ID, (Object)1);
        this.fTree.getTree().setHeaderVisible(true);
        this.fTree.setLabelProvider((IBaseLabelProvider)new FeatureTreeLabelProvider());
        this.fTree.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fTree.addCheckStateListener(event -> {
            this.updateCounter();
            this.fTab.updateLaunchConfigurationDialog();
        });
        String[] items = new String[]{PDEUIMessages.FeatureBlock_default, PDEUIMessages.FeatureBlock_WorkspaceResolutionLabel, PDEUIMessages.FeatureBlock_ExternalResolutionLabel};
        ComboBoxCellEditor cellEditor = new ComboBoxCellEditor((Composite)this.fTree.getTree(), items);
        cellEditor.getControl().pack();
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = cellEditor;
        this.fTree.setCellEditors(cellEditorArray);
        String[] stringArray = new String[2];
        stringArray[1] = PROPERTY_RESOLUTION;
        this.fTree.setColumnProperties(stringArray);
        this.fTree.setCellModifier(new LocationCellModifier());
        this.fTree.addDoubleClickListener(event -> {
            Object element;
            ISelection selection = event.getSelection();
            if (selection == null || !(selection instanceof IStructuredSelection)) {
                return;
            }
            this.fTree.setChecked(element, !this.fTree.getChecked(element = ((IStructuredSelection)selection).getFirstElement()));
            this.fTab.updateLaunchConfigurationDialog();
        });
        this.fTree.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)this.fTree.getSelection();
            boolean allPlugins = true;
            for (Object element : selection) {
                if (element instanceof PluginLaunchModel) continue;
                allPlugins = false;
            }
            this.fRemovePluginButton.setEnabled(allPlugins);
        });
        this.fTree.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    IStructuredSelection selection = (IStructuredSelection)FeatureBlock.this.fTree.getSelection();
                    int index = FeatureBlock.this.fAdditionalPlugins.indexOf(selection.getFirstElement());
                    List input = (List)FeatureBlock.this.fTree.getInput();
                    for (Object element : selection) {
                        if (!(element instanceof PluginLaunchModel)) continue;
                        FeatureBlock.this.fAdditionalPlugins.remove(element);
                        FeatureBlock.this.fTree.remove(element);
                        input.remove(element);
                    }
                    if (FeatureBlock.this.fAdditionalPlugins.isEmpty()) {
                        FeatureBlock.this.fTree.remove(FeatureBlock.this.fAdditionalPluginsParentElement);
                        input.remove(FeatureBlock.this.fAdditionalPluginsParentElement);
                        FeatureBlock.this.fRemovePluginButton.setEnabled(false);
                    } else {
                        FeatureBlock.this.fTree.setSelection((ISelection)new StructuredSelection(FeatureBlock.this.fAdditionalPlugins.get(--index > 0 ? index : 0)), true);
                        FeatureBlock.this.fRemovePluginButton.setEnabled(true);
                    }
                    FeatureBlock.this.updateCounter();
                    FeatureBlock.this.fTab.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    private void createButtonContainer(Composite parent, int vOffset) {
        Composite buttonComp = SWTFactory.createComposite(parent, 1, 1, 1040);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = vOffset;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(1040));
        this.fSelectAllButton = SWTFactory.createPushButton(buttonComp, PDEUIMessages.AdvancedLauncherTab_selectAll, null);
        this.fSelectAllButton.addSelectionListener((SelectionListener)this.fListener);
        this.fDeselectAllButton = SWTFactory.createPushButton(buttonComp, PDEUIMessages.AdvancedLauncherTab_deselectAll, null);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)this.fListener);
        this.fSelectFeaturesButton = SWTFactory.createPushButton(buttonComp, PDEUIMessages.FeatureBlock_SelectFeatures, null);
        this.fSelectFeaturesButton.addSelectionListener((SelectionListener)this.fListener);
        this.fAddRequiredFeaturesButton = SWTFactory.createPushButton(buttonComp, PDEUIMessages.FeatureBlock_addRequiredFeatues, null);
        this.fAddRequiredFeaturesButton.addSelectionListener((SelectionListener)this.fListener);
        this.fAddPluginButton = this.fTab instanceof PluginsTab ? SWTFactory.createPushButton(buttonComp, PDEUIMessages.FeatureBlock_AddPluginsLabel_plugins, null) : (this.fTab instanceof BundlesTab ? SWTFactory.createPushButton(buttonComp, PDEUIMessages.FeatureBlock_AddPluginsLabel_bundles, null) : SWTFactory.createPushButton(buttonComp, NLS.bind((String)PDEUIMessages.FeatureBlock_AddPluginsLabel, (Object)this.fTab.getName().replaceAll("&", "")), null));
        this.fAddPluginButton.addSelectionListener((SelectionListener)this.fListener);
        this.fRemovePluginButton = this.fTab instanceof PluginsTab ? SWTFactory.createPushButton(buttonComp, PDEUIMessages.FeatureBlock_RemovePluginsLabel_plugins, null) : (this.fTab instanceof BundlesTab ? SWTFactory.createPushButton(buttonComp, PDEUIMessages.FeatureBlock_RemovePluginsLabel_bundles, null) : SWTFactory.createPushButton(buttonComp, NLS.bind((String)PDEUIMessages.FeatureBlock_RemovePluginsLabel, (Object)this.fTab.getName().replaceAll("&", "")), null));
        this.fRemovePluginButton.addSelectionListener((SelectionListener)this.fListener);
        this.fRemovePluginButton.setEnabled(false);
        this.fDefaultsButton = SWTFactory.createPushButton(buttonComp, PDEUIMessages.AdvancedLauncherTab_defaults, null);
        this.fDefaultsButton.addSelectionListener((SelectionListener)this.fListener);
        SWTFactory.createLabel(buttonComp, PDEUIMessages.FeatureBlock_defaultPluginResolution, 1);
        this.fWorkspacePluginButton = SWTFactory.createRadioButton(buttonComp, PDEUIMessages.FeatureBlock_workspaceBefore);
        this.fWorkspacePluginButton.addSelectionListener((SelectionListener)this.fListener);
        this.fExternalPluginButton = SWTFactory.createRadioButton(buttonComp, PDEUIMessages.FeatureBlock_externalBefore);
        this.fExternalPluginButton.addSelectionListener((SelectionListener)this.fListener);
        Composite countComp = SWTFactory.createComposite(buttonComp, 1, 1, 0, 0, 0);
        countComp.setLayoutData((Object)new GridData(16384, 1024, true, true));
        this.fFilterButton = SWTFactory.createCheckButton(countComp, NLS.bind((String)PDEUIMessages.AdvancedLauncherTab_selectedBundles, (Object)""), null, false, 1);
        this.fFilterButton.addSelectionListener((SelectionListener)this.fListener);
        this.fCounter = SWTFactory.createLabel(countComp, "", 1);
        Image siteImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_SITE_OBJ);
        this.fAdditionalPluginsParentElement = this.fTab instanceof PluginsTab ? new NamedElement(PDEUIMessages.FeatureBlock_AdditionalPluginsEntry_plugins, siteImage) : (this.fTab instanceof BundlesTab ? new NamedElement(PDEUIMessages.FeatureBlock_AdditionalPluginsEntry_bundles, siteImage) : new NamedElement(NLS.bind((String)PDEUIMessages.FeatureBlock_AdditionalPluginsEntry, (Object)this.fTab.getName().replaceAll("&", "")), siteImage));
    }

    public void initialize() throws CoreException {
        this.initializeFrom(this.fLaunchConfig);
    }

    public void initializeFrom(ILaunchConfiguration config) throws CoreException {
        this.fLaunchConfig = config;
        this.fTree.removeFilter(this.fSelectedOnlyFilter);
        this.setInput(config, (CheckboxTreeViewer)this.fTree);
        String pluginResolution = config.getAttribute("featurePluginResolution", "workspace");
        if (pluginResolution.equalsIgnoreCase("workspace")) {
            this.fWorkspacePluginButton.setSelection(true);
            this.fExternalPluginButton.setSelection(false);
        } else {
            this.fWorkspacePluginButton.setSelection(false);
            this.fExternalPluginButton.setSelection(true);
        }
        String featureLocation = config.getAttribute("featureDefaultLocation", "workspace");
        this.fFeatureWorkspaceButton.setSelection(featureLocation.equalsIgnoreCase("workspace"));
        this.fAutoValidate.setSelection(config.getAttribute("automaticValidate", true));
        if (this.fLaunchConfig.isWorkingCopy()) {
            this.savePluginState((ILaunchConfigurationWorkingCopy)this.fLaunchConfig);
        }
        PDEPreferencesManager prefs = new PDEPreferencesManager("org.eclipse.pde.ui");
        int index = prefs.getInt("Preferences.RunConfigs.Feature.SortColumn");
        TreeColumn column = this.fTree.getTree().getColumn(index == 0 ? 0 : index - 1);
        this.fListener.handleColumn(column, prefs.getInt("Preferences.RunConfigs.Feature.SortOrder"));
        this.fRemovePluginButton.setEnabled(false);
        this.fFilterButton.setSelection(config.getAttribute("show_selected_only", false));
        if (this.fFilterButton.getSelection()) {
            this.fTree.addFilter(this.fSelectedOnlyFilter);
        }
        this.fTree.setAutoExpandLevel(-1);
        this.fTree.expandAll();
        this.fTree.refresh(true);
        this.fTab.updateLaunchConfigurationDialog();
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("show_selected_only", this.fFilterButton.getSelection());
        config.setAttribute("featureDefaultLocation", this.fFeatureWorkspaceButton.getSelection() ? "workspace" : "external");
        config.setAttribute("featurePluginResolution", this.fWorkspacePluginButton.getSelection() ? "workspace" : "external");
        config.setAttribute("automaticValidate", this.fAutoValidate.getSelection());
        this.savePluginState(config);
        this.saveSortOrder();
        this.updateCounter();
    }

    private void savePluginState(ILaunchConfigurationWorkingCopy config) {
        Object[] models;
        HashSet<String> featuresEntry = new HashSet<String>();
        HashSet<String> pluginsEntry = new HashSet<String>();
        ArrayList<PluginLaunchModel> checkPluginLaunchModels = new ArrayList<PluginLaunchModel>();
        Object[] objectArray = models = this.fTree.getCheckedElements();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            Object model = objectArray[n2];
            if (model instanceof FeatureLaunchModel) {
                FeatureLaunchModel featureModel = (FeatureLaunchModel)model;
                StringBuilder buffer = new StringBuilder();
                buffer.append(featureModel.getId());
                buffer.append(':');
                buffer.append(featureModel.getResolutionValue());
                featuresEntry.add(buffer.toString());
            } else if (model instanceof PluginLaunchModel) {
                PluginLaunchModel pluginLaunchModel = (PluginLaunchModel)model;
                String entry = BundleLauncherHelper.writeAdditionalPluginsEntry((IPluginModelBase)pluginLaunchModel.getPluginModelBase(), (String)pluginLaunchModel.getPluginResolution(), (boolean)true);
                pluginsEntry.add(entry);
                checkPluginLaunchModels.add(pluginLaunchModel);
            }
            ++n2;
        }
        for (PluginLaunchModel uncheckedPluginLaunchModel : this.fAdditionalPlugins) {
            if (checkPluginLaunchModels.contains(uncheckedPluginLaunchModel)) continue;
            String entry = BundleLauncherHelper.writeAdditionalPluginsEntry((IPluginModelBase)uncheckedPluginLaunchModel.getPluginModelBase(), (String)uncheckedPluginLaunchModel.getPluginResolution(), (boolean)false);
            pluginsEntry.add(entry);
        }
        config.setAttribute("selected_features", featuresEntry);
        config.setAttribute("additional_plugins", pluginsEntry);
    }

    private void saveSortOrder() {
        PDEPreferencesManager prefs = new PDEPreferencesManager("org.eclipse.pde.ui");
        Tree tree = this.fTree.getTree();
        TreeColumn column = tree.getSortColumn();
        int index = column == null ? 0 : (Integer)tree.getSortColumn().getData(COLUMN_ID);
        prefs.setValue("Preferences.RunConfigs.Feature.SortColumn", index + 1);
        int sortOrder = column == null ? 0 : tree.getSortDirection();
        prefs.setValue("Preferences.RunConfigs.Feature.SortOrder", sortOrder);
        prefs.savePluginPreferences();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("show_selected_only", false);
        config.setAttribute("featureDefaultLocation", "workspace");
        config.setAttribute("featurePluginResolution", "workspace");
        config.setAttribute("automaticValidate", true);
    }

    private void updateCounter() {
        if (this.fCounter != null) {
            int checked = this.fTree.getCheckedLeafCount();
            int total = this.fFeatureModels.values().size() + this.fAdditionalPlugins.size();
            this.fCounter.setText(NLS.bind((String)PDEUIMessages.AbstractPluginBlock_counter, (Object)checked, (Object)total));
        }
    }

    public void setVisible(boolean visible) {
        if (!visible && this.fDialog != null) {
            this.fDialog.close();
            this.fDialog = null;
        }
    }

    protected void setInput(ILaunchConfiguration config, CheckboxTreeViewer tree) {
        IFeatureModel[] externalModels;
        Object id;
        IFeatureModel[] workspaceModels;
        LinkedHashMap<String, FeatureLaunchModel> featureModels = new LinkedHashMap<String, FeatureLaunchModel>();
        FeatureModelManager fmm = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel[] iFeatureModelArray = workspaceModels = fmm.getWorkspaceModels();
        int n = workspaceModels.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel workspaceModel = iFeatureModelArray[n2];
            id = workspaceModel.getFeature().getId();
            if (id != null) {
                featureModels.put((String)id, new FeatureLaunchModel(workspaceModel, null));
            }
            ++n2;
        }
        id = externalModels = fmm.getExternalModels();
        int n3 = externalModels.length;
        n = 0;
        while (n < n3) {
            IFeatureModel externalModel = id[n];
            String id2 = externalModel.getFeature().getId();
            if (id2 != null) {
                if (featureModels.containsKey(id2)) {
                    FeatureLaunchModel launchModel = (FeatureLaunchModel)featureModels.get(id2);
                    launchModel.setTargetModel(externalModel);
                } else {
                    featureModels.put(id2, new FeatureLaunchModel(null, externalModel));
                }
            }
            ++n;
        }
        this.fFeatureModels = featureModels;
        try {
            this.fAdditionalPlugins = new ArrayList<PluginLaunchModel>();
            ArrayList<PluginLaunchModel> checkedAdditionalPlugins = new ArrayList<PluginLaunchModel>();
            HashMap allAdditionalMap = BundleLauncherHelper.getAdditionalPlugins((ILaunchConfiguration)config, (boolean)false);
            HashMap checkedAdditionalMap = BundleLauncherHelper.getAdditionalPlugins((ILaunchConfiguration)config, (boolean)true);
            for (Object name : allAdditionalMap.keySet()) {
                IPluginModelBase model = (IPluginModelBase)name;
                PluginLaunchModel launchModel = new PluginLaunchModel(model, (String)allAdditionalMap.get(model));
                this.fAdditionalPlugins.add(launchModel);
                if (!checkedAdditionalMap.containsKey(model)) continue;
                checkedAdditionalPlugins.add(launchModel);
            }
            ArrayList<FeatureLaunchModel> models = new ArrayList<FeatureLaunchModel>(this.fFeatureModels.values());
            if (this.fAdditionalPlugins.size() > 0) {
                models.add((FeatureLaunchModel)((Object)this.fAdditionalPluginsParentElement));
            }
            tree.setInput(models);
            Set selected = config.getAttribute("selected_features", null);
            if (selected == null) {
                tree.setCheckedElements(this.fFeatureModels.values().toArray());
            } else {
                ArrayList<FeatureLaunchModel> selectedFeatureList = new ArrayList<FeatureLaunchModel>();
                for (Object name : selected) {
                    String id3;
                    FeatureLaunchModel model;
                    String currentSelected = (String)name;
                    String[] attributes = currentSelected.split(":");
                    if (attributes.length <= 0 || (model = this.fFeatureModels.get(id3 = attributes[0])) == null) continue;
                    selectedFeatureList.add(model);
                    if (attributes.length <= 1) continue;
                    model.setPluginResolution(attributes[1]);
                }
                ArrayList<Object> checkedElements = new ArrayList<Object>();
                checkedElements.addAll(selectedFeatureList);
                checkedElements.addAll(checkedAdditionalPlugins);
                tree.setCheckedElements(checkedElements.toArray());
            }
        }
        catch (CoreException e) {
            PDELaunchingPlugin.log((Throwable)e);
        }
        this.updateCounter();
    }

    class ButtonSelectionListener
    extends SelectionAdapter {
        ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == FeatureBlock.this.fValidateButton) {
                this.handleValidate();
            } else if (source == FeatureBlock.this.fSelectFeaturesButton) {
                this.handleSelectFeatures();
            } else if (source == FeatureBlock.this.fAddPluginButton) {
                this.handleAddPlugin();
            } else if (source == FeatureBlock.this.fSelectAllButton) {
                this.handleSelectAll(true);
            } else if (source == FeatureBlock.this.fDeselectAllButton) {
                this.handleSelectAll(false);
            } else if (source == FeatureBlock.this.fAddRequiredFeaturesButton) {
                this.handleAddRequired();
            } else if (source == FeatureBlock.this.fDefaultsButton) {
                this.handleRestoreDefaults();
            } else if (source == FeatureBlock.this.fRemovePluginButton) {
                this.handleRemovePlugin();
            } else if (source == FeatureBlock.this.fFilterButton) {
                this.handleFilterButton();
            } else if (source instanceof TreeColumn) {
                this.handleColumn((TreeColumn)source, 0);
            }
            if (!FeatureBlock.this.fIsDisposed) {
                FeatureBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        }

        private void handleSelectFeatures() {
            ArrayList<IFeatureModel> featureModels = new ArrayList<IFeatureModel>();
            for (FeatureLaunchModel model : FeatureBlock.this.fFeatureModels.values()) {
                if (FeatureBlock.this.fTree.getChecked(model)) continue;
                featureModels.add(model.getModel(true));
            }
            if (featureModels.isEmpty()) {
                MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.FeatureSelectionDialog_title, (String)PDEUIMessages.FeatureBlock_AllFeatureSelected);
                return;
            }
            FeatureSelectionDialog dialog = new FeatureSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), featureModels.toArray(new IFeatureModel[featureModels.size()]), true);
            dialog.create();
            if (dialog.open() == 0) {
                Object[] selectedModels;
                FeatureBlock.this.fTree.getControl().setRedraw(false);
                FeatureBlock.this.fTree.removeFilter(FeatureBlock.this.fSelectedOnlyFilter);
                Object[] objectArray = selectedModels = dialog.getResult();
                int n = selectedModels.length;
                int n2 = 0;
                while (n2 < n) {
                    Object model = objectArray[n2];
                    String id = ((IFeatureModel)model).getFeature().getId();
                    FeatureBlock.this.fTree.setChecked(FeatureBlock.this.fFeatureModels.get(id), true);
                    ++n2;
                }
                if (FeatureBlock.this.fFilterButton.getSelection()) {
                    FeatureBlock.this.fTree.addFilter(FeatureBlock.this.fSelectedOnlyFilter);
                }
                FeatureBlock.this.fTree.getControl().setRedraw(true);
                FeatureBlock.this.updateCounter();
            }
        }

        private void handleFilterButton() {
            if (FeatureBlock.this.fFilterButton.getSelection()) {
                FeatureBlock.this.fTree.addFilter(FeatureBlock.this.fSelectedOnlyFilter);
            } else {
                FeatureBlock.this.fTree.removeFilter(FeatureBlock.this.fSelectedOnlyFilter);
            }
            FeatureBlock.this.fTree.expandAll();
        }

        private void handleRemovePlugin() {
            ITreeSelection selection = FeatureBlock.this.fTree.getStructuredSelection();
            int index = FeatureBlock.this.fAdditionalPlugins.indexOf(selection.getFirstElement());
            FeatureBlock.this.fAdditionalPlugins.removeAll(selection.toList());
            FeatureBlock.this.fTree.remove(selection.toArray());
            List input = (List)FeatureBlock.this.fTree.getInput();
            input.removeAll(selection.toList());
            if (FeatureBlock.this.fAdditionalPlugins.isEmpty()) {
                FeatureBlock.this.fTree.remove(FeatureBlock.this.fAdditionalPluginsParentElement);
                input.remove(FeatureBlock.this.fAdditionalPluginsParentElement);
                FeatureBlock.this.fRemovePluginButton.setEnabled(false);
            } else {
                FeatureBlock.this.fTree.setSelection((ISelection)new StructuredSelection(FeatureBlock.this.fAdditionalPlugins.get(--index > 0 ? index : 0)), true);
                FeatureBlock.this.fRemovePluginButton.setEnabled(true);
            }
            FeatureBlock.this.updateCounter();
        }

        private void handleAddPlugin() {
            PluginSelectionDialog dialog = new PluginSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), this.getAvailablePlugins(), true);
            if (dialog.open() == 0) {
                Object[] models = dialog.getResult();
                ArrayList<PluginLaunchModel> modelList = new ArrayList<PluginLaunchModel>(models.length);
                Object[] objectArray = models;
                int n = models.length;
                int n2 = 0;
                while (n2 < n) {
                    Object model = objectArray[n2];
                    PluginLaunchModel pluginLaunchModel = new PluginLaunchModel((IPluginModelBase)model, "default");
                    modelList.add(pluginLaunchModel);
                    ++n2;
                }
                List input = (List)FeatureBlock.this.fTree.getInput();
                if (!input.contains(FeatureBlock.this.fAdditionalPluginsParentElement)) {
                    input.add(FeatureBlock.this.fAdditionalPluginsParentElement);
                }
                FeatureBlock.this.fAdditionalPlugins.addAll(modelList);
                FeatureBlock.this.fTree.getControl().setRedraw(false);
                FeatureBlock.this.fTree.removeFilter(FeatureBlock.this.fSelectedOnlyFilter);
                FeatureBlock.this.fTree.refresh();
                for (PluginLaunchModel model : modelList) {
                    FeatureBlock.this.fTree.setChecked(model, true);
                }
                FeatureBlock.this.fTree.setSelection((ISelection)new StructuredSelection(modelList.get(modelList.size() - 1)), true);
                FeatureBlock.this.fTree.getTree().setSortColumn(FeatureBlock.this.fTree.getTree().getSortColumn());
                FeatureBlock.this.fTree.getTree().setSortDirection(FeatureBlock.this.fTree.getTree().getSortDirection());
                if (FeatureBlock.this.fFilterButton.getSelection()) {
                    FeatureBlock.this.fTree.addFilter(FeatureBlock.this.fSelectedOnlyFilter);
                }
                FeatureBlock.this.fTree.getControl().setRedraw(true);
                FeatureBlock.this.updateCounter();
            }
        }

        private IPluginModelBase[] getAvailablePlugins() {
            IPluginModelBase[] plugins = PluginRegistry.getActiveModels((boolean)false);
            if (FeatureBlock.this.fAdditionalPlugins.isEmpty()) {
                return plugins;
            }
            HashSet<IPluginModelBase> additionalPlugins = new HashSet<IPluginModelBase>();
            for (PluginLaunchModel model : FeatureBlock.this.fAdditionalPlugins) {
                additionalPlugins.add(model.getPluginModelBase());
            }
            ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
            int i = 0;
            while (i < plugins.length) {
                if (!additionalPlugins.contains(plugins[i])) {
                    result.add(plugins[i]);
                }
                ++i;
            }
            return result.toArray(new IPluginModelBase[result.size()]);
        }

        private void handleValidate() {
            if (FeatureBlock.this.fOperation == null) {
                FeatureBlock.this.fOperation = new LaunchValidationOperation(FeatureBlock.this.fLaunchConfig){

                    protected IPluginModelBase[] getModels() throws CoreException {
                        boolean isOSGiTab = FeatureBlock.this.fTab.getId().equals("org.eclipse.pde.ui.launch.tab.osgi.bundles");
                        return BundleLauncherHelper.getMergedBundles((ILaunchConfiguration)this.fLaunchConfiguration, (boolean)isOSGiTab);
                    }
                };
            }
            try {
                FeatureBlock.this.fOperation.run((IProgressMonitor)new NullProgressMonitor());
                if (FeatureBlock.this.fDialog == null) {
                    if (FeatureBlock.this.fOperation.hasErrors()) {
                        FeatureBlock.this.fDialog = new PluginStatusDialog(this.getShell(), 2160);
                        FeatureBlock.this.fDialog.setInput(FeatureBlock.this.fOperation.getInput());
                        FeatureBlock.this.fDialog.open();
                        FeatureBlock.this.fDialog = null;
                    } else if (FeatureBlock.this.fOperation.isEmpty()) {
                        if (FeatureBlock.this.fTab instanceof PluginsTab) {
                            MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)PDEUIMessages.AbstractLauncherToolbar_noSelection_plugins);
                        } else if (FeatureBlock.this.fTab instanceof BundlesTab) {
                            MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)PDEUIMessages.AbstractLauncherToolbar_noSelection_bundles);
                        } else {
                            MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)NLS.bind((String)PDEUIMessages.AbstractLauncherToolbar_noSelection, (Object)FeatureBlock.this.fTab.getName().toLowerCase(Locale.ENGLISH)));
                        }
                    } else {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)PDEUIMessages.AbstractLauncherToolbar_noProblems);
                    }
                } else if (FeatureBlock.this.fOperation.getInput().size() > 0) {
                    FeatureBlock.this.fDialog.refresh(FeatureBlock.this.fOperation.getInput());
                } else {
                    HashMap<String, IStatus> input = new HashMap<String, IStatus>(1);
                    input.put(PDEUIMessages.AbstractLauncherToolbar_noProblems, Status.OK_STATUS);
                    FeatureBlock.this.fDialog.refresh(input);
                }
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        }

        private Shell getShell() {
            try {
                Control c = FeatureBlock.this.fTab.getControl();
                if (!c.isDisposed()) {
                    return c.getShell();
                }
            }
            catch (SWTException sWTException) {}
            return PDEPlugin.getActiveWorkbenchShell();
        }

        private void handleAddRequired() {
            if (FeatureBlock.this.fTree.getCheckedElements() != null && FeatureBlock.this.fTree.getCheckedElements().length > 0) {
                Object[] features = FeatureBlock.this.fTree.getCheckedElements();
                HashSet<String> requiredFeatureIDs = new HashSet<String>();
                Object[] objectArray = features;
                int n = features.length;
                int n2 = 0;
                while (n2 < n) {
                    Object feature = objectArray[n2];
                    if (feature instanceof FeatureLaunchModel) {
                        requiredFeatureIDs.add(((FeatureLaunchModel)feature).getId());
                        this.getFeatureDependencies(((FeatureLaunchModel)feature).getModel(FeatureBlock.this.fFeatureWorkspaceButton.getSelection()), requiredFeatureIDs);
                    }
                    ++n2;
                }
                FeatureBlock.this.fTree.getControl().setRedraw(false);
                FeatureBlock.this.fTree.removeFilter(FeatureBlock.this.fSelectedOnlyFilter);
                for (String featureId : requiredFeatureIDs) {
                    Object featureModel = FeatureBlock.this.fFeatureModels.get(featureId);
                    if (featureModel == null) continue;
                    FeatureBlock.this.fTree.setChecked(featureModel, true);
                }
                if (FeatureBlock.this.fFilterButton.getSelection()) {
                    FeatureBlock.this.fTree.addFilter(FeatureBlock.this.fSelectedOnlyFilter);
                }
                FeatureBlock.this.fTree.getControl().setRedraw(true);
                FeatureBlock.this.updateCounter();
            }
        }

        private void getFeatureDependencies(IFeatureModel model, Set<String> requiredFeatureIDs) {
            IFeatureChild[] featureIncludes;
            IFeatureImport[] featureImports;
            IFeature feature = model.getFeature();
            IFeatureImport[] iFeatureImportArray = featureImports = feature.getImports();
            int n = featureImports.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureImport featureImport = iFeatureImportArray[n2];
                if (featureImport.getType() == 1) {
                    this.addFeature(requiredFeatureIDs, featureImport.getId());
                }
                ++n2;
            }
            IFeatureChild[] iFeatureChildArray = featureIncludes = feature.getIncludedFeatures();
            int n3 = featureIncludes.length;
            n = 0;
            while (n < n3) {
                IFeatureChild featureInclude = iFeatureChildArray[n];
                this.addFeature(requiredFeatureIDs, featureInclude.getId());
                ++n;
            }
        }

        private void addFeature(Set<String> requiredFeatureIDs, String id) {
            FeatureLaunchModel model;
            if (!requiredFeatureIDs.contains(id) && (model = (FeatureLaunchModel)FeatureBlock.this.fFeatureModels.get(id)) != null) {
                requiredFeatureIDs.add(id);
                this.getFeatureDependencies(model.getModel(FeatureBlock.this.fFeatureWorkspaceButton.getSelection()), requiredFeatureIDs);
            }
        }

        private void handleColumn(TreeColumn tc, int sortDirn) {
            Tree tree = FeatureBlock.this.fTree.getTree();
            tree.setSortColumn(tc);
            if (sortDirn == 0) {
                switch (tree.getSortDirection()) {
                    case 1024: {
                        sortDirn = 128;
                        break;
                    }
                    default: {
                        sortDirn = 1024;
                    }
                }
            }
            tree.setSortDirection(sortDirn);
            int sortOrder = sortDirn == 128 ? -1 : 1;
            int sortColumn = (Integer)tc.getData(FeatureBlock.COLUMN_ID);
            FeatureBlock.this.fTree.setComparator(new TreeSorter(sortColumn, sortOrder));
            FeatureBlock.this.saveSortOrder();
        }

        private void handleRestoreDefaults() {
            FeatureBlock.this.fWorkspacePluginButton.setSelection(true);
            FeatureBlock.this.fExternalPluginButton.setSelection(false);
            List input = (List)FeatureBlock.this.fTree.getInput();
            input.removeAll(FeatureBlock.this.fAdditionalPlugins);
            input.remove(FeatureBlock.this.fAdditionalPluginsParentElement);
            FeatureBlock.this.fAdditionalPlugins.clear();
            FeatureBlock.this.fRemovePluginButton.setEnabled(false);
            for (FeatureLaunchModel model : FeatureBlock.this.fFeatureModels.values()) {
                model.setPluginResolution("default");
            }
            FeatureBlock.this.fTree.getControl().setRedraw(false);
            FeatureBlock.this.fTree.removeFilter(FeatureBlock.this.fSelectedOnlyFilter);
            FeatureBlock.this.fTree.setCheckedElements(new Object[0]);
            FeatureBlock.this.fTree.refresh();
            FeatureBlock.this.fTree.setAllChecked(true);
            if (FeatureBlock.this.fFilterButton.getSelection()) {
                FeatureBlock.this.fTree.addFilter(FeatureBlock.this.fSelectedOnlyFilter);
            }
            FeatureBlock.this.fTree.getControl().setRedraw(true);
            FeatureBlock.this.updateCounter();
        }

        private void handleSelectAll(boolean state) {
            FeatureBlock.this.fTree.getControl().setRedraw(false);
            FeatureBlock.this.fTree.removeFilter(FeatureBlock.this.fSelectedOnlyFilter);
            FeatureBlock.this.fTree.setAllChecked(state);
            if (FeatureBlock.this.fFilterButton.getSelection()) {
                FeatureBlock.this.fTree.addFilter(FeatureBlock.this.fSelectedOnlyFilter);
            }
            FeatureBlock.this.fTree.getControl().setRedraw(true);
            FeatureBlock.this.updateCounter();
        }
    }

    class FeatureLaunchModel {
        public IFeatureModel fWorkspaceModel;
        public IFeatureModel fTargetModel;
        public String fPluginResolution;

        public FeatureLaunchModel(IFeatureModel workspaceModel, IFeatureModel targetModel) {
            this.fWorkspaceModel = workspaceModel;
            this.fTargetModel = targetModel;
            this.fPluginResolution = "default";
        }

        public void setWorkspaceModel(IFeatureModel workspaceModel) {
            this.fWorkspaceModel = workspaceModel;
        }

        public void setTargetModel(IFeatureModel targetModel) {
            this.fTargetModel = targetModel;
        }

        public void setPluginResolution(String resolution) {
            this.fPluginResolution = resolution;
        }

        public String getId() {
            if (this.fWorkspaceModel != null) {
                return this.fWorkspaceModel.getFeature().getId();
            }
            if (this.fTargetModel != null) {
                return this.fTargetModel.getFeature().getId();
            }
            return "";
        }

        public String getVersion() {
            if (this.fWorkspaceModel != null) {
                return this.fWorkspaceModel.getFeature().getVersion();
            }
            if (this.fTargetModel != null) {
                return this.fTargetModel.getFeature().getVersion();
            }
            return "";
        }

        public IFeatureModel getModel(boolean workspaceFirst) {
            if (this.fWorkspaceModel == null) {
                return this.fTargetModel;
            }
            if (this.fTargetModel == null) {
                return this.fWorkspaceModel;
            }
            if (workspaceFirst) {
                return this.fWorkspaceModel;
            }
            return this.fTargetModel;
        }

        public String getResolutionValue() {
            return this.fPluginResolution;
        }

        public String toString() {
            if (this.fWorkspaceModel != null) {
                return String.valueOf(this.fWorkspaceModel.getFeature().getId()) + " " + this.fPluginResolution;
            }
            if (this.fTargetModel != null) {
                return String.valueOf(this.fTargetModel.getFeature().getId()) + " " + this.fPluginResolution;
            }
            return this.fPluginResolution;
        }
    }

    class FeatureTreeLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProvider {
        PDELabelProvider pdeLabelProvider = new PDELabelProvider();

        FeatureTreeLabelProvider() {
        }

        public Image getColumnImage(Object obj, int index) {
            ModelEntry modelEntry;
            PluginLaunchModel pluginLaunchModel;
            if (index == 0) {
                if (obj instanceof FeatureLaunchModel) {
                    FeatureLaunchModel model = (FeatureLaunchModel)obj;
                    return this.pdeLabelProvider.getImage(model.getModel(true));
                }
                if (obj instanceof NamedElement) {
                    return ((NamedElement)obj).getImage();
                }
                if (obj instanceof PluginLaunchModel) {
                    IPluginModelBase pluginModelBase = ((PluginLaunchModel)obj).getPluginModelBase();
                    return this.pdeLabelProvider.getColumnImage(pluginModelBase, index);
                }
            } else if (index == 1 && obj instanceof PluginLaunchModel && ("workspace".equalsIgnoreCase((pluginLaunchModel = (PluginLaunchModel)obj).getPluginResolution()) ? !(modelEntry = PluginRegistry.findEntry((String)pluginLaunchModel.getPluginModelId())).hasWorkspaceModels() : "external".equalsIgnoreCase(pluginLaunchModel.getPluginResolution()) && !(modelEntry = PluginRegistry.findEntry((String)pluginLaunchModel.getPluginModelId())).hasExternalModels())) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            return null;
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof NamedElement && index == 0) {
                return ((NamedElement)obj).getLabel();
            }
            if (obj instanceof PluginLaunchModel) {
                PluginLaunchModel pluginLaunchModel = (PluginLaunchModel)obj;
                switch (index) {
                    case 0: {
                        return pluginLaunchModel.getPluginModelId();
                    }
                    case 1: {
                        return FeatureBlock.this.getResolutionLabel(pluginLaunchModel.getPluginResolution());
                    }
                }
            }
            if (obj instanceof FeatureLaunchModel) {
                FeatureLaunchModel model = (FeatureLaunchModel)obj;
                switch (index) {
                    case 0: {
                        return model.getId();
                    }
                    case 1: {
                        return FeatureBlock.this.getResolutionLabel(model.getResolutionValue());
                    }
                }
                return "";
            }
            return "";
        }

        public void update(ViewerCell cell) {
            switch (cell.getColumnIndex()) {
                case 0: {
                    StyledString label = this.getStyledText(cell.getElement());
                    cell.setStyleRanges(label.getStyleRanges());
                    cell.setText(label.toString());
                    cell.setImage(this.getColumnImage(cell.getElement(), 0));
                    break;
                }
                case 1: {
                    cell.setText(this.getColumnText(cell.getElement(), 1));
                    cell.setImage(this.getColumnImage(cell.getElement(), 1));
                }
            }
            super.update(cell);
        }

        private StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString(this.getColumnText(element, 0));
            if (element instanceof FeatureLaunchModel) {
                FeatureLaunchModel featureModel = (FeatureLaunchModel)element;
                styledString.append(" (", StyledString.QUALIFIER_STYLER);
                String version = featureModel.getVersion();
                int index = version.indexOf(45);
                if (index > -1) {
                    version = version.substring(0, index);
                }
                styledString.append(version, StyledString.QUALIFIER_STYLER);
                styledString.append(")", StyledString.QUALIFIER_STYLER);
            } else if (element instanceof PluginLaunchModel) {
                PluginLaunchModel pluginLaunchModel = (PluginLaunchModel)element;
                styledString.append(" (", StyledString.QUALIFIER_STYLER);
                String version = pluginLaunchModel.getPluginModelBase().getPluginBase().getVersion();
                int index = version.indexOf(45);
                if (index > -1) {
                    version = version.substring(0, index);
                }
                styledString.append(version, StyledString.QUALIFIER_STYLER);
                styledString.append(")", StyledString.QUALIFIER_STYLER);
            }
            return styledString;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return this.getColumnText(element, 0);
        }
    }

    class LocationCellModifier
    implements ICellModifier {
        LocationCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (element instanceof FeatureLaunchModel || element instanceof PluginLaunchModel) {
                return FeatureBlock.this.fTree.getChecked(element);
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (property == FeatureBlock.PROPERTY_RESOLUTION) {
                if (element instanceof FeatureLaunchModel) {
                    String location = ((FeatureLaunchModel)element).getResolutionValue();
                    return this.getLocationIndex(location);
                }
                if (element instanceof PluginLaunchModel) {
                    String location = ((PluginLaunchModel)element).getPluginResolution();
                    return this.getLocationIndex(location);
                }
            }
            return null;
        }

        private Object getLocationIndex(String location) {
            if (location.equalsIgnoreCase("default")) {
                return 0;
            }
            if (location.equalsIgnoreCase("workspace")) {
                return 1;
            }
            if (location.equalsIgnoreCase("external")) {
                return 2;
            }
            return null;
        }

        public void modify(Object item, String property, Object value) {
            if (property == FeatureBlock.PROPERTY_RESOLUTION && value != null) {
                PluginLaunchModel pluginLaunchModel;
                Object data = ((TreeItem)item).getData();
                int comboIndex = (Integer)value;
                String location = this.getLocation(comboIndex);
                if (data instanceof FeatureLaunchModel) {
                    FeatureLaunchModel model = (FeatureLaunchModel)data;
                    if (!location.equalsIgnoreCase(model.getResolutionValue())) {
                        model.setPluginResolution(location);
                        FeatureBlock.this.fTree.refresh(model, true);
                        FeatureBlock.this.fTab.updateLaunchConfigurationDialog();
                    }
                } else if (data instanceof PluginLaunchModel && !location.equalsIgnoreCase((pluginLaunchModel = (PluginLaunchModel)data).getPluginResolution())) {
                    pluginLaunchModel.setPluginResolution(location);
                    FeatureBlock.this.fTree.refresh(pluginLaunchModel, true);
                    FeatureBlock.this.fTab.updateLaunchConfigurationDialog();
                }
            }
        }

        private String getLocation(int comboIndex) {
            String location = null;
            switch (comboIndex) {
                case 0: {
                    location = "default";
                    break;
                }
                case 1: {
                    location = "workspace";
                    break;
                }
                case 2: {
                    location = "external";
                }
            }
            return location;
        }
    }

    class PluginContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof Collection) {
                return ((Collection)input).toArray();
            }
            if (input instanceof Object[]) {
                return (Object[])input;
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == FeatureBlock.this.fAdditionalPluginsParentElement) {
                return FeatureBlock.this.fAdditionalPlugins.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof PluginLaunchModel) {
                return FeatureBlock.this.fAdditionalPluginsParentElement;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof NamedElement;
        }
    }

    class PluginLaunchModel {
        private IPluginModelBase fPluginModelBase;
        private String fPluginResolution;

        public PluginLaunchModel(IPluginModelBase pluginModelBase, String pluginResolution) {
            this.fPluginModelBase = pluginModelBase;
            this.fPluginResolution = pluginResolution;
        }

        public IPluginModelBase getPluginModelBase() {
            return this.fPluginModelBase;
        }

        public String getPluginResolution() {
            return this.fPluginResolution;
        }

        public void setPluginResolution(String pluginResolution) {
            this.fPluginResolution = pluginResolution;
        }

        public String getPluginModelId() {
            return this.fPluginModelBase.getPluginBase().getId();
        }

        public String getPluginModelVersion() {
            return this.fPluginModelBase.getPluginBase().getVersion();
        }
    }

    class TreeSorter
    extends ViewerComparator {
        int sortColumn;
        int sortOrder;

        public TreeSorter(int sortColumn, int sortOrder) {
            this.sortColumn = sortColumn;
            this.sortOrder = sortOrder;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 == FeatureBlock.this.fAdditionalPluginsParentElement) {
                return 1;
            }
            if (e2 == FeatureBlock.this.fAdditionalPluginsParentElement) {
                return -1;
            }
            FeatureTreeLabelProvider labelProvider = (FeatureTreeLabelProvider)FeatureBlock.this.fTree.getLabelProvider();
            return this.sortOrder * super.compare(viewer, (Object)labelProvider.getColumnText(e1, this.sortColumn), (Object)labelProvider.getColumnText(e2, this.sortColumn));
        }
    }
}

