/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EqualityOperator implements Enumerator
{
    SAME(0, "same", "==="),
    NSAME(1, "nsame", "!=="),
    EQ(2, "eq", "=="),
    NEQ(3, "neq", "!=");

    public static final int SAME_VALUE = 0;
    public static final int NSAME_VALUE = 1;
    public static final int EQ_VALUE = 2;
    public static final int NEQ_VALUE = 3;
    private static final EqualityOperator[] VALUES_ARRAY;
    public static final List<EqualityOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EqualityOperator[]{SAME, NSAME, EQ, NEQ};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EqualityOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EqualityOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EqualityOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EqualityOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EqualityOperator get(int value) {
        switch (value) {
            case 0: {
                return SAME;
            }
            case 1: {
                return NSAME;
            }
            case 2: {
                return EQ;
            }
            case 3: {
                return NEQ;
            }
        }
        return null;
    }

    private EqualityOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

