/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.inject.Singleton;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import org.eclipse.n4js.external.TargetPlatformInstallLocationProvider;
import org.eclipse.n4js.external.libraries.ExternalLibraryFolderUtils;
import org.eclipse.n4js.utils.io.FileUtils;

@Singleton
public class HlcTargetPlatformInstallLocationProvider
implements TargetPlatformInstallLocationProvider {
    private File targetPlatformInstallLocation;
    private URI targetPlatformFileLocation;
    private URI tempRoot;

    @Override
    public File getTargetPlatformInstallFolder() {
        return this.targetPlatformInstallLocation;
    }

    @Override
    public URI getTargetPlatformFileLocation() {
        return this.targetPlatformFileLocation;
    }

    public void setTargetPlatformInstallLocation(File targetPlatformInstallLocation) {
        this.targetPlatformInstallLocation = targetPlatformInstallLocation;
    }

    public void setTargetPlatformFileLocation(URI targetPlatformFileLocation) {
        this.targetPlatformFileLocation = targetPlatformFileLocation;
    }

    public void configureWithTempFolders() throws IOException {
        Path root = FileUtils.createTempDirectory((String)("hlcTmpDepsLocation_" + System.currentTimeMillis()));
        Path n4npm = FileUtils.createDirectory((Path)root, (String)".n4npm");
        File packageJson = new File(n4npm.toFile(), "package.json");
        packageJson.createNewFile();
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileWriter fw = new FileWriter(packageJson);){
            fw.write(ExternalLibraryFolderUtils.createTargetPlatformPackageJson());
            fw.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        packageJson.deleteOnExit();
        this.tempRoot = root.toUri();
        this.targetPlatformInstallLocation = n4npm.toFile();
        this.targetPlatformFileLocation = packageJson.toURI();
    }

    public URI getTempRoot() {
        return this.tempRoot;
    }

    public void resetState() {
        this.targetPlatformInstallLocation = null;
        this.targetPlatformFileLocation = null;
        this.tempRoot = null;
    }
}

