/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.binaries.BinaryCommandFactory;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.LibraryChange;
import org.eclipse.n4js.external.NpmLogger;
import org.eclipse.n4js.external.TargetPlatformInstallLocationProvider;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.semver.SemverMatcher;
import org.eclipse.n4js.semver.SemverUtils;
import org.eclipse.n4js.utils.ProcessExecutionCommandStatus;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.process.ProcessResult;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class NpmCLI {
    @Inject
    private BinaryCommandFactory commandFactory;
    @Inject
    private ProcessExecutionCommandStatus executor;
    @Inject
    private TargetPlatformInstallLocationProvider locationProvider;
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    private StatusHelper statusHelper;
    @Inject
    private NpmLogger logger;
    @Inject
    private ProjectDescriptionLoader projectDescriptionLoader;
    @Inject
    private NpmBinary npmBinary;
    @Inject
    private SemverHelper semverHelper;

    public boolean invalidPackageName(String packageName) {
        return packageName == null || packageName.trim().isEmpty();
    }

    public boolean invalidPackageVersion(String packageVersion) {
        return packageVersion == null || !packageVersion.isEmpty() && !packageVersion.startsWith("@");
    }

    public VersionNumber getNpmVersion() {
        ProcessResult result = this.commandFactory.checkBinaryVersionCommand(this.npmBinary).execute();
        if (result.isOK()) {
            String output = result.getStdOut();
            return this.semverHelper.parseVersionNumber(output.trim());
        }
        return null;
    }

    public Collection<LibraryChange> batchUninstall(IProgressMonitor monitor, MultiStatus status, Collection<LibraryChange> requestedChanges) {
        return this.batchUninstallInternal(monitor, status, requestedChanges);
    }

    public Collection<LibraryChange> batchInstall(IProgressMonitor monitor, MultiStatus status, Collection<LibraryChange> requestedChanges) {
        return this.batchInstallInternal(monitor, status, requestedChanges);
    }

    private Collection<LibraryChange> batchInstallInternal(IProgressMonitor monitor, MultiStatus status, Collection<LibraryChange> requestedChanges) {
        MultiStatus batchStatus = this.statusHelper.createMultiStatus("Installing npm packages.");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        subMonitor.setTaskName("Installing npm packages.");
        LinkedHashSet<LibraryChange> actualChanges = new LinkedHashSet<LibraryChange>();
        File installPath = new File(this.locationProvider.getTargetPlatformInstallURI());
        ArrayList packageNamesAndVersions = Lists.newArrayList();
        for (LibraryChange reqChg : requestedChanges) {
            if (reqChg.type != LibraryChange.LibraryChangeType.Install) continue;
            packageNamesAndVersions.add(Tuples.pair((Object)reqChg.name, (Object)("@" + reqChg.version)));
        }
        IStatus installStatus = this.install(packageNamesAndVersions, installPath);
        subMonitor.worked(1);
        if (installStatus == null || !installStatus.isOK()) {
            batchStatus.merge(installStatus);
        } else {
            String nodeModulesFolder = "node_modules";
            Path basePath = installPath.toPath().resolve(nodeModulesFolder);
            for (LibraryChange reqChg : requestedChanges) {
                if (reqChg.type != LibraryChange.LibraryChangeType.Install) continue;
                Path completePath = basePath.resolve(reqChg.name);
                String actualVersion = this.getActualVersion(completePath);
                if (actualVersion.isEmpty()) {
                    String msg = "Error reading package json when " + reqChg.toString();
                    IStatus packJsonError = this.statusHelper.createError(msg);
                    this.logger.logError(msg, new IllegalStateException(msg));
                    batchStatus.merge(packJsonError);
                    continue;
                }
                URI actualLocation = URI.createFileURI((String)completePath.toString());
                LibraryChange actualChange = new LibraryChange(LibraryChange.LibraryChangeType.Added, actualLocation, reqChg.name, actualVersion);
                actualChanges.add(actualChange);
            }
        }
        if (!batchStatus.isOK()) {
            this.logger.logInfo("Some packages could not be installed due to errors, see log for details.");
            status.merge((IStatus)batchStatus);
        }
        return actualChanges;
    }

    private Collection<LibraryChange> batchUninstallInternal(IProgressMonitor monitor, MultiStatus status, Collection<LibraryChange> requestedChanges) {
        int pckCount = requestedChanges.size();
        MultiStatus batchStatus = this.statusHelper.createMultiStatus("Uninstalling npm packages.");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(pckCount + 1));
        LinkedHashSet<LibraryChange> actualChanges = new LinkedHashSet<LibraryChange>();
        File installPath = new File(this.locationProvider.getTargetPlatformInstallURI());
        java.net.URI nodeModulesURI = this.locationProvider.getNodeModulesURI();
        ArrayList packageNames = Lists.newArrayList();
        for (LibraryChange reqChg : requestedChanges) {
            java.net.URI rootLocation;
            if (reqChg.type != LibraryChange.LibraryChangeType.Uninstall || !nodeModulesURI.equals(rootLocation = this.externalLibraryWorkspace.getRootLocationForResource(reqChg.location))) continue;
            packageNames.add(reqChg.name);
        }
        IStatus installStatus = this.uninstall(packageNames, installPath);
        subMonitor.worked(1);
        if (installStatus == null || !installStatus.isOK()) {
            batchStatus.merge(installStatus);
        } else {
            String nodeModulesFolder = "node_modules";
            Path basePath = installPath.toPath().resolve(nodeModulesFolder);
            for (LibraryChange reqChg : requestedChanges) {
                Path completePath;
                String actualVersion;
                if (reqChg.type != LibraryChange.LibraryChangeType.Uninstall || !(actualVersion = this.getActualVersion(completePath = basePath.resolve(reqChg.name))).isEmpty()) continue;
                LibraryChange actualChange = new LibraryChange(LibraryChange.LibraryChangeType.Removed, reqChg.location, reqChg.name, reqChg.version);
                actualChanges.add(actualChange);
            }
        }
        if (!batchStatus.isOK()) {
            this.logger.logInfo("Some packages could not be uninstalled due to errors, see log for details.");
            status.merge((IStatus)batchStatus);
        }
        return actualChanges;
    }

    private String getActualVersion(Path completePath) {
        URI location = URI.createFileURI((String)completePath.toString());
        String versionStr = (String)this.projectDescriptionLoader.loadVersionAndN4JSNatureFromProjectDescriptionAtLocation(location).getFirst();
        if (versionStr == null) {
            return "";
        }
        return versionStr;
    }

    private IStatus install(List<Pair<String, String>> packageNamesAndVersions, File installPath) {
        ArrayList<String> packageNamesAndVersionsMerged = new ArrayList<String>(packageNamesAndVersions.size());
        for (Pair<String, String> pair : packageNamesAndVersions) {
            String packageName = (String)pair.getFirst();
            String packageVersion = (String)pair.getSecond();
            if (this.invalidPackageName(packageName)) {
                return this.statusHelper.createError("Malformed npm package name: '" + packageName + "'.");
            }
            if (this.invalidPackageVersion(packageVersion)) {
                return this.statusHelper.createError("Malformed npm package version: '" + packageVersion + "'.");
            }
            String nameAndVersion = packageVersion.isEmpty() ? packageName : String.valueOf(packageName) + packageVersion;
            packageNamesAndVersionsMerged.add(nameAndVersion);
        }
        IStatus status = this.executor.execute(() -> this.commandFactory.createInstallPackageCommand(installPath, packageNamesAndVersionsMerged, true), "Error while installing npm package.");
        VersionNumber currNpmVersion = this.getNpmVersion();
        VersionNumber fixedNpmVersion = SemverUtils.createVersionNumber((Integer)5, (Integer)7, (Integer)1);
        if (currNpmVersion != null && SemverMatcher.compareLoose((VersionNumber)currNpmVersion, (VersionNumber)fixedNpmVersion) < 0) {
            IStatus workaroundStatus = this.executor.execute(() -> this.commandFactory.createInstallPackageCommand(installPath, Collections.emptyList(), false), "Error while running \"npm install\" after installing npm packages.");
            MultiStatus combinedStatus = this.statusHelper.createMultiStatus("Installing npm packages with additional \"npm install\" afterwards.");
            combinedStatus.merge(status);
            combinedStatus.merge(workaroundStatus);
            status = combinedStatus;
        }
        return status;
    }

    private IStatus uninstall(List<String> packageNames, File uninstallPath) {
        for (String packageName : packageNames) {
            if (!this.invalidPackageName(packageName)) continue;
            return this.statusHelper.createError("Malformed npm package name: '" + packageName + "'.");
        }
        return this.executor.execute(() -> this.commandFactory.createUninstallPackageCommand(uninstallPath, packageNames, true), "Error while uninstalling npm package.");
    }

    public IStatus cleanCacheInternal(IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor, (Object)"monitor");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            subMonitor.setTaskName("Cleaning npm cache");
            File targetInstallLocation = new File(this.locationProvider.getTargetPlatformInstallURI());
            IStatus iStatus = this.clean(targetInstallLocation);
            return iStatus;
        }
        finally {
            subMonitor.done();
        }
    }

    private IStatus clean(File cleanPath) {
        return this.executor.execute(() -> this.commandFactory.createCacheCleanCommand(cleanPath), "Error while cleaning npm cache.");
    }
}

