/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.n4js.utils.io.FileMatcher;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class WildcardPathFilter {
    private static final String MATCHING_FILE_EXT = ".*js*";
    private static final List<String> supportedFileExtension = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{".js", ".n4js", ".n4jsd", ".n4js.xt", ".n4jsd.xt", ".js.xt"}));

    public static List<String> collectPathsByWildcardPath(String absoluteProjectPath, String projectRelativeWildcardPath) {
        List _xblockexpression = null;
        Pair<List<String>, List<String>> absoluteFolderAndFilePaths = WildcardPathFilter.collectAllFoldersAndFilesByWildcardPath(absoluteProjectPath, projectRelativeWildcardPath, true);
        List _xifexpression = null;
        boolean _isEmpty = ((List)absoluteFolderAndFilePaths.getValue()).isEmpty();
        boolean _not = !_isEmpty;
        _xifexpression = _not ? (List)absoluteFolderAndFilePaths.getValue() : (List)absoluteFolderAndFilePaths.getKey();
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static List<String> collectAllFilesByWildcardPath(String absoluteProjectPath, String projectRelativeWildcardPath) {
        List _xblockexpression = null;
        Pair<List<String>, List<String>> absoluteFolderAndFilePaths = WildcardPathFilter.collectAllFoldersAndFilesByWildcardPath(absoluteProjectPath, projectRelativeWildcardPath, true);
        Functions.Function1 _function = path -> {
            Functions.Function1 _function_1 = it -> String.valueOf(path) + File.separator + it;
            return IterableExtensions.toList((Iterable)IterableExtensions.map(WildcardPathFilter.matchFiles(path, "*.*"), (Functions.Function1)_function_1));
        };
        List files = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)((List)absoluteFolderAndFilePaths.getKey()), (Functions.Function1)_function)));
        List _value = (List)absoluteFolderAndFilePaths.getValue();
        Iterables.addAll((Collection)files, (Iterable)_value);
        _xblockexpression = files;
        return _xblockexpression;
    }

    private static List<String> filterByFileExtensions(List<String> paths) {
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = fe -> it.endsWith((String)fe);
            return IterableExtensions.exists(supportedFileExtension, (Functions.Function1)_function_1);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(paths, (Functions.Function1)_function));
    }

    public static List<String> collectAllFoldersByWildcardPath(String absoluteProjectPath, String projectRelativeWildcardPath) {
        List _xblockexpression = null;
        Pair<List<String>, List<String>> absoluteFolderAndFilePaths = WildcardPathFilter.collectAllFoldersAndFilesByWildcardPath(absoluteProjectPath, projectRelativeWildcardPath, false);
        _xblockexpression = (List)absoluteFolderAndFilePaths.getKey();
        return _xblockexpression;
    }

    private static Pair<List<String>, List<String>> collectAllFoldersAndFilesByWildcardPath(String absoluteProjectPath, String matchString, boolean addFileExtensionPattern) {
        boolean _not;
        boolean _exists = new File(absoluteProjectPath).exists();
        boolean bl = _not = !_exists;
        if (_not) {
            return Pair.of(Collections.unmodifiableList(CollectionLiterals.newArrayList()), Collections.unmodifiableList(CollectionLiterals.newArrayList()));
        }
        String newMatchString = WildcardPathFilter.adaptWildcard(matchString.replace("\\", File.separator).replace("/", File.separator), addFileExtensionPattern);
        String separator = String.valueOf(File.separator) + "..";
        Iterator splittedMatchStringParts = ((List)Conversions.doWrapArray((Object)newMatchString.split(Pattern.quote(separator)))).iterator();
        ArrayList absoluteFolderPaths = CollectionLiterals.newArrayList((Object[])new String[]{absoluteProjectPath});
        ArrayList absoluteFilePaths = CollectionLiterals.newArrayList();
        while (splittedMatchStringParts.hasNext()) {
            String splittedMatchStringPart = (String)splittedMatchStringParts.next();
            Functions.Function1 _function = it -> {
                List _list = IterableExtensions.toList(WildcardPathFilter.matchFolders(it, splittedMatchStringPart));
                return Pair.of((Object)it, (Object)_list);
            };
            List folders = ListExtensions.map((List)absoluteFolderPaths, (Functions.Function1)_function);
            ArrayList newAbsoluteFolderPaths = CollectionLiterals.newArrayList();
            for (Pair folderEntry : folders) {
                Functions.Function1 _function_1 = it -> {
                    String _xtrycatchfinallyexpression = null;
                    try {
                        String _key = (String)folderEntry.getKey();
                        String _plus = String.valueOf(_key) + File.separator;
                        String _plus_1 = String.valueOf(_plus) + it;
                        String _xifexpression = null;
                        _xifexpression = !splittedMatchStringParts.hasNext() && newMatchString.endsWith(separator) ? separator : "";
                        String _plus_2 = String.valueOf(_plus_1) + _xifexpression;
                        _xtrycatchfinallyexpression = new File(_plus_2).getCanonicalPath();
                    }
                    catch (Throwable _t) {
                        if (_t instanceof IOException) {
                            IOException exc = (IOException)_t;
                            throw new RuntimeException("Canonical path cannot be calculated", exc);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return _xtrycatchfinallyexpression;
                };
                List _map = ListExtensions.map((List)((List)folderEntry.getValue()), (Functions.Function1)_function_1);
                Iterables.addAll((Collection)newAbsoluteFolderPaths, (Iterable)_map);
            }
            if (!splittedMatchStringParts.hasNext() && !newMatchString.endsWith(separator)) {
                Functions.Function1 _function_2 = it -> {
                    List _list = IterableExtensions.toList(WildcardPathFilter.matchFiles(it, splittedMatchStringPart));
                    return Pair.of((Object)it, (Object)_list);
                };
                List files = ListExtensions.map((List)absoluteFolderPaths, (Functions.Function1)_function_2);
                for (Pair fileEntry : files) {
                    Functions.Function1 _function_3 = it -> {
                        String _xtrycatchfinallyexpression = null;
                        try {
                            String _key = (String)fileEntry.getKey();
                            String _plus = String.valueOf(_key) + File.separator;
                            _xtrycatchfinallyexpression = String.valueOf(_plus) + it;
                        }
                        catch (Throwable _t) {
                            if (_t instanceof IOException) {
                                IOException exc = (IOException)_t;
                                throw new RuntimeException("Canonical path cannot be calculated", exc);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        return _xtrycatchfinallyexpression;
                    };
                    List filesPaths = ListExtensions.map((List)((List)fileEntry.getValue()), (Functions.Function1)_function_3);
                    Iterables.addAll((Collection)absoluteFilePaths, (Iterable)filesPaths);
                }
            }
            absoluteFolderPaths.clear();
            Iterables.addAll((Collection)absoluteFolderPaths, (Iterable)newAbsoluteFolderPaths);
        }
        List<String> _filterByFileExtensions = WildcardPathFilter.filterByFileExtensions(absoluteFilePaths);
        Pair result = Pair.of((Object)absoluteFolderPaths, _filterByFileExtensions);
        return result;
    }

    private static String adaptWildcard(String projectRelativeWildcardPath, boolean addFileExtensionPattern) {
        String _xifexpression = null;
        _xifexpression = !projectRelativeWildcardPath.endsWith("**") && addFileExtensionPattern ? String.valueOf(projectRelativeWildcardPath) + MATCHING_FILE_EXT : projectRelativeWildcardPath;
        return _xifexpression;
    }

    private static Iterable<String> matchFolders(String absoluteProjectPath, String matchString) {
        Functions.Function1 _function = it -> it.toString();
        return IterableExtensions.map((Iterable)FileMatcher.scanDirectories((Path)Paths.get(absoluteProjectPath, new String[0]), (String)matchString), (Functions.Function1)_function);
    }

    private static Iterable<String> matchFiles(String absoluteProjectPath, String matchString) {
        Functions.Function1 _function = it -> it.toString();
        return IterableExtensions.map((Iterable)FileMatcher.scanFiles((Path)Paths.get(absoluteProjectPath, new String[0]), (String)matchString), (Functions.Function1)_function);
    }
}

