/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.AnnotationArgument;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.TypeRefAnnotationArgument;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.types.BuiltInType;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TAnnotation;
import org.eclipse.n4js.ts.types.TAnnotationArgument;
import org.eclipse.n4js.ts.types.TAnnotationTypeRefArgument;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.VirtualBaseType;
import org.eclipse.n4js.ts.types.util.AllSuperTypesCollector;
import org.eclipse.n4js.ts.types.util.SuperInterfacesIterable;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class N4JSDependencyInjectionValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    @Extension
    private ContainerTypesHelper _containerTypesHelper;
    @Inject
    @Extension
    private IScopeProvider _iScopeProvider;

    public void register(EValidatorRegistrar registrar) {
    }

    public static TClass tClassOf(TypeRef ref) {
        Type _declaredType;
        if (ref != null && (_declaredType = ref.getDeclaredType()) instanceof TClass) {
            Type _declaredType_1 = ref.getDeclaredType();
            return (TClass)_declaredType_1;
        }
        return null;
    }

    @Check
    public void checkNewExpression(NewExpression newExpression) {
        boolean _isMarkedInjected;
        boolean _tripleEquals;
        Expression _callee = null;
        if (newExpression != null) {
            _callee = newExpression.getCallee();
        }
        boolean bl = _tripleEquals = _callee == null;
        if (_tripleEquals) {
            return;
        }
        TypeRef typeRef = this.ts.tau((TypableElement)newExpression.getCallee());
        if (typeRef == null) {
            return;
        }
        if (typeRef instanceof UnknownTypeRef) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)newExpression);
        Type _xifexpression = null;
        _xifexpression = typeRef instanceof TypeTypeRef ? this.tsh.getStaticType(G, (TypeTypeRef)typeRef) : null;
        Type staticType = _xifexpression;
        if (staticType == null || staticType.eIsProxy()) {
            return;
        }
        if (!(staticType instanceof TClass)) {
            return;
        }
        TClass tClazz = (TClass)staticType;
        boolean _requiresInjection = N4JSDependencyInjectionValidator.requiresInjection(tClazz);
        if (_requiresInjection) {
            this.addIssue(IssueCodes.getMessageForDI_MUST_BE_INJECTED(tClazz.getTypeAsString()), (EObject)newExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getNewExpression_Callee(), "DI_MUST_BE_INJECTED", new String[0]);
        }
        if (_isMarkedInjected = N4JSDependencyInjectionValidator.isMarkedInjected(tClazz)) {
            this.addIssue(IssueCodes.getMessageForDI_API_INJECTED(), (EObject)newExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getNewExpression_Callee(), "DI_API_INJECTED", new String[0]);
        }
    }

    @Check
    public void checkDependencyInjectionAnnotation(Annotation ann) {
        String _name = ann.getName();
        boolean _matched = false;
        if (Objects.equal((Object)_name, (Object)AnnotationDefinition.GENERATE_INJECTOR.name)) {
            _matched = true;
            this.internalCheckAnnotationInjector(ann);
        }
        if (!_matched && Objects.equal((Object)_name, (Object)AnnotationDefinition.BINDER.name)) {
            _matched = true;
            this.internalCheckAnnotationBinder(ann);
        }
        if (!_matched && Objects.equal((Object)_name, (Object)AnnotationDefinition.BIND.name)) {
            _matched = true;
            this.internalCheckAnnotationBind(ann);
        }
        if (!_matched && Objects.equal((Object)_name, (Object)AnnotationDefinition.WITH_PARENT_INJECTOR.name)) {
            _matched = true;
            this.internalCheckAnnotationWithParentInjector(ann);
        }
        if (!_matched && Objects.equal((Object)_name, (Object)AnnotationDefinition.USE_BINDER.name)) {
            _matched = true;
            this.internalCheckAnnotationUseBinder(ann);
        }
        if (!_matched && Objects.equal((Object)_name, (Object)AnnotationDefinition.PROVIDES.name)) {
            _matched = true;
            this.internalCheckAnnotationProvides(ann);
        }
        if (!_matched && Objects.equal((Object)_name, (Object)AnnotationDefinition.INJECT.name)) {
            _matched = true;
            this.internalCheckAnnotationInject(ann);
        }
        if (!_matched && Objects.equal((Object)_name, (Object)AnnotationDefinition.INJECTED.name)) {
            _matched = true;
            this.internalCheckAnnotationInjected(ann);
        }
    }

    @Check
    public Object checkCtor(N4MethodDeclaration it) {
        Object _xifexpression = null;
        if (it != null && it.isConstructor() && this.internalCheckCtorReferencesInjectedFields(it) && this.internalCheckCtorInjectedWhenParentInjected(it)) {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    private boolean internalCheckCtorInjectedWhenParentInjected(N4MethodDeclaration ctor) {
        boolean _not;
        boolean _hasAnnotation = AnnotationDefinition.INJECT.hasAnnotation((AnnotableElement)ctor);
        boolean bl = _not = !_hasAnnotation;
        if (_not) {
            Type currentType;
            N4ClassifierDefinition _owner = null;
            if (ctor != null) {
                _owner = ctor.getOwner();
            }
            Type _definedType = null;
            if (_owner != null) {
                _definedType = _owner.getDefinedType();
            }
            if ((currentType = _definedType) instanceof ContainerType) {
                boolean _not_1;
                Functions.Function1 _function = it -> it.isConstructor() && it != ctor.getDefinedType() && AnnotationDefinition.INJECT.hasAnnotation((TAnnotableElement)it);
                Iterable injectedParentInjectors = IterableExtensions.filter((Iterable)Iterables.filter(this._containerTypesHelper.fromContext((EObject)ctor).allMembers((ContainerType)currentType), TMethod.class), (Functions.Function1)_function);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)injectedParentInjectors);
                boolean bl2 = _not_1 = !_isEmpty;
                if (_not_1) {
                    String currentName = ((ContainerType)currentType).getName();
                    TMethod _get = ((TMethod[])Conversions.unwrapArray((Object)injectedParentInjectors, TMethod.class))[0];
                    ContainerType _containingType = null;
                    if (_get != null) {
                        _containingType = _get.getContainingType();
                    }
                    String _name = null;
                    if (_containingType != null) {
                        _name = _containingType.getName();
                    }
                    String superName = _name;
                    this.addIssue(IssueCodes.getMessageForDI_CTOR_BREAKS_INJECTION_CHAIN(superName, currentName), (EObject)ctor, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "DI_CTOR_BREAKS_INJECTION_CHAIN", new String[0]);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean internalCheckCtorReferencesInjectedFields(N4MethodDeclaration ctor) {
        boolean _tripleEquals;
        Block _body = ctor.getBody();
        boolean bl = _tripleEquals = _body == null;
        if (_tripleEquals) {
            return true;
        }
        AtomicBoolean valid = new AtomicBoolean(true);
        Procedures.Procedure1 _function = stmt -> {
            Procedures.Procedure1 _function_1 = propAcc -> {
                boolean _isPropAccessOfInterest = this.isPropAccessOfInterest((EObject)propAcc);
                if (_isPropAccessOfInterest) {
                    boolean _not;
                    boolean _holdsCtorReferencesInjectedField = this.holdsCtorReferencesInjectedField(ctor, (ParameterizedPropertyAccessExpression)propAcc);
                    boolean bl = _not = !_holdsCtorReferencesInjectedField;
                    if (_not) {
                        valid.set(false);
                    }
                }
            };
            IteratorExtensions.forEach((Iterator)EcoreUtil.getAllContents((EObject)stmt, (boolean)false), (Procedures.Procedure1)_function_1);
        };
        IteratorExtensions.forEach((Iterator)ctor.getBody().getAllStatements(), (Procedures.Procedure1)_function);
        return valid.get();
    }

    private boolean holdsCtorReferencesInjectedField(N4MethodDeclaration ctor, ParameterizedPropertyAccessExpression propAccess) {
        boolean isValid = true;
        IdentifiableElement _property = propAccess.getProperty();
        TField accessedField = (TField)_property;
        boolean isInjectedCtor = AnnotationDefinition.INJECT.hasAnnotation((AnnotableElement)ctor);
        if (!isInjectedCtor) {
            this.addIssue(IssueCodes.getMessageForDI_FIELD_IS_NOT_INJECTED_YET(accessedField.getName()), (EObject)propAccess, "DI_FIELD_IS_NOT_INJECTED_YET");
            isValid = false;
        } else {
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)ctor);
            Functions.Function1 _function = it -> it.getDeclaredTypeRef();
            Functions.Function1 _function_1 = it -> {
                boolean _tripleEquals;
                boolean _or = false;
                Type _declaredType = it.getDeclaredType();
                TypeRef _typeRef = null;
                if (accessedField != null) {
                    _typeRef = accessedField.getTypeRef();
                }
                Type _declaredType_1 = null;
                if (_typeRef != null) {
                    _declaredType_1 = _typeRef.getDeclaredType();
                }
                boolean bl = _tripleEquals = _declaredType == _declaredType_1;
                if (_tripleEquals) {
                    _or = true;
                } else {
                    boolean _subtypeSucceeded;
                    TypeRef _typeRef_1 = null;
                    if (accessedField != null) {
                        _typeRef_1 = accessedField.getTypeRef();
                    }
                    _or = _subtypeSucceeded = this.ts.subtypeSucceeded(G, (TypeArgument)it, (TypeArgument)_typeRef_1);
                }
                return _or;
            };
            boolean someParamSubtypesFieldType = IterableExtensions.exists((Iterable)ListExtensions.map((List)ctor.getFpars(), (Functions.Function1)_function), (Functions.Function1)_function_1);
            if (!someParamSubtypesFieldType) {
                this.addIssue(IssueCodes.getMessageForDI_FIELD_IS_NOT_INJECTED_YET(accessedField.getName()), (EObject)propAccess, "DI_FIELD_IS_NOT_INJECTED_YET");
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean isPropAccessOfInterest(EObject eo) {
        if (!(eo instanceof ParameterizedPropertyAccessExpression)) {
            return false;
        }
        ParameterizedPropertyAccessExpression propAcc = (ParameterizedPropertyAccessExpression)eo;
        IdentifiableElement _property = propAcc.getProperty();
        if (_property instanceof TField) {
            Expression _target;
            boolean _not;
            boolean _isLhsInFieldAssignment = this.isLhsInFieldAssignment(propAcc);
            boolean bl = _not = !_isLhsInFieldAssignment;
            if (_not && (_target = propAcc.getTarget()) instanceof ThisLiteral) {
                IdentifiableElement _property_1 = propAcc.getProperty();
                TField accessedField = (TField)_property_1;
                return AnnotationDefinition.INJECT.hasAnnotation((TAnnotableElement)accessedField) && this.isVisibleAt(accessedField, propAcc);
            }
        }
        return false;
    }

    private boolean isLhsInFieldAssignment(ParameterizedPropertyAccessExpression it) {
        EObject _eContainer_1;
        AssignmentExpression assignExp;
        boolean _xblockexpression = false;
        EObject _eContainer = it.eContainer();
        if (_eContainer instanceof AssignmentExpression && (assignExp = (AssignmentExpression)(_eContainer_1 = it.eContainer())).getLhs() == it && it.getProperty() instanceof TField) {
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    private boolean isVisibleAt(TField field, ParameterizedPropertyAccessExpression expr) {
        IScope scope = this._iScopeProvider.getScope((EObject)expr, N4JSPackage.eINSTANCE.getParameterizedPropertyAccessExpression_Property());
        boolean _isErrorDescription = IEObjectDescriptionWithError.isErrorDescription((IEObjectDescription)scope.getSingleElement((EObject)field));
        return !_isErrorDescription;
    }

    private void internalCheckAnnotationInjector(Annotation ann) {
        boolean _tripleNotEquals;
        N4ClassDeclaration injtorClassDecl = N4JSDependencyInjectionValidator.getAnnotatedClass(ann);
        if (injtorClassDecl == null) {
            return;
        }
        ParameterizedTypeRef _superClassRef = injtorClassDecl.getSuperClassRef();
        boolean bl = _tripleNotEquals = _superClassRef != null;
        if (_tripleNotEquals) {
            this.addIssue(IssueCodes.getMessageForDI_ANN_INJECTOR_EXTENDS(), (EObject)ann, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_INJECTOR_EXTENDS", new String[0]);
        }
        Iterable<Annotation> usedBindersAnns = AnnotationDefinition.USE_BINDER.getAllAnnotations((AnnotableElement)injtorClassDecl);
        ArrayList<Binding_UseBinder> collectedBindings = new ArrayList<Binding_UseBinder>();
        Consumer<Annotation> _function = usedBinderAnn -> {
            TypeRef binderTypeRef = N4JSDependencyInjectionValidator.getArgAsTypeRef(usedBinderAnn, 0);
            TClass binderTClass = N4JSDependencyInjectionValidator.tClassOf(binderTypeRef);
            if (binderTClass != null) {
                Iterable<TAnnotation> tbindings = AnnotationDefinition.BIND.getAllAnnotations((TAnnotableElement)binderTClass);
                Consumer<TAnnotation> _function_1 = tbinding -> {
                    Binding_UseBinder _binding_UseBinder = new Binding_UseBinder((TAnnotation)tbinding, (Annotation)usedBinderAnn);
                    collectedBindings.add(_binding_UseBinder);
                };
                tbindings.forEach(_function_1);
            }
        };
        usedBindersAnns.forEach(_function);
        this.internalCheckNoDupBindingsAcrossBinders(collectedBindings, RuleEnvironmentExtensions.newRuleEnvironment((EObject)injtorClassDecl));
        N4MethodDeclaration injtorCtor = injtorClassDecl.getOwnedCtor();
        if (injtorCtor != null && !injtorCtor.getFpars().isEmpty()) {
            boolean _not;
            boolean _hasAnnotation = AnnotationDefinition.INJECT.hasAnnotation((AnnotableElement)injtorCtor);
            boolean bl2 = _not = !_hasAnnotation;
            if (_not) {
                this.addIssue(IssueCodes.getMessageForDI_ANN_INJECTOR_CTOR_MUST_BE_INJECT(), (EObject)injtorCtor, "DI_ANN_INJECTOR_CTOR_MUST_BE_INJECT");
            }
        }
    }

    public static Iterable<TClass> usedBindersOf(TClass dicTClass) {
        Iterable _xblockexpression = null;
        Iterable<TAnnotation> usedBindersAnns = AnnotationDefinition.USE_BINDER.getAllAnnotations((TAnnotableElement)dicTClass);
        Functions.Function1 _function = usedBinderAnn -> {
            TClass _xblockexpression_1 = null;
            TypeRef binderTypeRef = N4JSDependencyInjectionValidator.getArgAsTypeRef(usedBinderAnn, 0);
            _xblockexpression_1 = N4JSDependencyInjectionValidator.tClassOf(binderTypeRef);
            return _xblockexpression_1;
        };
        _xblockexpression = IterableExtensions.map(usedBindersAnns, (Functions.Function1)_function);
        return _xblockexpression;
    }

    private void internalCheckNoDupBindingsAcrossBinders(List<Binding_UseBinder> collectedBindings, RuleEnvironment G) {
        HashMap seen = new HashMap();
        Consumer<Binding_UseBinder> _function = bindingTAnnAndItsUseAnn -> {
            boolean _not;
            TAnnotation bindingTAnn = ((Binding_UseBinder)bindingTAnnAndItsUseAnn).bindingTAnn;
            Annotation useBinderAnn = ((Binding_UseBinder)bindingTAnnAndItsUseAnn).useBinderAnn;
            TypeRef extra = N4JSDependencyInjectionValidator.getArgAsTypeRef(bindingTAnn, 0);
            boolean _hasStructuralFlavor = N4JSDependencyInjectionValidator.hasStructuralFlavor(extra);
            boolean bl = _not = !_hasStructuralFlavor;
            if (_not) {
                Annotation dupBinding = this.getDuplicate(extra, seen, G);
                if (dupBinding != null) {
                    this.addIssue(IssueCodes.getMessageForDI_ANN_DUPLICATE_BINDING(), (EObject)useBinderAnn, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_DUPLICATE_BINDING", new String[0]);
                    this.addIssue(IssueCodes.getMessageForDI_ANN_DUPLICATE_BINDING(), (EObject)dupBinding, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_DUPLICATE_BINDING", new String[0]);
                } else {
                    seen.put(extra, useBinderAnn);
                }
            }
        };
        collectedBindings.forEach(_function);
    }

    private void internalCheckAnnotationBinder(Annotation binderAnn) {
        TClass binderTClazz;
        boolean _hasAnnotation;
        boolean _tripleNotEquals;
        N4ClassDeclaration binderClassDecl = N4JSDependencyInjectionValidator.getAnnotatedClass(binderAnn);
        if (binderClassDecl == null || binderClassDecl.isAbstract()) {
            this.addIssue(IssueCodes.getMessageForDI_ANN_BINDER_NOT_APPLICABLE(), (EObject)binderAnn, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_BINDER_NOT_APPLICABLE", new String[0]);
            return;
        }
        ParameterizedTypeRef _superClassRef = binderClassDecl.getSuperClassRef();
        boolean bl = _tripleNotEquals = _superClassRef != null;
        if (_tripleNotEquals) {
            this.addIssue(IssueCodes.getMessageForDI_ANN_BINDER_EXTENDS(), (EObject)binderAnn, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_BINDER_EXTENDS", new String[0]);
        }
        if (_hasAnnotation = AnnotationDefinition.GENERATE_INJECTOR.hasAnnotation((TAnnotableElement)(binderTClazz = binderClassDecl.getDefinedTypeAsClass()))) {
            this.addIssue(IssueCodes.getMessageForDI_ANN_BINDER_AND_INJECTOR_DONT_GO_TOGETHER(), (EObject)binderAnn, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_BINDER_AND_INJECTOR_DONT_GO_TOGETHER", new String[0]);
        }
        this.internalCheckNoDupBindings(AnnotationDefinition.BIND.getAllAnnotations((AnnotableElement)binderClassDecl), RuleEnvironmentExtensions.newRuleEnvironment((EObject)binderClassDecl));
    }

    private void internalCheckNoDupBindings(Iterable<Annotation> bindings, RuleEnvironment G) {
        HashMap seen = new HashMap();
        Consumer<Annotation> _function = binding -> {
            boolean _not;
            TypeRef extra = N4JSDependencyInjectionValidator.getArgAsTypeRef(binding, 0);
            boolean _hasStructuralFlavor = N4JSDependencyInjectionValidator.hasStructuralFlavor(extra);
            boolean bl = _not = !_hasStructuralFlavor;
            if (_not) {
                Annotation dupBinding = this.getDuplicate(extra, seen, G);
                if (dupBinding != null) {
                    this.addIssue(IssueCodes.getMessageForDI_ANN_DUPLICATE_BINDING(), (EObject)binding, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_DUPLICATE_BINDING", new String[0]);
                    this.addIssue(IssueCodes.getMessageForDI_ANN_DUPLICATE_BINDING(), (EObject)dupBinding, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_DUPLICATE_BINDING", new String[0]);
                } else {
                    seen.put(extra, binding);
                }
            }
        };
        bindings.forEach(_function);
    }

    private Annotation getDuplicate(TypeRef extra, HashMap<TypeRef, Annotation> seen, RuleEnvironment G) {
        for (Map.Entry<TypeRef, Annotation> oldEntry : seen.entrySet()) {
            TypeRef old = oldEntry.getKey();
            boolean _equaltypeSucceeded = this.ts.equaltypeSucceeded(G, (TypeArgument)old, (TypeArgument)extra);
            if (!_equaltypeSucceeded) continue;
            return oldEntry.getValue();
        }
        return null;
    }

    private static boolean hasStructuralFlavor(TypeRef typeRef) {
        TypingStrategy ts = typeRef.getTypingStrategy();
        return Objects.equal((Object)TypingStrategy.STRUCTURAL, (Object)ts) || Objects.equal((Object)TypingStrategy.STRUCTURAL_FIELDS, (Object)ts);
    }

    private void internalCheckAnnotationBind(Annotation ann) {
        boolean _holdsHasValidTargetType;
        boolean _and = false;
        _and = !this.holdsAnnotatedTClassIsAnnotatedWith(ann, AnnotationDefinition.BINDER) || !this.holdsIsInjectableType(ann, N4JSDependencyInjectionValidator.getArgAsTypeRef(ann, 0)) || !this.holdsSecondArgIsSubtypeOfFirstArg(ann) ? false : (_holdsHasValidTargetType = this.holdsHasValidTargetType(ann));
    }

    private void internalCheckAnnotationWithParentInjector(Annotation ann) {
        boolean _holdsNoCycleBetweenUsedInjectors;
        boolean _and = false;
        _and = !this.holdsAnnotatedTClassIsAnnotatedWith(ann, AnnotationDefinition.GENERATE_INJECTOR) || !this.holdsArgumentIsTypeRefToTClassAnnotatedWith(ann, AnnotationDefinition.GENERATE_INJECTOR) ? false : (_holdsNoCycleBetweenUsedInjectors = this.holdsNoCycleBetweenUsedInjectors(ann));
    }

    private boolean holdsNoCycleBetweenUsedInjectors(Annotation it) {
        Type type = this.typeOfUseInjector(it);
        if (type != null) {
            ArrayList visitedTypes = CollectionLiterals.newArrayList((Object[])new String[]{type.getName()});
            Functions.Function1 _function = it_1 -> {
                String _name = it_1.getName();
                return Objects.equal((Object)AnnotationDefinition.WITH_PARENT_INJECTOR.name, (Object)_name);
            };
            TAnnotation annotation = (TAnnotation)IterableExtensions.findFirst((Iterable)type.getAnnotations(), (Functions.Function1)_function);
            while (annotation != null) {
                type = this.typeOfUseInjector(annotation);
                if (type == null) {
                    annotation = null;
                    continue;
                }
                int indexOf = visitedTypes.indexOf(type.getName());
                if (indexOf > -1) {
                    StringConcatenation _builder = new StringConcatenation();
                    String _join = IterableExtensions.join((Iterable)visitedTypes, (CharSequence)" > ");
                    _builder.append(_join);
                    _builder.append(" > ");
                    String _name = type.getName();
                    _builder.append(_name);
                    this.addIssue(IssueCodes.getMessageForDI_ANN_USE_INJECTOR_CYCLE(_builder), (EObject)it, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_USE_INJECTOR_CYCLE", new String[0]);
                    return false;
                }
                visitedTypes.add(type.getName());
                Functions.Function1 _function_1 = it_1 -> {
                    String _name_1 = it_1.getName();
                    return Objects.equal((Object)AnnotationDefinition.WITH_PARENT_INJECTOR.name, (Object)_name_1);
                };
                annotation = (TAnnotation)IterableExtensions.findFirst((Iterable)type.getAnnotations(), (Functions.Function1)_function_1);
            }
        }
        return true;
    }

    private Type typeOfUseInjector(Annotation it) {
        AnnotationArgument _head;
        TypeRefAnnotationArgument arg;
        TypeRef _typeRef;
        if (Objects.equal((Object)AnnotationDefinition.WITH_PARENT_INJECTOR.name, (Object)it.getName()) && !IterableExtensions.isNullOrEmpty((Iterable)it.getArgs()) && IterableExtensions.head((Iterable)it.getArgs()) instanceof TypeRefAnnotationArgument && (_typeRef = (arg = (TypeRefAnnotationArgument)(_head = (AnnotationArgument)IterableExtensions.head((Iterable)it.getArgs()))).getTypeRef()) instanceof ParameterizedTypeRef) {
            TypeRef _typeRef_1 = arg.getTypeRef();
            return ((ParameterizedTypeRef)_typeRef_1).getDeclaredType();
        }
        return null;
    }

    private Type typeOfUseInjector(TAnnotation it) {
        TAnnotationArgument _head;
        TAnnotationTypeRefArgument arg;
        TypeRef _typeRef;
        if (Objects.equal((Object)AnnotationDefinition.WITH_PARENT_INJECTOR.name, (Object)it.getName()) && !IterableExtensions.isNullOrEmpty((Iterable)it.getArgs()) && IterableExtensions.head((Iterable)it.getArgs()) instanceof TAnnotationTypeRefArgument && (_typeRef = (arg = (TAnnotationTypeRefArgument)(_head = (TAnnotationArgument)IterableExtensions.head((Iterable)it.getArgs()))).getTypeRef()) instanceof ParameterizedTypeRef) {
            TypeRef _typeRef_1 = arg.getTypeRef();
            return ((ParameterizedTypeRef)_typeRef_1).getDeclaredType();
        }
        return null;
    }

    private void internalCheckAnnotationUseBinder(Annotation ann) {
        boolean _holdsArgumentIsTypeRefToTClassAnnotatedWith;
        boolean _and = false;
        boolean _holdsAnnotatedTClassIsAnnotatedWith = this.holdsAnnotatedTClassIsAnnotatedWith(ann, AnnotationDefinition.GENERATE_INJECTOR);
        _and = !_holdsAnnotatedTClassIsAnnotatedWith ? false : (_holdsArgumentIsTypeRefToTClassAnnotatedWith = this.holdsArgumentIsTypeRefToTClassAnnotatedWith(ann, AnnotationDefinition.BINDER));
    }

    private void internalCheckAnnotationProvides(Annotation ann) {
        boolean _holdsAnnotatedTMethodHasCorrectSignature;
        boolean _and = false;
        boolean _holdsAnnotatedTMethodIsContainedInTClassAnnotatedWith = this.holdsAnnotatedTMethodIsContainedInTClassAnnotatedWith(ann, AnnotationDefinition.BINDER);
        _and = !_holdsAnnotatedTMethodIsContainedInTClassAnnotatedWith ? false : (_holdsAnnotatedTMethodHasCorrectSignature = this.holdsAnnotatedTMethodHasCorrectSignature(ann));
    }

    private void internalCheckAnnotationInject(Annotation ann) {
        TMember _definedTypeElement_1;
        TField field;
        TypeRef ref;
        TClass clazz;
        TMember _definedTypeElement;
        EObject annElem = ann.getAnnotatedElement();
        EObject annElemCont = annElem.eContainer();
        if (annElemCont instanceof N4InterfaceDeclaration) {
            this.addIssue(IssueCodes.getMessageForDI_ANN_INTERFACE_INJECTION_NOT_SUPPORTED(), (EObject)ann, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_INTERFACE_INJECTION_NOT_SUPPORTED", new String[0]);
        }
        if (annElem instanceof N4FieldDeclaration && (_definedTypeElement = ((N4FieldDeclaration)annElem).getDefinedTypeElement()) instanceof TField && (clazz = N4JSDependencyInjectionValidator.tClassOf(ref = (field = (TField)(_definedTypeElement_1 = ((N4FieldDeclaration)annElem).getDefinedTypeElement())).getTypeRef())) != null) {
            boolean valid = true;
            while (clazz != null) {
                if (!valid) {
                    clazz = null;
                    continue;
                }
                boolean _hasAnnotation = AnnotationDefinition.GENERATE_INJECTOR.hasAnnotation((TAnnotableElement)clazz);
                boolean _not = !_hasAnnotation;
                valid = _not;
                if (!valid) {
                    this.addIssue(IssueCodes.getMessageForDI_ANN_INJECTOR_CANNOT_BE_INJECTED_INTO_INJECTOR(), (EObject)ann, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_INJECTOR_CANNOT_BE_INJECTED_INTO_INJECTOR", new String[0]);
                }
                ParameterizedTypeRef _superClassRef = null;
                if (clazz != null) {
                    _superClassRef = clazz.getSuperClassRef();
                }
                Type _declaredType = null;
                if (_superClassRef != null) {
                    _declaredType = _superClassRef.getDeclaredType();
                }
                Type type = _declaredType;
                TClass _xifexpression = null;
                _xifexpression = type instanceof TClass ? (TClass)type : null;
                clazz = _xifexpression;
            }
            if (!valid) {
                return;
            }
        }
        TMember _xifexpression = null;
        _xifexpression = annElem instanceof N4MemberDeclaration ? ((N4MemberDeclaration)annElem).getDefinedTypeElement() : null;
        TMember defMember = _xifexpression;
        boolean _matched = false;
        if (defMember instanceof TField) {
            _matched = true;
            this.holdsIsInjectableType(ann, ((TField)defMember).getTypeRef(), ((TField)defMember).getName());
        }
        if (!_matched && defMember instanceof TMethod) {
            _matched = true;
            boolean _isConstructor = ((TMethod)defMember).isConstructor();
            if (_isConstructor) {
                Consumer<TFormalParameter> _function = it -> this.holdsIsInjectableType(ann, (TFormalParameter)it);
                ((TMethod)defMember).getFpars().forEach(_function);
            } else {
                this.addIssue(IssueCodes.getMessageForDI_ANN_INJECT_METHOD_NOT_SUPPORTED_YET(), (EObject)ann, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_INJECT_METHOD_NOT_SUPPORTED_YET", new String[0]);
            }
        }
    }

    private boolean holdsAnnotatedTClassIsAnnotatedWith(Annotation ann, AnnotationDefinition requiredDef) {
        Type tClass;
        N4ClassDeclaration classDecl = N4JSDependencyInjectionValidator.getAnnotatedClass(ann);
        Type _definedType = null;
        if (classDecl != null) {
            _definedType = classDecl.getDefinedType();
        }
        if ((tClass = _definedType) != null && !requiredDef.hasAnnotation((TAnnotableElement)tClass)) {
            this.addIssue(IssueCodes.getMessageForDI_ANN_ONLY_ON_CLASS_ANNOTATED_WITH(ann.getName(), requiredDef.name), (EObject)ann, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_ONLY_ON_CLASS_ANNOTATED_WITH", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsAnnotatedTMethodIsContainedInTClassAnnotatedWith(Annotation ann, AnnotationDefinition requiredDef) {
        EObject tClass;
        N4MethodDeclaration methodDecl = N4JSDependencyInjectionValidator.getAnnotatedMethod(ann);
        Type _definedType = null;
        if (methodDecl != null) {
            _definedType = methodDecl.getDefinedType();
        }
        EObject _eContainer = null;
        if (_definedType != null) {
            _eContainer = _definedType.eContainer();
        }
        if ((tClass = _eContainer) instanceof TClass && !requiredDef.hasAnnotation((TAnnotableElement)((TClass)tClass))) {
            this.addIssue(IssueCodes.getMessageForDI_ANN_ONLY_ON_METHOD_IN_CLASS_ANNOTATED_WITH(ann.getName(), requiredDef.name), (EObject)ann, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_ONLY_ON_METHOD_IN_CLASS_ANNOTATED_WITH", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsAnnotatedTMethodHasCorrectSignature(Annotation ann) {
        Type tMethod;
        N4MethodDeclaration methodDecl = N4JSDependencyInjectionValidator.getAnnotatedMethod(ann);
        Type _definedType = null;
        if (methodDecl != null) {
            _definedType = methodDecl.getDefinedType();
        }
        if ((tMethod = _definedType) instanceof TMethod) {
            boolean isVoidOrOptional;
            boolean _not;
            Functions.Function1 _function = fpar -> {
                boolean _isInjectableType = N4JSDependencyInjectionValidator.isInjectableType((TypeArgument)fpar.getTypeRef());
                return !_isInjectableType;
            };
            Iterable nonInjectableParams = IterableExtensions.filter((Iterable)((TMethod)tMethod).getFpars(), (Functions.Function1)_function);
            Consumer<TFormalParameter> _function_1 = fpar -> {
                String _typeRefAsString = fpar.getTypeRef().getTypeRefAsString();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("at ");
                String _name = fpar.getName();
                _builder.append(_name);
                this.addIssue(IssueCodes.getMessageForDI_NOT_INJECTABLE(_typeRefAsString, _builder), fpar.getAstElement(), (EStructuralFeature)TypesPackage.eINSTANCE.getIdentifiableElement_Name(), "DI_NOT_INJECTABLE", new String[0]);
            };
            nonInjectableParams.forEach(_function_1);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)nonInjectableParams);
            boolean bl = _not = !_isEmpty;
            if (_not) {
                return false;
            }
            TypeRef retTR = ((TMethod)tMethod).getReturnTypeRef();
            boolean bl2 = isVoidOrOptional = TypeUtils.isVoid((TypeArgument)retTR) || ((TMethod)tMethod).isReturnValueOptional();
            if (isVoidOrOptional) {
                this.addIssue(IssueCodes.getMessageForDI_ANN_PROVIDES_METHOD_MUST_RETURN_VALUE(), (EObject)methodDecl, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "DI_ANN_PROVIDES_METHOD_MUST_RETURN_VALUE", new String[0]);
                return false;
            }
            return this.holdsIsInjectableType(ann, ((TMethod)tMethod).getReturnTypeRef());
        }
        return true;
    }

    private boolean holdsArgumentIsTypeRefToTClassAnnotatedWith(Annotation ann, AnnotationDefinition requiredDef) {
        boolean _not_1;
        AnnotationArgument _xifexpression = null;
        boolean _isEmpty = ann.getArgs().isEmpty();
        boolean _not = !_isEmpty;
        _xifexpression = _not ? (AnnotationArgument)ann.getArgs().get(0) : null;
        AnnotationArgument arg = _xifexpression;
        if (arg == null) {
            return true;
        }
        TypeRef _xifexpression_1 = null;
        _xifexpression_1 = arg instanceof TypeRefAnnotationArgument ? ((TypeRefAnnotationArgument)arg).getTypeRef() : null;
        TypeRef argTypeRef = _xifexpression_1;
        boolean _isTypeRefToTClassAnnotatedWith = N4JSDependencyInjectionValidator.isTypeRefToTClassAnnotatedWith(argTypeRef, requiredDef);
        boolean bl = _not_1 = !_isTypeRefToTClassAnnotatedWith;
        if (_not_1) {
            this.addIssue(IssueCodes.getMessageForDI_ANN_ARG_MUST_BE_ANNOTATED_WITH(ann.getName(), requiredDef.name), (EObject)arg, "DI_ANN_ARG_MUST_BE_ANNOTATED_WITH");
            return false;
        }
        return true;
    }

    private static boolean isTypeRefToTClassAnnotatedWith(TypeRef typeRef, AnnotationDefinition requiredAnn) {
        TClass tclazz = N4JSDependencyInjectionValidator.tClassOf(typeRef);
        return tclazz != null && requiredAnn.hasAnnotation((TAnnotableElement)tclazz);
    }

    private boolean holdsSecondArgIsSubtypeOfFirstArg(Annotation ann) {
        boolean _tripleEquals;
        Resource _eResource = null;
        if (ann != null) {
            _eResource = ann.eResource();
        }
        ResourceSet _resourceSet = null;
        if (_eResource != null) {
            _resourceSet = _eResource.getResourceSet();
        }
        boolean bl = _tripleEquals = _resourceSet == null;
        if (_tripleEquals) {
            return true;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)ann);
        TypeRef arg0TypeRef = N4JSDependencyInjectionValidator.getArgAsTypeRef(ann, 0);
        TypeRef arg1TypeRef = N4JSDependencyInjectionValidator.getArgAsTypeRef(ann, 1);
        if (arg0TypeRef != null && arg1TypeRef != null && !this.ts.subtypeSucceeded(G, (TypeArgument)arg1TypeRef, (TypeArgument)arg0TypeRef)) {
            this.addIssue(IssueCodes.getMessageForDI_ANN_BIND_SECOND_MUST_BE_SUBTYPE_FIRST(ann.getName()), (EObject)ann.getArgs().get(1), "DI_ANN_BIND_SECOND_MUST_BE_SUBTYPE_FIRST");
            return false;
        }
        return true;
    }

    private boolean holdsIsInjectableType(Annotation ann, TFormalParameter it) {
        if (it == null) {
            return true;
        }
        boolean _isVariadicOrOptional = it.isVariadicOrOptional();
        if (_isVariadicOrOptional) {
            this.addIssue(IssueCodes.getMessageForDI_VARARGS_NOT_INJECTABLE(), it.getAstElement(), (EStructuralFeature)TypesPackage.eINSTANCE.getIdentifiableElement_Name(), "DI_VARARGS_NOT_INJECTABLE", new String[0]);
            return false;
        }
        return this.holdsIsInjectableType(ann, it.getTypeRef(), it.getName());
    }

    private boolean holdsIsInjectableType(Annotation ann, TypeRef typeRef) {
        return this.holdsIsInjectableType(ann, typeRef, null);
    }

    private boolean holdsHasValidTargetType(Annotation bindAnn) {
        boolean _not_1;
        boolean _not;
        TypeRef targetTypeRef = N4JSDependencyInjectionValidator.getArgAsTypeRef(bindAnn, 1);
        if (targetTypeRef == null) {
            return false;
        }
        boolean _holdsIsInjectableType = this.holdsIsInjectableType(bindAnn, targetTypeRef, null);
        boolean bl = _not = !_holdsIsInjectableType;
        if (_not) {
            return false;
        }
        boolean _isConcrete = N4JSDependencyInjectionValidator.isConcrete(targetTypeRef);
        boolean bl2 = _not_1 = !_isConcrete;
        if (_not_1) {
            this.addIssue(IssueCodes.getMessageForDI_ANN_BIND_ABSTRACT_TARGET(), (EObject)bindAnn, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_BIND_ABSTRACT_TARGET", new String[0]);
            return false;
        }
        return true;
    }

    private static boolean isConcrete(TypeRef typeRef) {
        return N4JSDependencyInjectionValidator.isConcrete(typeRef.getDeclaredType());
    }

    private static boolean isConcrete(Type declType) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (declType instanceof TClass) {
            _matched = true;
            boolean _isAbstract = ((TClass)declType).isAbstract();
            boolean bl = _switchResult = !_isAbstract;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    private boolean holdsIsInjectableType(Annotation ann, TypeRef typeRef, String name) {
        boolean _not;
        boolean _eIsProxy;
        boolean _tripleNotEquals;
        if (typeRef == null) {
            return true;
        }
        Type _declaredType = typeRef.getDeclaredType();
        boolean bl = _tripleNotEquals = _declaredType != null;
        if (_tripleNotEquals && (_eIsProxy = typeRef.getDeclaredType().eIsProxy())) {
            return true;
        }
        boolean _isInjectableType = N4JSDependencyInjectionValidator.isInjectableType((TypeArgument)typeRef);
        boolean bl2 = _not = !_isInjectableType;
        if (_not) {
            String _xifexpression = null;
            if (name == null) {
                StringConcatenation _builder = new StringConcatenation();
                _xifexpression = _builder.toString();
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("at ");
                _builder_1.append(name);
                _xifexpression = _builder_1.toString();
            }
            String description = _xifexpression;
            this.addIssue(IssueCodes.getMessageForDI_NOT_INJECTABLE(typeRef.getTypeRefAsString(), description), (EObject)ann, "DI_NOT_INJECTABLE");
            return false;
        }
        return true;
    }

    public static boolean isInjectableType(TypeArgument typeArg) {
        boolean _tripleEquals_1;
        boolean _isProviderType;
        if (!(typeArg instanceof ParameterizedTypeRef)) {
            return false;
        }
        ParameterizedTypeRef typeRef = (ParameterizedTypeRef)typeArg;
        Type declType = typeRef.getDeclaredType();
        if (declType == null) {
            return false;
        }
        if (declType instanceof PrimitiveType) {
            return false;
        }
        if (declType instanceof BuiltInType || declType instanceof TObjectPrototype || declType instanceof VirtualBaseType) {
            return false;
        }
        if (!(declType instanceof TN4Classifier)) {
            return false;
        }
        if (declType instanceof TN4Classifier && !N4JSDependencyInjectionValidator.isProviderType(declType)) {
            boolean _not;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)declType.getTypeVars());
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                return false;
            }
        }
        if (_isProviderType = N4JSDependencyInjectionValidator.isProviderType(declType)) {
            boolean _isInjectableType;
            boolean _tripleEquals;
            Iterable targs = Iterables.filter((Iterable)typeRef.getTypeArgs(), TypeRef.class);
            int _size = IterableExtensions.size((Iterable)targs);
            boolean bl = _tripleEquals = _size == 1;
            if (_tripleEquals && (_isInjectableType = N4JSDependencyInjectionValidator.isInjectableType((TypeArgument)IterableExtensions.head((Iterable)targs)))) {
                return true;
            }
            return IterableExtensions.isEmpty((Iterable)targs);
        }
        TypingStrategy _typingStrategy = typeRef.getTypingStrategy();
        boolean bl = _tripleEquals_1 = TypingStrategy.STRUCTURAL_FIELDS == _typingStrategy;
        if (_tripleEquals_1) {
            return false;
        }
        return !(declType instanceof TypeVariable);
    }

    private static boolean isProviderType(Type type) {
        boolean _xifexpression = false;
        if (type instanceof TN4Classifier) {
            boolean _tripleEquals;
            boolean _xblockexpression = false;
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)type);
            TInterface _n4ProviderType = RuleEnvironmentExtensions.n4ProviderType(G);
            boolean bl = _tripleEquals = _n4ProviderType == type;
            if (_tripleEquals) {
                return true;
            }
            Functions.Function1 _function = iface -> {
                TInterface _n4ProviderType_1 = RuleEnvironmentExtensions.n4ProviderType(G);
                return iface == _n4ProviderType_1;
            };
            _xifexpression = _xblockexpression = IterableExtensions.exists((Iterable)SuperInterfacesIterable.of((TClassifier)((TClassifier)type)), (Functions.Function1)_function);
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    private static N4ClassDeclaration getAnnotatedClass(Annotation ann) {
        EObject elem = ann.getAnnotatedElement();
        if (elem instanceof ExportDeclaration) {
            elem = ((ExportDeclaration)elem).getExportedElement();
        }
        if (elem instanceof N4ClassDeclaration) {
            return (N4ClassDeclaration)elem;
        }
        return null;
    }

    private static N4MethodDeclaration getAnnotatedMethod(Annotation ann) {
        EObject elem = ann.getAnnotatedElement();
        if (elem instanceof N4MethodDeclaration) {
            return (N4MethodDeclaration)elem;
        }
        return null;
    }

    private static TypeRef getArgAsTypeRef(Annotation ann, int index) {
        AnnotationArgument _xifexpression = null;
        int _size = ann.getArgs().size();
        boolean _lessThan = index < _size;
        _xifexpression = _lessThan ? (AnnotationArgument)ann.getArgs().get(index) : null;
        AnnotationArgument arg = _xifexpression;
        if (arg instanceof TypeRefAnnotationArgument) {
            return ((TypeRefAnnotationArgument)arg).getTypeRef();
        }
        return null;
    }

    private static TypeRef getArgAsTypeRef(TAnnotation ann, int index) {
        TAnnotationArgument _xifexpression = null;
        int _size = ann.getArgs().size();
        boolean _lessThan = index < _size;
        _xifexpression = _lessThan ? (TAnnotationArgument)ann.getArgs().get(index) : null;
        TAnnotationArgument arg = _xifexpression;
        if (arg instanceof TAnnotationTypeRefArgument) {
            return ((TAnnotationTypeRefArgument)arg).getTypeRef();
        }
        return null;
    }

    public static boolean requiresInjection(TClass type) {
        Functions.Function1 _function = t -> {
            Functions.Function1 _function_1 = m -> AnnotationDefinition.INJECT.hasAnnotation((TAnnotableElement)m);
            return IterableExtensions.exists((Iterable)t.getOwnedMembers(), (Functions.Function1)_function_1);
        };
        return IterableExtensions.exists((Iterable)AllSuperTypesCollector.collect((ContainerType)type), (Functions.Function1)_function);
    }

    public static boolean isMarkedInjected(TClass type) {
        Functions.Function1 _function = t -> AnnotationDefinition.INJECTED.hasAnnotation((TAnnotableElement)t);
        return IterableExtensions.exists((Iterable)AllSuperTypesCollector.collect((ContainerType)type), (Functions.Function1)_function);
    }

    private void internalCheckAnnotationInjected(Annotation ann) {
        boolean _not;
        N4ClassDeclaration classDecl = N4JSDependencyInjectionValidator.getAnnotatedClass(ann);
        boolean _isInjectedApplicable = N4JSDependencyInjectionValidator.isInjectedApplicable(classDecl);
        boolean bl = _not = !_isInjectedApplicable;
        if (_not) {
            this.addIssue(IssueCodes.getMessageForDI_ANN_INJECTED_NOT_APPLICABLE(), (EObject)ann, (EStructuralFeature)N4JSPackage.eINSTANCE.getAnnotation_Name(), "DI_ANN_INJECTED_NOT_APPLICABLE", new String[0]);
            return;
        }
    }

    private static boolean isInjectedApplicable(N4ClassDeclaration classDecl) {
        return classDecl != null && classDecl.getDefinedTypeAsClass() != null;
    }

    public static class Binding_UseBinder {
        private final TAnnotation bindingTAnn;
        private final Annotation useBinderAnn;

        public Binding_UseBinder(TAnnotation bindingTAnn, Annotation useBinderAnn) {
            this.bindingTAnn = bindingTAnn;
            this.useBinderAnn = useBinderAnn;
        }
    }
}

