/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.jsdoc2spec.IJSDoc2SpecIssueAcceptor;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class JSDoc2SpecAcceptor
implements IJSDoc2SpecIssueAcceptor {
    List<Issue> warnings = new ArrayList<Issue>();

    @Override
    public void reset() {
        this.warnings.clear();
    }

    @Override
    public void addWarning(String message, EObject astElement) {
        this.warnings.add(new Issue(message, this.toPos(astElement)));
    }

    @Override
    public String warnings() {
        return this.warnings.stream().map(issue -> issue.toString()).collect(Collectors.joining("\n"));
    }

    private String toPos(EObject eobj) {
        EObject astNode;
        ICompositeNode node;
        if (eobj == null) {
            return "";
        }
        StringBuilder strb = new StringBuilder();
        String res = null;
        if (eobj.eResource() != null && (res = eobj.eResource().getURI().toString()).startsWith("platform:/resource/")) {
            res = res.substring("platform:/resource/".length());
        }
        if (res != null) {
            strb.append(res);
        }
        if ((node = NodeModelUtils.findActualNodeFor((EObject)(astNode = eobj instanceof SyntaxRelatedTElement ? ((SyntaxRelatedTElement)eobj).getAstElement() : eobj))) != null) {
            strb.append(":").append(node.getStartLine());
        }
        return strb.toString();
    }

    static class Issue {
        final String message;
        final String pos;

        Issue(String message, String pos) {
            this.message = message;
            this.pos = pos;
        }

        public String toString() {
            if (this.pos == null) {
                return this.message;
            }
            return String.valueOf(this.message) + " at " + this.pos;
        }
    }
}

