/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;

public class URIUtils {
    private static final String L = "L/";
    private static final String P = "P/";

    public static URI convert(IResource iResource) {
        if (iResource == null) {
            return null;
        }
        String projectPath = iResource.toString();
        String fullPathString = iResource.getFullPath().toString();
        URI uri = projectPath.startsWith(P) || projectPath.startsWith(L) ? URI.createPlatformResourceURI((String)fullPathString, (boolean)true) : URI.createFileURI((String)fullPathString);
        return uri;
    }

    public static boolean isPlatformResourceUriPointingToProject(URI uri) {
        return uri.isPlatformResource() && uri.segmentCount() == 2;
    }

    public static URI deriveProjectURIFromFileLocation(File file) {
        try {
            URI createURI = URI.createURI((String)file.getAbsoluteFile().toURI().toURL().toString());
            String last = createURI.lastSegment();
            if (last != null && last.isEmpty()) {
                createURI = createURI.trimSegments(1);
            }
            return createURI;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URI toFileUri(java.net.URI jnUri) {
        if (jnUri == null) {
            return null;
        }
        File file = new File(jnUri);
        String path = file.getAbsolutePath();
        URI uri = URI.createFileURI((String)path);
        return uri;
    }

    public static boolean equals(URI uri1, URI uri2) {
        if (uri1 == uri2) {
            return true;
        }
        String string1 = URIUtils.toString(uri1);
        String string2 = URIUtils.toString(uri2);
        return string1.equals(string2);
    }

    public static int hashCode(URI uri) {
        return URIUtils.toString(uri).hashCode();
    }

    public static String toString(URI uri) {
        String result = null;
        if (uri.isFile()) {
            String fileString = uri.toFileString();
            File file = new File(fileString);
            Path path = file.toPath();
            try {
                String newResult = path.toRealPath(new LinkOption[0]).toFile().toURI().toString();
                if (newResult.endsWith("/")) {
                    newResult = newResult.substring(0, newResult.length() - 1);
                }
                result = newResult;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = uri.toString();
        }
        return result;
    }

    public static URI normalize(URI uri) {
        return URI.createURI((String)URIUtils.toString(uri));
    }
}

