/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.navigator.N4JSProjectExplorerLabelProvider;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.ui.viewer.TableViewerBuilder;
import org.eclipse.n4js.ui.workingsets.ManualAssociationAwareWorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetEditWizard;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WorkingSetManualAssociationWizard
extends WorkingSetEditWizard {
    private static final String TITLE = "Manual Association Working Set";
    private static final String DESCRIPTION = "Enter a working set name and select projects that have to be associated with the working set.";
    private static final Point SHELL_SIZE = new Point(600, 650);
    private static final Comparator<IProject> PROJECT_NAME_COMPARATOR = (left, right) -> {
        if (left == null) {
            return right == null ? 0 : 1;
        }
        if (right == null) {
            return -1;
        }
        return left.getName().compareTo(right.getName());
    };
    private final AtomicReference<WorkingSet> workingSetRef = new AtomicReference();
    private final AtomicReference<String> originalName = new AtomicReference();
    @Inject
    private N4JSProjectExplorerLabelProvider labelProvider;

    public void addPages() {
        this.addPage((IWizardPage)new WizardPage(""){
            private Text nameText;
            private final Collection<IProject> workspaceProjects;
            private final Collection<IProject> workingSetProjects;
            {
                this.workspaceProjects = Sets.newTreeSet((Comparator)PROJECT_NAME_COMPARATOR);
                this.workingSetProjects = Sets.newTreeSet((Comparator)PROJECT_NAME_COMPARATOR);
            }

            public void createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).create());
                composite.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create());
                new Label(composite, 0).setText("Working set name:");
                this.nameText = new Text(composite, 2048);
                this.nameText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
                Composite tableComposite = new Composite(composite, 0);
                tableComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).create());
                tableComposite.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).create());
                Group workspaceGroup = new Group(tableComposite, 4);
                workspaceGroup.setText("Available workspace projects");
                workspaceGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
                workspaceGroup.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create());
                final TableViewer allProjectsViewer = (TableViewer)new TableViewerBuilder(Collections.singletonList("")).setHasBorder(true).setHeaderVisible(false).setLinesVisible(false).setMultipleSelection(true).setColumnWidthsInPixel(Ints.asList((int[])new int[]{350})).setLabelProvider((IBaseLabelProvider)WorkingSetManualAssociationWizard.this.labelProvider).build((Composite)workspaceGroup);
                Composite buttonComposite = new Composite(tableComposite, 0);
                buttonComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
                Button addButton = new Button(buttonComposite, 8);
                addButton.setImage((Image)ImageDescriptorCache.ImageRef.RIGHT_ARROW.asImage().orNull());
                addButton.setToolTipText("Add all selected workspace projects");
                addButton.setEnabled(false);
                Button removeButton = new Button(buttonComposite, 8);
                removeButton.setImage((Image)ImageDescriptorCache.ImageRef.LEFT_ARROW.asImage().orNull());
                removeButton.setToolTipText("Remove all selected working set element projects");
                removeButton.setEnabled(false);
                Group workingSetGroup = new Group(tableComposite, 4);
                workingSetGroup.setText("Associated working set projects");
                workingSetGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
                workingSetGroup.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create());
                final TableViewer associatedProjectsViewer = (TableViewer)new TableViewerBuilder(Collections.singletonList("")).setHasBorder(true).setHeaderVisible(false).setLinesVisible(false).setMultipleSelection(true).setColumnWidthsInPixel(Ints.asList((int[])new int[]{350})).setLabelProvider((IBaseLabelProvider)WorkingSetManualAssociationWizard.this.labelProvider).build((Composite)workingSetGroup);
                addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IStructuredSelection selection = allProjectsViewer.getStructuredSelection();
                        if (selection != null && !selection.isEmpty()) {
                            Object[] projects = (IProject[])Arrays2.filter((Object[])selection.toArray(), IProject.class);
                            allProjectsViewer.remove(projects);
                            associatedProjectsViewer.add(projects);
                            workspaceProjects.removeAll(Arrays.asList(projects));
                            workingSetProjects.addAll(Arrays.asList(projects));
                            this.setPageComplete(this.validatePage());
                        }
                    }
                });
                removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IStructuredSelection selection = associatedProjectsViewer.getStructuredSelection();
                        if (selection != null && !selection.isEmpty()) {
                            Object[] projects = (IProject[])Arrays2.filter((Object[])selection.toArray(), IProject.class);
                            associatedProjectsViewer.remove(projects);
                            allProjectsViewer.add(projects);
                            workingSetProjects.removeAll(Arrays.asList(projects));
                            workspaceProjects.addAll(Arrays.asList(projects));
                            this.setPageComplete(this.validatePage());
                        }
                    }
                });
                associatedProjectsViewer.addSelectionChangedListener(event -> {
                    IStructuredSelection selection = associatedProjectsViewer.getStructuredSelection();
                    removeButton.setEnabled(selection != null && !selection.isEmpty());
                });
                allProjectsViewer.addSelectionChangedListener(event -> {
                    IStructuredSelection selection = allProjectsViewer.getStructuredSelection();
                    addButton.setEnabled(selection != null && !selection.isEmpty());
                });
                this.setPageComplete(false);
                this.setControl((Control)composite);
                Optional<WorkingSet> editedWorkingSet = WorkingSetManualAssociationWizard.this.getEditedWorkingSet();
                this.workspaceProjects.addAll(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
                if (editedWorkingSet.isPresent()) {
                    ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet workingSet = (ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet)editedWorkingSet.get();
                    WorkingSetManualAssociationWizard.this.workingSetRef.set(workingSet);
                    this.nameText.setText(workingSet.getName());
                    this.nameText.selectAll();
                    this.workingSetProjects.addAll(workingSet.getAssociatedProjects());
                    this.workspaceProjects.removeAll(this.workingSetProjects);
                    WorkingSetManualAssociationWizard.this.originalName.set(workingSet.getName());
                }
                composite.getDisplay().asyncExec(() -> {
                    this.setTitle(WorkingSetManualAssociationWizard.TITLE);
                    this.setDescription(WorkingSetManualAssociationWizard.DESCRIPTION);
                    allProjectsViewer.setInput(this.workspaceProjects);
                    associatedProjectsViewer.setInput(this.workingSetProjects);
                });
                this.nameText.addModifyListener(e -> this.setPageComplete(this.validatePage()));
            }

            public void setVisible(boolean visible) {
                if (visible) {
                    Rectangle location = UIUtils.getConstrainedShellBounds(this.getShell(), SHELL_SIZE);
                    this.getShell().setBounds(location);
                }
                super.setVisible(visible);
            }

            private boolean validatePage() {
                String errorMessage = null;
                String name = this.nameText.getText();
                WorkingSetManager manager = WorkingSetManualAssociationWizard.this.getManager();
                if (manager == null) {
                    errorMessage = "No active working set manager is available.";
                }
                if (errorMessage == null && (name == null || name.trim().length() == 0)) {
                    errorMessage = "Working set name should be specified.";
                }
                if (errorMessage == null && !name.equals(WorkingSetManualAssociationWizard.this.originalName.get()) && WorkingSetManualAssociationWizard.this.getAllWorkingSets().stream().anyMatch(ws -> ws.getName().equals(name))) {
                    errorMessage = "A working set already exists with name '" + name + "'.";
                }
                if (errorMessage != null) {
                    WorkingSetManualAssociationWizard.this.workingSetRef.set(null);
                } else {
                    FluentIterable projectNames = FluentIterable.from(this.workingSetProjects).transform(p -> p.getName());
                    WorkingSetManualAssociationWizard.this.workingSetRef.set(new ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet((Iterable<String>)projectNames, name, manager));
                }
                this.setMessage(errorMessage, 3);
                return errorMessage == null;
            }
        });
    }

    @Override
    public Optional<WorkingSet> getWorkingSet() {
        return Optional.fromNullable((Object)this.workingSetRef.get());
    }

    public boolean performFinish() {
        return this.getWorkingSet() != null;
    }
}

