/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.function.BooleanSupplier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FieldAccessor;
import org.eclipse.n4js.n4JS.N4ClassExpression;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.postprocessing.ASTProcessor;
import org.eclipse.n4js.postprocessing.AbstractProcessor;
import org.eclipse.n4js.postprocessing.DestructureProcessor;
import org.eclipse.n4js.postprocessing.PolyProcessor;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.typeRefs.DeferredTypeRef;
import org.eclipse.n4js.ts.typeRefs.OptionalFieldStrategy;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
public class TypeProcessor
extends AbstractProcessor {
    @Inject
    private ASTProcessor astProcessor;
    @Inject
    private PolyProcessor polyProcessor;
    @Inject
    private DestructureProcessor destructureProcessor;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public void typeNode(RuleEnvironment G, EObject node, ASTMetaInfoCache cache, int indentLevel) {
        boolean _isTypableNode = N4JSLanguageUtils.isTypableNode(node);
        if (_isTypableNode) {
            TypableElement nodeCasted = (TypableElement)node;
            if (DestructureUtils.isArrayOrObjectLiteralUsedAsDestructuringPattern((EObject)node) && this.polyProcessor.isEntryPoint(nodeCasted)) {
                AbstractProcessor.log(indentLevel, "ignored (array or object literal being used as a destructuring pattern)");
                this.destructureProcessor.typeDestructuringPattern(G, node, cache, indentLevel);
            } else {
                this.typeNode2(G, nodeCasted, cache, indentLevel);
            }
        } else {
            EClass _eClass = null;
            if (node != null) {
                _eClass = node.eClass();
            }
            String _name = null;
            if (_eClass != null) {
                _name = _eClass.getName();
            }
            String _plus = "ignored (not a typable node: " + _name;
            String _plus_1 = String.valueOf(_plus) + ")";
            AbstractProcessor.log(indentLevel, _plus_1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void typeNode2(RuleEnvironment G, TypableElement node, ASTMetaInfoCache cache, int indentLevel) {
        try {
            boolean _isResponsibleFor = this.polyProcessor.isResponsibleFor(node);
            if (_isResponsibleFor) {
                boolean _isEntryPoint = this.polyProcessor.isEntryPoint(node);
                if (!_isEntryPoint) {
                    AbstractProcessor.log(indentLevel, "deferred (nested in poly expression --> will be inferred during inference of outer poly expression)");
                    return;
                }
                AbstractProcessor.log(indentLevel, "asking PolyComputer ...");
                this.polyProcessor.inferType(G, (Expression)node, cache);
                BooleanSupplier _function = () -> {
                    EObject typeModelElem = N4JSLanguageUtils.getDefinedTypeModelElement((EObject)node);
                    return typeModelElem == null || IteratorExtensions.isEmpty((Iterator)Iterators.filter((Iterator)typeModelElem.eAllContents(), DeferredTypeRef.class));
                };
                AbstractProcessor.assertTrueIfRigid(cache, "poly computer did not replace DeferredTypeRef", _function);
            } else {
                AbstractProcessor.log(indentLevel, "asking Xsemantics ...");
                TypeRef result = this.invokeTypeJudgmentToInferType(G, node);
                TypeRef resultAdjusted = this.adjustResultForLocationInAST(G, result, N4JSASTUtils.skipParenExpressionDownward((TypableElement)node));
                this.checkCanceled(G);
                cache.storeType(node, resultAdjusted);
            }
        }
        catch (Throwable _t) {
            if (!(_t instanceof Throwable)) {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Throwable th = _t;
            this.operationCanceledManager.propagateIfCancelException(th);
            String _message = th.getMessage();
            String _plus = "exception while obtaining type from type system: " + _message;
            AbstractProcessor.logErr(_plus);
            th.printStackTrace();
            cache.storeType(node, (TypeRef)TypeRefsFactory.eINSTANCE.createUnknownTypeRef());
        }
        AbstractProcessor.log(indentLevel, cache.getTypeFailSafe(node));
    }

    private <T extends TypeRef> T adjustResultForLocationInAST(RuleEnvironment G, T result, TypableElement astNode) {
        T typeRef = result;
        if (typeRef instanceof ParameterizedTypeRef) {
            boolean _tripleNotEquals;
            OptionalFieldStrategy optionalFieldStrategy = N4JSLanguageUtils.calculateOptionalFieldStrategy(astNode, typeRef);
            OptionalFieldStrategy _aSTNodeOptionalFieldStrategy = typeRef.getASTNodeOptionalFieldStrategy();
            boolean bl = _tripleNotEquals = _aSTNodeOptionalFieldStrategy != optionalFieldStrategy;
            if (_tripleNotEquals) {
                TypeRef typeRefCpy = (TypeRef)TypeUtils.copy(typeRef);
                ((ParameterizedTypeRef)typeRefCpy).setASTNodeOptionalFieldStrategy(optionalFieldStrategy);
                return (T)typeRefCpy;
            }
        }
        return result;
    }

    public TypeRef getType(RuleEnvironment G, TypableElement objRaw) {
        if (objRaw == null) {
            return TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
        }
        TypableElement _xifexpression = null;
        boolean _eIsProxy = objRaw.eIsProxy();
        if (_eIsProxy) {
            TypableElement _xblockexpression = null;
            ResourceSet resSet = RuleEnvironmentExtensions.getContextResource(G).getResourceSet();
            EObject _resolve = EcoreUtil.resolve((EObject)objRaw, (ResourceSet)resSet);
            _xifexpression = _xblockexpression = (TypableElement)_resolve;
        } else {
            _xifexpression = objRaw;
        }
        TypableElement obj = _xifexpression;
        Resource res = obj.eResource();
        if (res instanceof N4JSResource) {
            if (((N4JSResource)res).isFullyProcessed() && ((N4JSResource)res).getScript().eIsProxy()) {
                boolean _not;
                boolean _isTypeModelElement = N4JSLanguageUtils.isTypeModelElement((EObject)obj);
                boolean bl = _not = !_isTypeModelElement;
                if (_not) {
                    throw new IllegalStateException("not a type model element: " + obj);
                }
                return this.invokeTypeJudgmentToInferType(G, obj);
            }
            ((N4JSResource)res).performPostProcessing(RuleEnvironmentExtensions.getCancelIndicator(G));
            if (((N4JSResource)res).isPostProcessing() && N4JSLanguageUtils.isTypeModelElement((EObject)obj)) {
                EObject astNodeToProcess;
                EObject _xifexpression_1 = null;
                if (obj instanceof SyntaxRelatedTElement) {
                    _xifexpression_1 = ((SyntaxRelatedTElement)obj).getAstElement();
                }
                if ((astNodeToProcess = _xifexpression_1) instanceof TypableElement) {
                    obj = (TypableElement)astNodeToProcess;
                }
            }
            return this.getTypeInN4JSResource(G, (N4JSResource)res, obj);
        }
        return this.invokeTypeJudgmentToInferType(G, obj);
    }

    private TypeRef getTypeInN4JSResource(RuleEnvironment G, N4JSResource res, TypableElement obj) {
        boolean _isTypeModelElement = N4JSLanguageUtils.isTypeModelElement((EObject)obj);
        if (_isTypeModelElement) {
            return this.invokeTypeJudgmentToInferType(G, obj);
        }
        if (N4JSLanguageUtils.isASTNode((EObject)obj) && N4JSLanguageUtils.isTypableNode((EObject)obj)) {
            ASTMetaInfoCache cache = res.getASTMetaInfoCacheVerifyContext();
            if (!res.isPostProcessing() && !res.isFullyProcessed()) {
                URI _uRI = res.getURI();
                String _plus = "post-processing neither in progress nor completed after calling #performPostProcessing() in resource: " + _uRI;
                throw new IllegalStateException(_plus);
            }
            if (!cache.isPostProcessing() && !cache.isFullyProcessed()) {
                IllegalStateException e = new IllegalStateException("post-processing flags out of sync between resource and cache (hint: this is often caused by an accidental cache clear!!)");
                e.printStackTrace();
                throw e;
            }
            boolean _isPostProcessing = cache.isPostProcessing();
            if (_isPostProcessing) {
                TypeRef resultFromCache = cache.getTypeFailSafe(obj);
                if (resultFromCache == null) {
                    AbstractProcessor.log(0, "***** forward reference to: " + obj);
                    return this.getTypeOfForwardReference(G, obj, cache);
                }
                return resultFromCache;
            }
            boolean _isFullyProcessed = cache.isFullyProcessed();
            if (_isFullyProcessed) {
                return cache.getType(obj);
            }
        } else {
            return TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
        }
        return null;
    }

    private TypeRef getTypeOfForwardReference(RuleEnvironment G, TypableElement node, ASTMetaInfoCache cache) {
        AbstractProcessor.assertTrueIfRigid(cache, "argument 'node' must be an AST node", N4JSLanguageUtils.isASTNode((EObject)node));
        boolean _isForwardReferenceWhileTypingDestructuringPattern = this.destructureProcessor.isForwardReferenceWhileTypingDestructuringPattern((EObject)node);
        if (_isForwardReferenceWhileTypingDestructuringPattern) {
            return this.destructureProcessor.handleForwardReferenceWhileTypingDestructuringPattern(G, node, cache);
        }
        boolean isLegal = this.astProcessor.processSubtree_forwardReference(G, node, cache);
        if (isLegal) {
            boolean isCyclicForwardReference = cache.astNodesCurrentlyBeingTyped.contains(node);
            if (isCyclicForwardReference) {
                if (node instanceof VariableDeclaration || node instanceof N4FieldDeclaration || node instanceof PropertyNameValuePair) {
                    Expression callee;
                    Expression expr = TypeProcessor.getExpressionOfVFP((EObject)node);
                    if (expr instanceof N4ClassExpression) {
                        return this.invokeTypeJudgmentToInferType(G, (TypableElement)expr);
                    }
                    if (expr instanceof NewExpression && (callee = ((NewExpression)expr).getCallee()) instanceof N4ClassExpression) {
                        TypeRef calleeType = this.invokeTypeJudgmentToInferType(G, (TypableElement)callee);
                        Type calleeTypeStaticType = this.tsh.getStaticType(G, (TypeTypeRef)calleeType);
                        return TypeUtils.createTypeRef((Type)calleeTypeStaticType, (TypeArgument[])new TypeArgument[0]);
                    }
                    TypeRef declTypeRef = TypeProcessor.getDeclaredTypeRefOfVFP((EObject)node);
                    Object _xifexpression = null;
                    _xifexpression = declTypeRef != null ? declTypeRef : RuleEnvironmentExtensions.anyTypeRef(G);
                    return _xifexpression;
                }
                if (node instanceof FieldAccessor) {
                    TypeRef declTypeRef_1 = ((FieldAccessor)node).getDeclaredTypeRef();
                    Object _xifexpression_1 = null;
                    _xifexpression_1 = declTypeRef_1 != null ? declTypeRef_1 : RuleEnvironmentExtensions.anyTypeRef(G);
                    return _xifexpression_1;
                }
                if (node instanceof TypeDefiningElement) {
                    return RuleEnvironmentExtensions.wrapTypeInTypeRef(G, ((TypeDefiningElement)node).getDefinedType(), new TypeArgument[0]);
                }
                if (node instanceof Expression && node.eContainer() instanceof YieldExpression) {
                    return this.invokeTypeJudgmentToInferType(G, node);
                }
                String msg = "handling of a legal case of cyclic forward references missing in TypeProcessor";
                AbstractProcessor.logErr("handling of a legal case of cyclic forward references missing in TypeProcessor");
                IllegalStateException e = new IllegalStateException("handling of a legal case of cyclic forward references missing in TypeProcessor");
                e.printStackTrace();
                return TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
            }
            boolean _isSemiCyclicForwardReferenceInForLoop = this.astProcessor.isSemiCyclicForwardReferenceInForLoop((EObject)node, cache);
            if (_isSemiCyclicForwardReferenceInForLoop) {
                TypeRef declTypeRef_2 = ((VariableDeclaration)node).getDeclaredTypeRef();
                Object _xifexpression_2 = null;
                _xifexpression_2 = declTypeRef_2 != null ? declTypeRef_2 : RuleEnvironmentExtensions.anyTypeRef(G);
                return _xifexpression_2;
            }
            return cache.getType(node);
        }
        Resource _eResource = node.eResource();
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        String msg_1 = "*#*#*#*#*#* ILLEGAL FORWARD REFERENCE to " + node + " in " + _uRI;
        AbstractProcessor.logErr(msg_1);
        return TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
    }

    private static Expression getExpressionOfVFP(EObject vfp) {
        Expression _switchResult = null;
        boolean _matched = false;
        if (vfp instanceof VariableDeclaration) {
            _matched = true;
            _switchResult = ((VariableDeclaration)vfp).getExpression();
        }
        if (!_matched && vfp instanceof N4FieldDeclaration) {
            _matched = true;
            _switchResult = ((N4FieldDeclaration)vfp).getExpression();
        }
        if (!_matched && vfp instanceof PropertyNameValuePair) {
            _matched = true;
            _switchResult = ((PropertyNameValuePair)vfp).getExpression();
        }
        return _switchResult;
    }

    private static TypeRef getDeclaredTypeRefOfVFP(EObject vfp) {
        TypeRef _switchResult = null;
        boolean _matched = false;
        if (vfp instanceof VariableDeclaration) {
            _matched = true;
            _switchResult = ((VariableDeclaration)vfp).getDeclaredTypeRef();
        }
        if (!_matched && vfp instanceof N4FieldDeclaration) {
            _matched = true;
            _switchResult = ((N4FieldDeclaration)vfp).getDeclaredTypeRef();
        }
        if (!_matched && vfp instanceof PropertyNameValuePair) {
            _matched = true;
            _switchResult = ((PropertyNameValuePair)vfp).getDeclaredTypeRef();
        }
        return _switchResult;
    }
}

