/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.StructuralTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TStructField;
import org.eclipse.n4js.ts.types.TStructGetter;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TStructMethod;
import org.eclipse.n4js.ts.types.TStructSetter;
import org.eclipse.n4js.ts.types.TStructuralType;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class N4JSTypesFromTypeRefBuilder {
    void createStructuralType(StructuralTypeRef structTypeRef, TModule target) {
        boolean _not;
        boolean _isEmpty = structTypeRef.getAstStructuralMembers().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ResourceSet resSet = structTypeRef.eResource().getResourceSet();
            if (resSet == null) {
                throw new IllegalArgumentException("structTypeRef must be contained in AST");
            }
            BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)resSet);
            TStructuralType structType = TypesFactory.eINSTANCE.createTStructuralType();
            Functions.Function1 _function = currStructMember -> {
                TStructMember clone = (TStructMember)TypeUtils.copyWithProxies((EObject)currStructMember);
                this.applyDefaults(builtInTypeScope, (EObject)clone);
                clone.setAstElement((EObject)currStructMember);
                currStructMember.setDefinedMember(clone);
                return clone;
            };
            structType.getOwnedMembers().addAll((Collection)ListExtensions.map((List)structTypeRef.getAstStructuralMembers(), (Functions.Function1)_function));
            structTypeRef.setStructuralType(structType);
            EList _internalTypes = target.getInternalTypes();
            _internalTypes.add((Object)structType);
        }
    }

    void createTFunction(FunctionTypeExpression fte, TModule target) {
        boolean _isGeneric = fte.isGeneric();
        if (_isGeneric) {
            boolean _tripleEquals;
            ResourceSet resSet = fte.eResource().getResourceSet();
            if (resSet == null) {
                throw new IllegalArgumentException("fte must be contained in AST");
            }
            BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)resSet);
            TFunction ft = TypesFactory.eINSTANCE.createTFunction();
            Functions.Function1 _function = currTypeVar -> (TypeVariable)TypeUtils.copyWithProxies((EObject)currTypeVar);
            ft.getTypeVars().addAll((Collection)ListExtensions.map((List)fte.getTypeVars(), (Functions.Function1)_function));
            Functions.Function1 _function_1 = currFpar -> {
                TFormalParameter clone = (TFormalParameter)TypeUtils.copyWithProxies((EObject)currFpar);
                this.applyDefaults(builtInTypeScope, (EObject)clone);
                clone.setAstElement((EObject)currFpar);
                return clone;
            };
            ft.getFpars().addAll((Collection)ListExtensions.map((List)fte.getFpars(), (Functions.Function1)_function_1));
            ft.setReturnTypeRef((TypeRef)TypeUtils.copyWithProxies((EObject)fte.getReturnTypeRef()));
            ft.setDeclaredThisType((TypeRef)TypeUtils.copyWithProxies((EObject)fte.getDeclaredThisType()));
            TypeRef _returnTypeRef = ft.getReturnTypeRef();
            boolean bl = _tripleEquals = _returnTypeRef == null;
            if (_tripleEquals) {
                ft.setReturnTypeRef((TypeRef)builtInTypeScope.getAnyTypeRef());
            }
            fte.setDeclaredType(ft);
            ft.setAstElement((EObject)fte);
            EList _internalTypes = target.getInternalTypes();
            _internalTypes.add((Object)ft);
        }
    }

    private void _applyDefaults(BuiltInTypeScope builtInTypeScope, TStructField field) {
        boolean _tripleEquals;
        TypeRef _typeRef = field.getTypeRef();
        boolean bl = _tripleEquals = _typeRef == null;
        if (_tripleEquals) {
            field.setTypeRef((TypeRef)builtInTypeScope.getAnyTypeRef());
        }
    }

    private void _applyDefaults(BuiltInTypeScope builtInTypeScope, TStructGetter getter) {
        boolean _tripleEquals;
        TypeRef _declaredTypeRef = getter.getDeclaredTypeRef();
        boolean bl = _tripleEquals = _declaredTypeRef == null;
        if (_tripleEquals) {
            getter.setDeclaredTypeRef((TypeRef)builtInTypeScope.getAnyTypeRef());
        }
    }

    private void _applyDefaults(BuiltInTypeScope builtInTypeScope, TStructSetter setter) {
        boolean _tripleEquals;
        TFormalParameter _fpar = setter.getFpar();
        boolean bl = _tripleEquals = _fpar == null;
        if (_tripleEquals) {
            setter.setFpar((TFormalParameter)TypesFactory.eINSTANCE.createTAnonymousFormalParameter());
        }
        this.applyDefaults(builtInTypeScope, (EObject)setter.getFpar());
    }

    private void _applyDefaults(BuiltInTypeScope builtInTypeScope, TStructMethod method) {
        boolean _tripleEquals;
        Consumer<TFormalParameter> _function = it -> this.applyDefaults(builtInTypeScope, (EObject)it);
        method.getFpars().forEach(_function);
        TypeRef _returnTypeRef = method.getReturnTypeRef();
        boolean bl = _tripleEquals = _returnTypeRef == null;
        if (_tripleEquals) {
            method.setReturnTypeRef((TypeRef)builtInTypeScope.getVoidTypeRef());
        }
    }

    private void _applyDefaults(BuiltInTypeScope builtInTypeScope, TFormalParameter fpar) {
        boolean _tripleEquals;
        TypeRef _typeRef = fpar.getTypeRef();
        boolean bl = _tripleEquals = _typeRef == null;
        if (_tripleEquals) {
            fpar.setTypeRef((TypeRef)builtInTypeScope.getAnyTypeRef());
        }
    }

    private void applyDefaults(BuiltInTypeScope builtInTypeScope, EObject method) {
        if (method instanceof TStructMethod) {
            this._applyDefaults(builtInTypeScope, (TStructMethod)method);
            return;
        }
        if (method instanceof TStructGetter) {
            this._applyDefaults(builtInTypeScope, (TStructGetter)method);
            return;
        }
        if (method instanceof TStructSetter) {
            this._applyDefaults(builtInTypeScope, (TStructSetter)method);
            return;
        }
        if (method instanceof TStructField) {
            this._applyDefaults(builtInTypeScope, (TStructField)method);
            return;
        }
        if (method instanceof TFormalParameter) {
            this._applyDefaults(builtInTypeScope, (TFormalParameter)method);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(builtInTypeScope, method).toString());
    }
}

