/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.ui.building.BuildDataWithRequestRebuild;
import org.eclipse.n4js.ui.building.DoUpdateImplementation;
import org.eclipse.n4js.ui.building.N4JSGenerateImmediatelyBuilderState;
import org.eclipse.n4js.ui.building.ResourceDescriptionWithoutModuleUserData;
import org.eclipse.n4js.ui.building.WriteNewResourceDescriptionsImplementation;
import org.eclipse.xtext.builder.builderState.AbstractBuilderState;
import org.eclipse.xtext.builder.clustering.CurrentDescriptions;
import org.eclipse.xtext.builder.debug.IBuildLogger;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.resourceloader.IResourceLoader;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.SourceLevelURIsAdapter;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.Strings;

class N4ClusteringBuilderState
extends AbstractBuilderState {
    public static final String RESOURCELOADER_CROSS_LINKING = "org.eclipse.xtext.builder.resourceloader.crossLinking";
    public static final String RESOURCELOADER_GLOBAL_INDEX = "org.eclipse.xtext.builder.resourceloader.globalIndex";
    private static final Logger LOGGER = Logger.getLogger(N4JSGenerateImmediatelyBuilderState.class);
    @Inject
    private IResourceServiceProvider.Registry managerRegistry;
    @Inject
    private IResourceClusteringPolicy clusteringPolicy;
    @Inject
    @Named(value="org.eclipse.xtext.builder.resourceloader.globalIndex")
    private IResourceLoader globalIndexResourceLoader;
    @Inject
    @Named(value="org.eclipse.xtext.builder.resourceloader.crossLinking")
    private IResourceLoader crossLinkingResourceLoader;
    @Inject
    private IWorkspace workspace;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    private IBuildLogger buildLogger;

    N4ClusteringBuilderState() {
    }

    protected Collection<IResourceDescription.Delta> doUpdate(BuildData buildData, ResourceDescriptionsData newData, IProgressMonitor monitor) {
        return new DoUpdateImplementation(this, (BuildDataWithRequestRebuild)buildData, newData, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1), this.buildLogger, this.crossLinkingResourceLoader, this.clusteringPolicy).doUpdate();
    }

    protected void installSourceLevelURIs(BuildData buildData) {
        ResourceSet resourceSet = buildData.getResourceSet();
        Iterable sourceLevelUris = Iterables.concat((Iterable)buildData.getToBeUpdated(), (Iterable)buildData.getURIQueue());
        HashSet sourceUris = Sets.newHashSet();
        for (URI uri : sourceLevelUris) {
            if (!buildData.getSourceLevelURICache().getOrComputeIsSource(uri, this.resourceServiceProviderRegistry)) continue;
            sourceUris.add(uri);
            Resource resource = resourceSet.getResource(uri, false);
            if (!(resource instanceof StorageAwareResource) || !((StorageAwareResource)resource).isLoadedFromStorage()) continue;
            resource.unload();
        }
        SourceLevelURIsAdapter.setSourceLevelUris((ResourceSet)resourceSet, (Collection)sourceUris);
    }

    protected void writeNewResourceDescriptions(BuildData buildData, IResourceDescriptions oldState, CurrentDescriptions newState, IProgressMonitor monitor) {
        new WriteNewResourceDescriptionsImplementation(this, buildData, oldState, newState, monitor, this.buildLogger, this.globalIndexResourceLoader, this.clusteringPolicy, this.compilerPhases).writeNewResourceDescriptions();
    }

    protected IProject getBuiltProject(BuildData buildData) {
        if (Strings.isEmpty((String)buildData.getProjectName())) {
            return null;
        }
        return this.workspace.getRoot().getProject(buildData.getProjectName());
    }

    protected void clearResourceSet(ResourceSet resourceSet) {
        boolean wasDeliver = resourceSet.eDeliver();
        try {
            resourceSet.eSetDeliver(false);
            resourceSet.getResources().clear();
        }
        finally {
            resourceSet.eSetDeliver(wasDeliver);
        }
    }

    protected Resource addResource(Resource resource, ResourceSet resourceSet) {
        URI uri = resource.getURI();
        Resource r = resourceSet.getResource(uri, false);
        if (r == null) {
            resourceSet.getResources().add((Object)resource);
            return resource;
        }
        return r;
    }

    protected void queueAffectedResources(Set<URI> allRemainingURIs, IResourceDescriptions oldState, CurrentDescriptions newState, Collection<IResourceDescription.Delta> changedDeltas, Collection<IResourceDescription.Delta> allDeltas, BuildDataWithRequestRebuild buildData, IProgressMonitor monitor) {
        if (allDeltas.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)allRemainingURIs.size());
        Iterator<URI> iter = allRemainingURIs.iterator();
        while (iter.hasNext()) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI candidateURI = iter.next();
            IResourceDescription candidateDescription = oldState.getResourceDescription(candidateURI);
            IResourceDescription.Manager manager = this.getResourceDescriptionManager(candidateURI);
            if (candidateDescription == null || manager == null) {
                iter.remove();
            } else {
                boolean affected = manager instanceof IResourceDescription.Manager.AllChangeAware ? ((IResourceDescription.Manager.AllChangeAware)manager).isAffectedByAny(allDeltas, candidateDescription, (IResourceDescriptions)newState) : (changedDeltas.isEmpty() ? false : manager.isAffected(changedDeltas, candidateDescription, (IResourceDescriptions)newState));
                if (affected) {
                    buildData.queueURI(candidateURI);
                    if (!"package.json".equals(candidateURI.lastSegment())) {
                        ResourceDescriptionWithoutModuleUserData noModuleData = new ResourceDescriptionWithoutModuleUserData(candidateDescription);
                        newState.register(manager.createDelta(candidateDescription, (IResourceDescription)noModuleData));
                        buildData.needRebuild();
                    }
                    iter.remove();
                }
            }
            progress.worked(1);
        }
    }

    protected IResourceDescription.Manager getResourceDescriptionManager(Resource resource, URI uri) {
        if (resource instanceof XtextResource) {
            return ((XtextResource)resource).getResourceServiceProvider().getResourceDescriptionManager();
        }
        return this.getResourceDescriptionManager(uri);
    }

    protected IResourceDescription.Manager getResourceDescriptionManager(URI uri) {
        IResourceServiceProvider resourceServiceProvider = this.managerRegistry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return null;
        }
        return resourceServiceProvider.getResourceDescriptionManager();
    }

    protected void updateMarkers(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor monitor) throws OperationCanceledException {
        super.updateMarkers(delta, resourceSet, monitor);
    }
}

