/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.transpiler.utils.ConcreteMembersOrderedForTranspiler;
import org.eclipse.n4js.transpiler.utils.ScriptApiTracker;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.util.AccessorTuple;
import org.eclipse.n4js.ts.types.util.MemberList;
import org.eclipse.n4js.utils.ContainerTypesHelper;

public class MissingApiMembersForTranspiler {
    public final MemberList<TMethod> missingApiMethods;
    public final List<AccessorTuple> missingApiAccessorTuples;

    public static MissingApiMembersForTranspiler create(ContainerTypesHelper containerTypesHelper, ScriptApiTracker apiTracker, TClassifier type, ConcreteMembersOrderedForTranspiler cmoft, Script context) {
        List<TMethod> c;
        ContainerTypesHelper.MemberCollector collector = containerTypesHelper.fromContext((EObject)context);
        MemberList missingApiMethods = new MemberList();
        if (type instanceof TClass) {
            c = apiTracker.computeMissingApiMethods((TClass)type, (EObject)context);
            missingApiMethods.addAll(c);
            List<ScriptApiTracker.VirtualApiTMethod> missingAPIfromInheritance = apiTracker.computeMethodDiff((TClass)type, collector, cmoft.ownedAndMixedInConcreteMembers, (MemberList<TMethod>)missingApiMethods);
            missingApiMethods.addAll(missingAPIfromInheritance);
        }
        if (type instanceof TInterface) {
            c = apiTracker.computeMissingApiMethods((TInterface)type, (EObject)context);
            missingApiMethods.addAll(c);
        }
        ArrayList<AccessorTuple> missingApiAccessorTuples = new ArrayList<AccessorTuple>();
        List<AccessorTuple> computedMissingApiGetterSetter = apiTracker.computeMissingApiGetterSetter((TN4Classifier)type, cmoft.concreteAccessorTuples);
        List<AccessorTuple> computedMissingApiFields = apiTracker.computeMissingApiFields((TN4Classifier)type);
        List<AccessorTuple> filteredMissingApiGetterSetter = MissingApiMembersForTranspiler.filterOutTuplesImplementedByField(computedMissingApiGetterSetter, cmoft.ownedAndMixedInConcreteMembers, cmoft.concreteInheritedMembers);
        List<AccessorTuple> filteredMissingApiFields0 = MissingApiMembersForTranspiler.filterMissingApiFieldsAndEnrichExistingTuples(computedMissingApiFields, cmoft.concreteAccessorTuples);
        List<AccessorTuple> filteredMissingApiFields = MissingApiMembersForTranspiler.filterMissingApiFieldsImplementedBySuperGetSet(filteredMissingApiFields0, cmoft.concreteInheritedMembers);
        missingApiAccessorTuples.addAll(filteredMissingApiGetterSetter);
        missingApiAccessorTuples.addAll(filteredMissingApiFields);
        MemberList<TField> fieldsOverridingAccessors = MissingApiMembersForTranspiler.getFieldsOverridingAccessor(cmoft.ownedAndMixedInConcreteMembers, cmoft.concreteInheritedMembers);
        MemberList fieldsPurelyMixedInNotOverridingAccessor = new MemberList();
        fieldsPurelyMixedInNotOverridingAccessor.addAll((Collection)cmoft.ownedAndMixedInConcreteMembers.stream().filter(it -> it instanceof TField && it.getContainingType() != type).map(it -> (TField)it).filter(it -> !fieldsOverridingAccessors.contains(it)).collect(Collectors.toList()));
        return new MissingApiMembersForTranspiler((MemberList<TMethod>)missingApiMethods, missingApiAccessorTuples);
    }

    private static List<AccessorTuple> filterMissingApiFieldsImplementedBySuperGetSet(List<AccessorTuple> missingApiFields, List<TMember> concreteInheritedMembers) {
        return missingApiFields.stream().filter(accTuple -> {
            boolean _static = accTuple.isStatic();
            String name = accTuple.getName();
            concreteInheritedMembers.stream().filter(member -> _static == member.isStatic() && (member.isGetter() || member.isSetter()) && name.equals(member.getName())).forEach(member -> {
                if (member.isGetter()) {
                    accTuple.replaceGetterByInheretedGetter_caseIncompletAPI((TGetter)member);
                } else {
                    accTuple.replaceSetterByInheretedSetter_caseIncompletAPI((TSetter)member);
                }
            });
            return accTuple.getGetter() != null || accTuple.getSetter() != null;
        }).collect(Collectors.toList());
    }

    private static List<AccessorTuple> filterMissingApiFieldsAndEnrichExistingTuples(List<AccessorTuple> computedMissingApiFields, List<AccessorTuple> concreteAccessorTuples) {
        return computedMissingApiFields.stream().filter(tuple -> {
            String name = tuple.getName();
            boolean isStatic = tuple.isStatic();
            Optional<AccessorTuple> concreteAccessor = concreteAccessorTuples.stream().filter(concreteTuple -> isStatic == concreteTuple.isStatic() && name.equals(concreteTuple.getName())).findFirst();
            if (concreteAccessor.isPresent()) {
                AccessorTuple ca = concreteAccessor.get();
                if (ca.hasPair()) {
                    return false;
                }
                if (ca.getInheritedGetter() != null || ca.getGetter() != null) {
                    ca.setSetter(tuple.getSetter());
                } else if (ca.getInheritedSetter() != null || ca.getSetter() != null) {
                    ca.setGetter(tuple.getGetter());
                }
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private static List<AccessorTuple> filterOutTuplesImplementedByField(List<AccessorTuple> computedMissingApiGetterSetter, List<TMember> ownedAndMixedInConcreteMember, List<TMember> concreteInheritedMembers) {
        return computedMissingApiGetterSetter.stream().filter(accessTuple -> {
            String name = accessTuple.getName();
            boolean _static = accessTuple.isStatic();
            return !Stream.concat(ownedAndMixedInConcreteMember.stream(), concreteInheritedMembers.stream()).filter(m -> m instanceof TField && _static == m.isStatic() && m.getName().equals(name)).findFirst().isPresent();
        }).collect(Collectors.toList());
    }

    private MissingApiMembersForTranspiler(MemberList<TMethod> missingApiMethods, List<AccessorTuple> missingApiAccessorTuples) {
        this.missingApiMethods = missingApiMethods;
        this.missingApiAccessorTuples = missingApiAccessorTuples;
    }

    private static MemberList<TField> getFieldsOverridingAccessor(Iterable<TMember> ownedAndMixedInConcreteMember, List<TMember> concreteInheritedMembers) {
        MemberList ownedAndMixedInFields = new MemberList();
        for (TMember m : ownedAndMixedInConcreteMember) {
            if (!(m instanceof TField) || !concreteInheritedMembers.stream().anyMatch(it -> (it.isGetter() || it.isSetter()) && it.getName().equals(m.getName()))) continue;
            ownedAndMixedInFields.add((Object)((TField)m));
        }
        return ownedAndMixedInFields;
    }
}

