/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.conversion.ValueConverterUtils;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.n4JS.AdditiveOperator;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ParameterizedAccess;
import org.eclipse.n4js.n4JS.PrimaryExpression;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.TemplateLiteral;
import org.eclipse.n4js.n4JS.TemplateSegment;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TransformationDependency;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@TransformationDependency.Optional(value={GeneratorOption.TemplateStringLiterals})
public class TemplateStringTransformation
extends Transformation {
    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<TemplateLiteral> _function = it -> this.transformTemplateLiteral((TemplateLiteral)it);
        this.collectNodes((EObject)this.getState().im, TemplateLiteral.class, true).forEach(_function);
    }

    private void transformTemplateLiteral(TemplateLiteral template) {
        ArrayList _newArrayList = Lists.newArrayList((Iterable)template.getSegments());
        for (Expression segment : _newArrayList) {
            if (!(segment instanceof TemplateSegment)) continue;
            this.replace(segment, (Expression)TranspilerBuilderBlocks._StringLiteral((String)((TemplateSegment)segment).getValueAsString(), (String)TemplateStringTransformation.wrapAndQuote(((TemplateSegment)segment).getValueAsString())));
        }
        StringLiteral _switchResult = null;
        int _size = template.getSegments().size();
        switch (_size) {
            case 0: {
                _switchResult = TranspilerBuilderBlocks._StringLiteral((String)"");
                break;
            }
            case 1: {
                _switchResult = (Expression)template.getSegments().get(0);
                break;
            }
            default: {
                _switchResult = TranspilerBuilderBlocks._Parenthesis((Expression)TranspilerBuilderBlocks._AdditiveExpression((AdditiveOperator)AdditiveOperator.ADD, (Expression[])((Expression[])Conversions.unwrapArray(TemplateStringTransformation.wrapIfRequired((Iterable<Expression>)template.getSegments()), Expression.class))));
            }
        }
        StringLiteral replacement = _switchResult;
        this.replace((Expression)template, (Expression)replacement);
    }

    private static Iterable<Expression> wrapIfRequired(Iterable<Expression> expressions) {
        List _list = IterableExtensions.toList(expressions);
        ArrayList copy = new ArrayList(_list);
        Functions.Function1 _function = expr -> {
            boolean needParentheses;
            boolean bl = needParentheses = !(expr instanceof PrimaryExpression) && !(expr instanceof ParameterizedAccess);
            if (needParentheses) {
                return TranspilerBuilderBlocks._Parenthesis((Expression)expr);
            }
            return expr;
        };
        return ListExtensions.map(copy, (Functions.Function1)_function);
    }

    private static String wrapAndQuote(String raw) {
        String _convertToEscapedString = ValueConverterUtils.convertToEscapedString((String)raw, (boolean)true);
        String _plus = "\"" + _convertToEscapedString;
        return String.valueOf(_plus) + "\"";
    }
}

