/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.hlc.base;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.utils.URIUtils;

public class HlcFileUtils {
    public static void isExistingWriteableDir(File file) {
        if (!file.exists()) {
            throw new RuntimeException("File " + file + " doesn't exist.");
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("File " + file + " is not a directory.");
        }
        if (!file.canWrite()) {
            throw new RuntimeException("File " + file + " is not writable.");
        }
    }

    public static void isExistingReadibleFile(File file) {
        if (!file.exists()) {
            throw new RuntimeException("File does not exist: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new RuntimeException("Not a file: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new RuntimeException("File is not readable: " + file.getAbsolutePath());
        }
    }

    public static URI fileToURI(File file) {
        return URIUtils.normalize((URI)URI.createURI((String)file.toURI().toString()));
    }
}

