/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries.nodejs;

import com.google.inject.Inject;
import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.n4js.binaries.nodejs.NodeBinariesConstants;
import org.eclipse.n4js.utils.ExecutableLookupUtil;
import org.eclipse.n4js.utils.process.OutputRedirection;
import org.eclipse.n4js.utils.process.ProcessExecutor;
import org.eclipse.n4js.utils.process.ProcessResult;

public class NodeBinaryLocatorHelper {
    private static final Logger LOGGER = Logger.getLogger(NodeBinaryLocatorHelper.class);
    private static final boolean LOG_SYSTEM_PROPERTIES = false;
    private static final boolean LOG_ENV_VARIABLES = false;
    private static final boolean LOG_TO_STD_OUT = false;
    @Inject
    private ProcessExecutor processExecutor;

    public String findNodePath() {
        NodeBinaryLocatorHelper.logSystemProperties();
        NodeBinaryLocatorHelper.logEnvironmentVariables();
        String nodePathCandidate = null;
        nodePathCandidate = NodeBinaryLocatorHelper.resolveFolderContaingNode(NodeBinaryLocatorHelper.tryGetEnvOrSystemVariable("org.eclipse.n4js.defaultNodePath"));
        if (!NodeBinaryLocatorHelper.isNullOrEmptyOrNullString(nodePathCandidate)) {
            NodeBinaryLocatorHelper.info("User specified default Node.js path will be used: '" + nodePathCandidate + ".' based on the '" + "org.eclipse.n4js.defaultNodePath" + "' VM argument.");
            return nodePathCandidate;
        }
        NodeBinaryLocatorHelper.debug("Could not resolve node path from 'org.eclipse.n4js.defaultNodePath' VM argument.");
        nodePathCandidate = NodeBinaryLocatorHelper.resolveFolderContaingNode(NodeBinaryLocatorHelper.tryGetEnvOrSystemVariable("NODEJS_PATH"));
        if (!NodeBinaryLocatorHelper.isNullOrEmptyOrNullString(nodePathCandidate)) {
            NodeBinaryLocatorHelper.info("User specified default Node.js path will be used: '" + nodePathCandidate + ".' based on the '" + "NODEJS_PATH" + "' VM argument.");
            return nodePathCandidate;
        }
        NodeBinaryLocatorHelper.debug("Could not resolve node path from 'NODEJS_PATH' VM argument.");
        nodePathCandidate = NodeBinaryLocatorHelper.resolveFolderContaingNode(ExecutableLookupUtil.findInPath((String)NodeBinariesConstants.NODE_BINARY_NAME));
        if (!NodeBinaryLocatorHelper.isNullOrEmptyOrNullString(nodePathCandidate)) {
            NodeBinaryLocatorHelper.info("Obtained default Node.js path will be used: '" + nodePathCandidate + ".' based on the OS PATH.");
            return nodePathCandidate;
        }
        NodeBinaryLocatorHelper.debug("Could not resolve node path from OS PATH variable.");
        nodePathCandidate = NodeBinaryLocatorHelper.resolveFolderContaingNode(this.lookForNode(NodeBinariesConstants.NODE_BINARY_NAME));
        if (!NodeBinaryLocatorHelper.isNullOrEmptyOrNullString(nodePathCandidate)) {
            NodeBinaryLocatorHelper.info("Obtained default Node.js path will be used: '" + nodePathCandidate + ".' based on the OS dynamic lookup.");
            return nodePathCandidate;
        }
        NodeBinaryLocatorHelper.debug("Could not resolve node path from OS dynamic lookup.");
        NodeBinaryLocatorHelper.info("Could not resolve node path. Falling back to default path: " + nodePathCandidate);
        nodePathCandidate = NodeBinariesConstants.BUILT_IN_DEFAULT_NODE_PATH;
        return nodePathCandidate;
    }

    private String lookForNode(String binaryName) {
        ProcessResult processResult = this.processExecutor.createAndExecute(ExecutableLookupUtil.getExebutableLookupProcessBuilder((String)binaryName), "look for " + binaryName, OutputRedirection.SUPPRESS);
        return processResult.getStdOut().trim();
    }

    private static String tryGetEnvOrSystemVariable(String propertyName) {
        String nodeJsPath = System.getenv(propertyName);
        if (NodeBinaryLocatorHelper.isNullOrEmptyOrNullString(nodeJsPath)) {
            return System.getProperty(propertyName);
        }
        return nodeJsPath;
    }

    private static String resolveFolderContaingNode(String nodePathCandidate) {
        if (NodeBinaryLocatorHelper.isNullOrEmptyOrNullString(nodePathCandidate)) {
            NodeBinaryLocatorHelper.debug("provided potential node directory path was null");
            return null;
        }
        File nodeDir = new File(nodePathCandidate);
        return NodeBinaryLocatorHelper.resolveNodeFolderPath(nodeDir);
    }

    private static String resolveNodeFolderPath(File nodeDir) {
        if (nodeDir.isFile()) {
            NodeBinaryLocatorHelper.debug("provided potential node directory is actually a file, obtaining parent");
            nodeDir = nodeDir.getParentFile();
        } else {
            if (!nodeDir.exists()) {
                NodeBinaryLocatorHelper.debug("cannot obtain file system object from provided string");
                return null;
            }
            if (!nodeDir.isDirectory()) {
                NodeBinaryLocatorHelper.debug("could not safely resolve node directory");
                return null;
            }
        }
        return nodeDir.getAbsolutePath();
    }

    private static boolean isNullOrEmptyOrNullString(String s) {
        return s == null || s.trim().length() == 0 || "null".equals(s);
    }

    private static void logSystemProperties() {
    }

    private static void logEnvironmentVariables() {
    }

    private static void info(Object message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info(message);
        }
    }

    private static void debug(Object message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(message);
        }
    }
}

