/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.scoping;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.xtext.resource.IEObjectDescription;

public class TypesScopeFilter {
    public Predicate<? super IEObjectDescription> getTypesFilterCriteria(EObject context, EReference reference) {
        Predicate<? super IEObjectDescription> _switchResult = null;
        boolean _matched = false;
        if (context instanceof TypeRef) {
            _matched = true;
            _switchResult = this.getTypesFilterCriteria((TypeRef)context, reference);
        }
        if (!_matched) {
            _switchResult = this.getTypeReferenceFilterCriteria(context, reference);
        }
        return _switchResult;
    }

    protected Predicate<? super IEObjectDescription> getTypesFilterCriteria(TypeRef context, EReference reference) {
        boolean _tripleEquals;
        EReference _parameterizedTypeRef_AstNamespace = TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_AstNamespace();
        boolean bl = _tripleEquals = reference == _parameterizedTypeRef_AstNamespace;
        if (_tripleEquals) {
            return this.getNamespaceCriterion();
        }
        TypeRef container = context;
        EReference containmentFeature = null;
        while (container instanceof TypeRef) {
            EStructuralFeature _eContainingFeature = container.eContainingFeature();
            containmentFeature = (EReference)_eContainingFeature;
            container = container.eContainer();
        }
        return this.getTypeReferenceFilterCriteria((EObject)container, containmentFeature);
    }

    protected Predicate<? super IEObjectDescription> getTypeReferenceFilterCriteria(EObject container, EReference containmentFeature) {
        Predicate<? super IEObjectDescription> _switchResult = null;
        boolean _matched = false;
        if (container instanceof TClass) {
            _matched = true;
            _switchResult = this.getInheritanceFilterCriteria(containmentFeature);
        }
        if (!_matched && container instanceof TypeVariable) {
            _matched = true;
            _switchResult = this.getTypeVariableBoundCriteria();
        }
        if (!_matched && container instanceof TField) {
            _matched = true;
            _switchResult = this.getFieldTypeCriteria();
        }
        if (!_matched && container instanceof TMethod) {
            _matched = true;
            _switchResult = this.getReturnTypeCriteria();
        }
        if (!_matched && container instanceof TFormalParameter) {
            _matched = true;
            _switchResult = this.getParameterTypeCriteria();
        }
        if (!_matched && container instanceof TFunction) {
            _matched = true;
            _switchResult = this.getReturnTypeCriteria();
        }
        if (!_matched) {
            _switchResult = Predicates.alwaysTrue();
        }
        return _switchResult;
    }

    protected Predicate<? super IEObjectDescription> getNamespaceCriterion() {
        Predicate _function = it -> TypesPackage.Literals.MODULE_NAMESPACE_VIRTUAL_TYPE.isSuperTypeOf(it.getEClass());
        return _function;
    }

    protected Predicate<? super IEObjectDescription> getParameterTypeCriteria() {
        Predicate _function = it -> !TypesPackage.Literals.TFUNCTION.isSuperTypeOf(it.getEClass()) && !Objects.equal((Object)TypesPackage.Literals.UNDEFINED_TYPE, (Object)it.getEClass()) && !Objects.equal((Object)TypesPackage.Literals.NULL_TYPE, (Object)it.getEClass()) && !Objects.equal((Object)TypesPackage.Literals.VOID_TYPE, (Object)it.getEClass());
        return _function;
    }

    protected Predicate<? super IEObjectDescription> getReturnTypeCriteria() {
        Predicate _function = it -> !TypesPackage.Literals.TFUNCTION.isSuperTypeOf(it.getEClass()) && !Objects.equal((Object)TypesPackage.Literals.UNDEFINED_TYPE, (Object)it.getEClass()) && !Objects.equal((Object)TypesPackage.Literals.NULL_TYPE, (Object)it.getEClass());
        return _function;
    }

    protected Predicate<? super IEObjectDescription> getFieldTypeCriteria() {
        Predicate _function = it -> !TypesPackage.Literals.TFUNCTION.isSuperTypeOf(it.getEClass()) && !Objects.equal((Object)TypesPackage.Literals.UNDEFINED_TYPE, (Object)it.getEClass()) && !Objects.equal((Object)TypesPackage.Literals.NULL_TYPE, (Object)it.getEClass()) && !Objects.equal((Object)TypesPackage.Literals.VOID_TYPE, (Object)it.getEClass());
        return _function;
    }

    protected Predicate<? super IEObjectDescription> getTypeVariableBoundCriteria() {
        Predicate _function = it -> TypesPackage.Literals.TCLASSIFIER.isSuperTypeOf(it.getEClass());
        return _function;
    }

    protected Predicate<? super IEObjectDescription> getInheritanceFilterCriteria(EReference reference) {
        Predicate _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)reference, (Object)TypesPackage.Literals.TCLASS__SUPER_CLASS_REF)) {
            Predicate _function;
            _matched = true;
            _switchResult = _function = it -> TypesPackage.Literals.TCLASS.isSuperTypeOf(it.getEClass());
        }
        if (!_matched && Objects.equal((Object)reference, (Object)TypesPackage.Literals.TCLASS__IMPLEMENTED_INTERFACE_REFS)) {
            Predicate _function_1;
            _matched = true;
            _switchResult = _function_1 = it -> TypesPackage.Literals.TINTERFACE.isSuperTypeOf(it.getEClass());
        }
        return _switchResult;
    }
}

