/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.formatting2;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.formatting2.InsertSemi;
import org.eclipse.n4js.formatting2.N4JSFormatterPreferenceKeys;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionExtensions;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@FinalFieldsConstructor
public class N4JSGenericFormatter {
    @Extension
    private final N4JSGrammarAccess _n4JSGrammarAccess;
    @Extension
    private final ITextRegionExtensions _iTextRegionExtensions;
    public static final int PRIO_1 = -10;
    public static final int PRIO_2 = -9;
    public static final int PRIO_3 = -8;

    public void formatColon(EObject semanticElement, @Extension IFormattableDocument document) {
        List _keywords = this._iTextRegionExtensions.allRegionsFor(semanticElement).keywords(new String[]{":"});
        for (ISemanticRegion colon : _keywords) {
            Procedures.Procedure1 _function = it -> {
                it.noSpace();
                it.setNewLines(0);
                it.setPriority(-8);
            };
            Procedures.Procedure1 _function_1 = it -> {
                it.oneSpace();
                it.setPriority(-9);
            };
            document.append(document.prepend(colon, _function), _function_1);
        }
    }

    public void formatSemicolons(EObject script, @Extension IFormattableDocument document) {
        List _ruleCallsTo = this._iTextRegionExtensions.allRegionsFor(script).ruleCallsTo(new AbstractRule[]{this._n4JSGrammarAccess.getSemiRule()});
        for (ISemanticRegion region : _ruleCallsTo) {
            boolean _isMultiline;
            boolean _not;
            boolean _equals_1;
            String text = region.getText();
            IHiddenRegion previous = region.getPreviousHiddenRegion();
            boolean _equals = Objects.equal((Object)text, (Object)";");
            if (_equals) {
                Procedures.Procedure1 _function = it -> {
                    it.noSpace();
                    it.setNewLines(0);
                    it.highPriority();
                };
                document.prepend(region, _function);
                continue;
            }
            boolean _and = false;
            ISemanticRegion _nextSemanticRegion = region.getNextSemanticRegion();
            String _text = null;
            if (_nextSemanticRegion != null) {
                _text = _nextSemanticRegion.getText();
            }
            if (_and = !(_equals_1 = Objects.equal((Object)_text, (Object)"}")) ? false : (_not = !(_isMultiline = region.isMultiline()))) continue;
            boolean _containsComment = previous.containsComment();
            if (_containsComment) {
                ITextSegment insertAt = region.getTextRegionAccess().regionForOffset(previous.getOffset(), 0);
                InsertSemi _insertSemi = new InsertSemi(insertAt, ";");
                document.addReplacer((ITextReplacer)_insertSemi);
                continue;
            }
            boolean _isEmpty = text.trim().isEmpty();
            if (_isEmpty) {
                int lbIdx = text.indexOf("\n");
                if (lbIdx >= 0) {
                    ITextSegment replaceRegion = region.getTextRegionAccess().regionForOffset(region.getOffset(), lbIdx + 1);
                    InsertSemi _insertSemi_1 = new InsertSemi(replaceRegion, ";\n");
                    document.addReplacer((ITextReplacer)_insertSemi_1);
                    continue;
                }
                InsertSemi _insertSemi_2 = new InsertSemi((ITextSegment)region, ";");
                document.addReplacer((ITextReplacer)_insertSemi_2);
                continue;
            }
            ITextSegment insertAt_1 = region.getTextRegionAccess().regionForOffset(region.getOffset(), 0);
            InsertSemi _insertSemi_3 = new InsertSemi(insertAt_1, ";");
            document.addReplacer((ITextReplacer)_insertSemi_3);
        }
    }

    public void formatParenthesisBracketsAndBraces(EObject script, @Extension IFormattableDocument document) {
        ArrayList all = CollectionLiterals.newArrayList();
        List _keywordPairs = this._iTextRegionExtensions.allRegionsFor(script).keywordPairs("(", ")");
        Iterables.addAll((Collection)all, (Iterable)_keywordPairs);
        List _keywordPairs_1 = this._iTextRegionExtensions.allRegionsFor(script).keywordPairs("{", "}");
        Iterables.addAll((Collection)all, (Iterable)_keywordPairs_1);
        List _keywordPairs_2 = this._iTextRegionExtensions.allRegionsFor(script).keywordPairs("[", "]");
        Iterables.addAll((Collection)all, (Iterable)_keywordPairs_2);
        Functions.Function1 _function = it -> ((ILineRegion)IterableExtensions.head((Iterable)((ISemanticRegion)it.getKey()).getLineRegions())).getOffset();
        Map byLine = IterableExtensions.groupBy((Iterable)all, (Functions.Function1)_function);
        Set _entrySet = byLine.entrySet();
        for (Map.Entry e : _entrySet) {
            Functions.Function1 _function_1 = it -> ((ISemanticRegion)it.getKey()).getOffset();
            List bracePairsInSameLine = IterableExtensions.sortBy((Iterable)((Iterable)e.getValue()), (Functions.Function1)_function_1);
            Pair outermost = (Pair)IterableExtensions.head((Iterable)bracePairsInSameLine);
            Pair innermost = (Pair)IterableExtensions.last((Iterable)bracePairsInSameLine);
            IHiddenRegion lastOpen = null;
            IHiddenRegion lastClose = null;
            for (Pair pair : bracePairsInSameLine) {
                IHiddenRegion _nextHiddenRegion;
                boolean _notEquals;
                ISemanticRegion open = (ISemanticRegion)pair.getKey();
                ISemanticRegion close = (ISemanticRegion)pair.getValue();
                if (!Objects.equal((Object)open.getPreviousHiddenRegion(), lastOpen) && lastOpen != null) {
                    Procedures.Procedure1 _function_2 = it -> {
                        it.noSpace();
                        it.setPriority(-10);
                    };
                    document.prepend(open, _function_2);
                }
                if (pair != innermost) {
                    Procedures.Procedure1 _function_3 = it -> {
                        it.noSpace();
                        it.setPriority(-10);
                    };
                    document.append(open, _function_3);
                    Procedures.Procedure1 _function_4 = it -> {
                        it.noSpace();
                        it.setPriority(-10);
                    };
                    document.prepend(close, _function_4);
                }
                boolean bl = _notEquals = !Objects.equal((Object)(_nextHiddenRegion = close.getNextHiddenRegion()), lastClose);
                if (_notEquals && pair != outermost) {
                    Procedures.Procedure1 _function_5 = it -> {
                        it.noSpace();
                        it.setPriority(-10);
                    };
                    document.append(close, _function_5);
                }
                lastOpen = open.getNextHiddenRegion();
                lastClose = close.getPreviousHiddenRegion();
            }
            ISemanticRegion open = (ISemanticRegion)innermost.getKey();
            ISemanticRegion close = (ISemanticRegion)innermost.getValue();
            if (Objects.equal((Object)open.getNextSemanticRegion(), (Object)close) && !open.getNextHiddenRegion().isMultiline()) {
                Procedures.Procedure1 _function_2 = it -> {
                    it.noSpace();
                    it.setPriority(-10);
                };
                document.append(open, _function_2);
                continue;
            }
            boolean _isMultiline = close.getPreviousHiddenRegion().isMultiline();
            if (_isMultiline) {
                Procedures.Procedure1 _function_3 = it -> {
                    it.newLine();
                    it.setPriority(-10);
                };
                this.appendNewLine(document.prepend(close, _function_3), document);
                Procedures.Procedure1 _function_4 = it -> {
                    it.newLine();
                    it.setPriority(-10);
                };
                document.append(open, _function_4);
                Procedures.Procedure1 _function_5 = it -> it.indent();
                document.interior(innermost, _function_5);
                List _keywords = this._iTextRegionExtensions.regionFor(open.getSemanticElement()).keywords(new String[]{","});
                for (ISemanticRegion comma : _keywords) {
                    Procedures.Procedure1 _function_6 = it -> {
                        it.noSpace();
                        it.setPriority(-10);
                    };
                    Procedures.Procedure1 _function_7 = it -> {
                        it.setNewLines(1, 1, 2);
                        it.setPriority(-9);
                    };
                    document.append(document.prepend(comma, _function_6), _function_7);
                }
                continue;
            }
            Boolean _preference = (Boolean)document.getRequest().getPreferences().getPreference((TypedPreferenceKey)N4JSFormatterPreferenceKeys.FORMAT_SURROUND_PAREN_CONTENT_WITH_SPACE);
            if (_preference.booleanValue()) {
                Procedures.Procedure1 _function_8 = it -> {
                    it.oneSpace();
                    it.setPriority(-10);
                };
                document.prepend(close, _function_8);
                Procedures.Procedure1 _function_9 = it -> {
                    it.oneSpace();
                    it.setPriority(-10);
                };
                document.append(open, _function_9);
            }
            List _keywords_1 = this._iTextRegionExtensions.regionFor(open.getSemanticElement()).keywords(new String[]{","});
            for (ISemanticRegion comma_1 : _keywords_1) {
                Procedures.Procedure1 _function_10 = it -> {
                    it.noSpace();
                    it.setPriority(-10);
                };
                Procedures.Procedure1 _function_11 = it -> {
                    it.oneSpace();
                    it.setPriority(-10);
                };
                document.append(document.prepend(comma_1, _function_10), _function_11);
            }
        }
    }

    public ISemanticRegion appendNewLine(ISemanticRegion appendAfter, @Extension IFormattableDocument doc) {
        ISemanticRegion _nextSemanticRegion = appendAfter.getNextSemanticRegion();
        EObject _grammarElement = null;
        if (_nextSemanticRegion != null) {
            _grammarElement = _nextSemanticRegion.getGrammarElement();
        }
        EObject semi = _grammarElement;
        boolean _and = false;
        if (!(semi instanceof RuleCall)) {
            _and = false;
        } else {
            boolean _equals;
            AbstractRule _rule = null;
            if ((RuleCall)semi != null) {
                _rule = ((RuleCall)semi).getRule();
            }
            ParserRule _semiRule = this._n4JSGrammarAccess.getSemiRule();
            _and = _equals = Objects.equal((Object)_rule, (Object)_semiRule);
        }
        if (!_and) {
            Procedures.Procedure1 _function = it -> {
                it.newLine();
                it.setPriority(-10);
            };
            doc.append(appendAfter, _function);
        }
        return appendAfter;
    }

    public N4JSGenericFormatter(N4JSGrammarAccess _n4JSGrammarAccess, ITextRegionExtensions _iTextRegionExtensions) {
        this._n4JSGrammarAccess = _n4JSGrammarAccess;
        this._iTextRegionExtensions = _iTextRegionExtensions;
    }
}

