/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.accessModifiers;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.resource.N4JSResourceDescriptionStrategy;
import org.eclipse.n4js.scoping.accessModifiers.AbstractVisibilityChecker;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TypeAccessModifier;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Strings;

public abstract class AbstractTypeVisibilityChecker<T extends IdentifiableElement>
implements AbstractVisibilityChecker<T> {
    @Inject
    protected IN4JSCore core;

    @Override
    public TypeVisibility isVisible(Resource contextResource, IEObjectDescription e) {
        TypeAccessModifier typeAccessModifier = N4JSResourceDescriptionStrategy.getTypeAccessModifier(e);
        return this.isVisible(contextResource, typeAccessModifier, e);
    }

    protected TypeVisibility isVisible(Resource contextResource, TypeAccessModifier accessModifier, T element) {
        int startIndex = accessModifier.getValue();
        boolean visibility = false;
        String firstVisible = "PUBLIC";
        int i = startIndex;
        while (i < TypeAccessModifier.values().length) {
            boolean visibilityForModifier = false;
            TypeAccessModifier modifier = TypeAccessModifier.get((int)i);
            switch (modifier) {
                case PRIVATE: {
                    visibilityForModifier = this.isPrivateVisible(contextResource, element);
                    break;
                }
                case PROJECT: {
                    visibilityForModifier = this.isProjectVisible(contextResource, element);
                    break;
                }
                case PUBLIC_INTERNAL: {
                    visibilityForModifier = this.isPublicInternalVisible(contextResource, element);
                    break;
                }
                case PUBLIC: {
                    visibilityForModifier = true;
                    break;
                }
                default: {
                    visibilityForModifier = false;
                }
            }
            if (i - startIndex < 1) {
                visibility = visibilityForModifier;
            }
            if (visibilityForModifier) {
                firstVisible = modifier.getName().toUpperCase();
                break;
            }
            ++i;
        }
        return new TypeVisibility(visibility, firstVisible);
    }

    protected TypeVisibility isVisible(Resource contextResource, TypeAccessModifier accessModifier, IEObjectDescription element) {
        int startIndex = accessModifier.getValue();
        boolean visibility = false;
        String firstVisible = "PUBLIC";
        int i = startIndex;
        while (i < TypeAccessModifier.values().length) {
            boolean visibilityForModifier = false;
            TypeAccessModifier modifier = TypeAccessModifier.get((int)i);
            switch (modifier) {
                case PRIVATE: {
                    visibilityForModifier = this.isPrivateVisible(contextResource, element);
                    break;
                }
                case PROJECT: {
                    visibilityForModifier = this.isProjectVisible(contextResource, element);
                    break;
                }
                case PUBLIC_INTERNAL: {
                    visibilityForModifier = this.isPublicInternalVisible(contextResource, element);
                    break;
                }
                case PUBLIC: {
                    visibilityForModifier = true;
                    break;
                }
                default: {
                    visibilityForModifier = false;
                }
            }
            if (i - startIndex < 1) {
                visibility = visibilityForModifier;
            }
            if (visibilityForModifier) {
                firstVisible = modifier.getName().toUpperCase();
                break;
            }
            ++i;
        }
        return new TypeVisibility(visibility, firstVisible);
    }

    private boolean isPublicInternalVisible(Resource contextResource, T element) {
        if (contextResource != null) {
            TModule contextModule = N4JSResource.getModule(contextResource);
            TModule elementModule = N4JSResource.getModule(element.eResource());
            return elementModule == null || Strings.equal((String)contextModule.getVendorID(), (String)elementModule.getVendorID());
        }
        return false;
    }

    private boolean isPublicInternalVisible(Resource contextResource, IEObjectDescription element) {
        TModule contextModule;
        if (contextResource != null && (contextModule = N4JSResource.getModule(contextResource)) != null) {
            return (Boolean)this.core.findProject(element.getEObjectURI()).transform(project -> {
                boolean result = Strings.equal((String)contextModule.getVendorID(), (String)project.getVendorID());
                return result;
            }).or((Object)true);
        }
        return false;
    }

    private boolean isPrivateVisible(Resource contextResource, T element) {
        return element.eResource() == contextResource;
    }

    private boolean isPrivateVisible(Resource contextResource, IEObjectDescription element) {
        return contextResource == null || element.getEObjectURI().trimFragment().equals(contextResource.getURI());
    }

    private boolean isProjectVisible(Resource contextResource, T element) {
        TModule contextModule;
        if (contextResource != null && (contextModule = N4JSResource.getModule(contextResource)) != null) {
            TModule elementModule = N4JSResource.getModule(element.eResource());
            return elementModule == null || elementModule == contextModule || Strings.equal((String)contextModule.getProjectName(), (String)elementModule.getProjectName()) && Strings.equal((String)contextModule.getVendorID(), (String)elementModule.getVendorID()) || this.isTestedProjectOf(contextModule, elementModule);
        }
        return false;
    }

    private boolean isProjectVisible(Resource contextResource, IEObjectDescription element) {
        if (contextResource != null) {
            TModule contextModule = N4JSResource.getModule(contextResource);
            if (contextModule == null) {
                return false;
            }
            return (Boolean)this.core.findProject(element.getEObjectURI()).transform(project -> {
                boolean result = Strings.equal((String)contextModule.getProjectName(), (String)project.getProjectName()) && Strings.equal((String)contextModule.getVendorID(), (String)project.getVendorID()) || this.isTestedProjectOf(contextModule, (IN4JSProject)project);
                return result;
            }).or((Object)true);
        }
        return false;
    }

    public boolean isTestedProjectOf(TModule contextModule, TModule elementModule) {
        if (elementModule == null || contextModule == null || elementModule.eResource() == null || contextModule.eResource() == null) {
            return false;
        }
        for (IN4JSProject testedProject : this.getTestedProjects(contextModule.eResource().getURI())) {
            URI resourceUri;
            IN4JSProject elementProject;
            Resource eResource;
            URI testProjectLocation = testedProject.getLocation();
            if (testProjectLocation == null || (eResource = elementModule.eResource()) == null || (elementProject = (IN4JSProject)this.core.findProject(resourceUri = eResource.getURI()).orNull()) == null || !Strings.emptyIfNull((String)elementProject.getProjectName()).equals(testedProject.getProjectName())) continue;
            return true;
        }
        return false;
    }

    public boolean isTestedProjectOf(TModule contextModule, IN4JSProject elementProject) {
        for (IN4JSProject testedProject : this.getTestedProjects(contextModule.eResource().getURI())) {
            if (!Strings.emptyIfNull((String)elementProject.getProjectName()).equals(testedProject.getProjectName())) continue;
            return true;
        }
        return false;
    }

    public Collection<IN4JSProject> getTestedProjects(URI contextResourceUri) {
        if (contextResourceUri == null) {
            return Collections.emptyList();
        }
        IN4JSProject contextProject = (IN4JSProject)this.core.findProject(contextResourceUri).orNull();
        if (contextProject == null || !contextProject.exists()) {
            return Collections.emptyList();
        }
        return contextProject.getTestedProjects();
    }

    public static class TypeVisibility {
        public final boolean visibility;
        public final String accessModifierSuggestion;

        public TypeVisibility(boolean visibility) {
            this(visibility, null);
        }

        public TypeVisibility(boolean visibility, String suggestion) {
            this.visibility = visibility;
            this.accessModifierSuggestion = suggestion;
        }
    }
}

