/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.handler;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.n4js.ui.dialog.TypeInformationPopup;
import org.eclipse.n4js.ui.labeling.N4JSTypeInformationHoverProvider;
import org.eclipse.n4js.ui.selection.AstSelectionProvider2;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlInput;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Extension;

public class ShowTypeInformationHandler
extends AbstractHandler {
    @Inject
    @Extension
    private N4JSTypeInformationHoverProvider _n4JSTypeInformationHoverProvider;
    @Inject
    @Extension
    private AstSelectionProvider2 _astSelectionProvider2;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
        if (editor != null) {
            ISelection _selection = editor.getSelectionProvider().getSelection();
            ITextSelection selection = (ITextSelection)_selection;
            EObject node = this.getNodeElementFromSelection(editor.getDocument(), selection);
            if (node != null) {
                int _offset = selection.getOffset();
                int _length = selection.getLength();
                Region region = new Region(_offset, _length);
                Object _info = this._n4JSTypeInformationHoverProvider.getHoverInfo(node, (ITextViewer)editor.getInternalSourceViewer(), (IRegion)region).getInfo();
                XtextBrowserInformationControlInput info = (XtextBrowserInformationControlInput)_info;
                if (info != null) {
                    this.raiseTypeInformationPopup(event, info.getHtml());
                }
            }
        }
        return null;
    }

    private EObject getNodeElementFromSelection(IXtextDocument document, ITextSelection selection) {
        int _offset = selection.getOffset();
        int _length = selection.getLength();
        TextRegion _textRegion = new TextRegion(_offset, _length);
        return this._astSelectionProvider2.getSelectedAstElement(document, (ITextRegion)_textRegion);
    }

    private int raiseTypeInformationPopup(ExecutionEvent event, String html) {
        Shell _activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Point _popupAnchor = this.getPopupAnchor(event);
        return new TypeInformationPopup(_activeShell, _popupAnchor, html).open();
    }

    private Point getPopupAnchor(ExecutionEvent event) {
        StyledText textWidget = this.getStyledText(event);
        if (textWidget == null) {
            return null;
        }
        Point docRange = textWidget.getSelectionRange();
        int midOffset = docRange.x + docRange.y / 2;
        Point point = textWidget.getLocationAtOffset(midOffset);
        point = textWidget.toDisplay(point);
        GC gc = new GC((Drawable)textWidget);
        gc.setFont(textWidget.getFont());
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        int _y = point.y;
        point.y = _y + height;
        return point;
    }

    private StyledText getStyledText(ExecutionEvent event) {
        IWorkbenchPart part = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getActivePart();
        ITextViewer viewer = (ITextViewer)part.getAdapter(ITextViewer.class);
        if (viewer == null) {
            Control control = (Control)part.getAdapter(Control.class);
            if (control instanceof StyledText) {
                return (StyledText)control;
            }
        } else {
            return viewer.getTextWidget();
        }
        return null;
    }
}

