/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.editor;

import com.google.inject.Injector;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.registry.ILanguageInfo;
import org.eclipse.xpect.ui.XpectPluginActivator;
import org.eclipse.xpect.ui.util.XpectUtil;
import org.eclipse.xpect.util.IXtInjectorProvider;
import org.eclipse.xpect.util.ReflectionUtil;
import org.eclipse.xpect.util.URIDelegationHandler;
import org.eclipse.xtext.ui.guice.AbstractGuiceAwareExecutableExtensionFactory;
import org.osgi.framework.Bundle;

public class XtEditorExecutableExtensionFactory
extends AbstractGuiceAwareExecutableExtensionFactory {
    protected Bundle getBundle() {
        return XpectPluginActivator.getInstance().getBundle();
    }

    protected Injector getInjector() {
        IFile file = this.getFileOfCurrentlyOpeningEditor();
        if (file == null) {
            throw new RuntimeException("Could not determine which editor is currently being opened.");
        }
        String ext = new URIDelegationHandler().getOriginalFileExtension(file.getName());
        ILanguageInfo info = ILanguageInfo.Registry.INSTANCE.getLanguageByFileExtension(ext);
        if (info == null) {
            throw new RuntimeException("There is no Xtext-language installed for file extension '" + ext + "'.");
        }
        XpectJavaModel javaModel = XpectUtil.loadJavaModel(file);
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        if (uri == null) {
            throw new RuntimeException("Could not determine URI for IFile " + file.getFullPath().toString());
        }
        return IXtInjectorProvider.INSTANCE.getInjector(javaModel, uri);
    }

    protected IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            return page;
        }
        Object perspectiveSwitcher = ReflectionUtil.readField((Object)window, (String)"perspectiveSwitcher", Object.class);
        if (perspectiveSwitcher == null) {
            return null;
        }
        Object reorderListener = ReflectionUtil.readField((Object)perspectiveSwitcher, (String)"reorderListener", Object.class);
        if (reorderListener == null) {
            return null;
        }
        Object parent = ReflectionUtil.getParentObject((Object)reorderListener);
        if (parent instanceof IWorkbenchPage) {
            return (IWorkbenchPage)parent;
        }
        return null;
    }

    protected IFile getFileOfCurrentlyOpeningEditor() {
        try {
            IWorkbenchPage page = this.getActiveWorkbenchPage();
            if (page != null) {
                IEditorReference[] references = page.getEditorReferences();
                int i = references.length - 1;
                while (i >= 0) {
                    IEditorInput input;
                    if (references[i].getId().equals("org.eclipse.xpect.Xt") && references[i].getPart(false) == null && (input = references[i].getEditorInput()) instanceof IFileEditorInput) {
                        return ((IFileEditorInput)input).getFile();
                    }
                    --i;
                }
            }
            return null;
        }
        catch (PartInitException partInitException) {
            throw new RuntimeException();
        }
    }
}

