/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.registry;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xpect.registry.AbstractLanguageInfo;
import org.eclipse.xpect.registry.IEmfFileExtensionInfo;
import org.eclipse.xpect.registry.ILanguageInfo;
import org.eclipse.xpect.util.ReflectionUtil;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.Modules2;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class UILanugageRegistry
implements ILanguageInfo.Registry {
    private static final Logger LOG = Logger.getLogger(UILanugageRegistry.class);
    protected Map<String, ILanguageInfo> fileExtension2language = Maps.newLinkedHashMap();
    protected Map<String, ILanguageInfo> name2language = Maps.newLinkedHashMap();

    public UILanugageRegistry() {
        try {
            this.init();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error initalizing language registry", e);
        }
    }

    private void init() {
        for (IEmfFileExtensionInfo info : IEmfFileExtensionInfo.Registry.INSTANCE.getFileExtensionInfos()) {
            if (!(info instanceof IEmfFileExtensionInfo.IXtextFileExtensionInfo)) continue;
            UILanguageInfo infoImpl = new UILanguageInfo((IEmfFileExtensionInfo.IXtextFileExtensionInfo)info);
            this.name2language.put(infoImpl.getLanguageName(), (ILanguageInfo)infoImpl);
            for (String ext : info.getFileExtensions()) {
                this.fileExtension2language.put(ext, (ILanguageInfo)infoImpl);
            }
        }
    }

    public ILanguageInfo getLanguageByFileExtension(String fileExtension) {
        return this.fileExtension2language.get(fileExtension);
    }

    public ILanguageInfo getLanguageByName(String name) {
        return this.name2language.get(name);
    }

    public Collection<ILanguageInfo> getLanguages() {
        return this.name2language.values();
    }

    public static class UILanguageInfo
    extends AbstractLanguageInfo {
        public UILanguageInfo(IEmfFileExtensionInfo.IXtextFileExtensionInfo info) {
            super(info);
        }

        protected Injector createInjector(Module ... modules) {
            if (modules.length == 0) {
                URI uri = URI.createURI((String)("*." + (String)this.getFileExtensions().iterator().next()));
                IResourceServiceProvider provider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri);
                if (provider == null) {
                    String msg = "Could not find " + IResourceServiceProvider.class.getSimpleName() + " for " + uri;
                    throw new IllegalStateException(String.valueOf(msg) + "\nRegistry:\n" + IEmfFileExtensionInfo.Registry.INSTANCE);
                }
                return (Injector)provider.get(Injector.class);
            }
            Module runtimeModule = this.getRuntimeModule();
            Module sharedStateModule = this.getSharedStateModule();
            Module uiModule = this.getUIModule();
            Module override = Modules2.mixin((Module[])modules);
            return Guice.createInjector((Module[])new Module[]{Modules2.mixin((Module[])new Module[]{runtimeModule, sharedStateModule, uiModule, override})});
        }

        protected Module getUIModule() {
            if (this.uiModule == null) {
                try {
                    Class uiModuleClass = this.getUIModuleClass();
                    Bundle bundle = FrameworkUtil.getBundle((Class)uiModuleClass);
                    BundleContext context = bundle.getBundleContext();
                    Plugin plugin = (Plugin)ReflectionUtil.readField(context.getClass(), (Object)context, (String)"activator", Plugin.class);
                    if (plugin == null) {
                        throw new IllegalStateException("Could not access Activator of bundle '" + bundle.getBundleId() + "'. ");
                    }
                    Constructor constructor = uiModuleClass.getConstructor(AbstractUIPlugin.class);
                    this.uiModule = (Module)constructor.newInstance(plugin);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.uiModule;
        }
    }
}

