/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.ui;

import java.util.Set;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.ui.SpecChangeSetProvider;
import org.eclipse.n4js.jsdoc2spec.ui.SpecExportCodeSummaryPage;
import org.eclipse.n4js.jsdoc2spec.ui.SpecPage;

public class SummaryPageVisibilityListener
implements SpecPage.VisibilityChangedListener {
    final SpecChangeSetProvider csp;
    final SpecExportCodeSummaryPage summaryPage;

    public SummaryPageVisibilityListener(SpecChangeSetProvider csp, SpecExportCodeSummaryPage summaryPage) {
        this.csp = csp;
        this.summaryPage = summaryPage;
    }

    @Override
    public void isVisibleChanged(boolean visible) {
        if (visible) {
            Set<SpecFile> specChangeSet = this.csp.getSpecChangeSet();
            if (specChangeSet == null || specChangeSet.isEmpty()) {
                this.summaryPage.setText("No files were changed");
            } else {
                StringBuilder strb = new StringBuilder("The following files will be updated on finish:\n");
                for (SpecFile specChange : specChangeSet) {
                    strb.append("\n  ").append(specChange.getFileKey().toString());
                }
                this.summaryPage.setText(strb.toString());
            }
        }
    }
}

