/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.n4js.tester.TestTreeTransformer;
import org.eclipse.n4js.tester.domain.TestCase;
import org.eclipse.n4js.tester.domain.TestResult;
import org.eclipse.n4js.tester.domain.TestStatus;
import org.eclipse.n4js.tester.domain.TestSuite;
import org.eclipse.n4js.tester.domain.TestTree;
import org.eclipse.n4js.utils.IndentLevel;

public class CliTestTreeXMLTransformer
implements TestTreeTransformer {
    private static final String START_TESTSUITE = "<testsuite";
    private static final String START_TESTCASE = "<testcase";
    private static final String START_ERROR = "<error";
    private static final String END_NL = ">\n";
    private static final String END_TESTCASE = "</testcase>\n";
    private static final String END_TESTSUITE = "</testsuite>\n";
    private static final String END_QUOTES = "\"";
    private static final String SP_NAME_EQ = " name=\"";
    private static final String SP_TIMESTAMP_EQ = " timestamp=\"";
    private static final String SP_TESTS_EQ = " tests=\"";
    private static final String SP_CLASSNAME_EQ = " classname=\"";
    private static final String SP_ERRORS_EQ = " errors=\"";
    private static final String SP_FAILURES_EQ = " failures=\"";
    private static final String SP_SKIPPED_EQ = " skipped=\"";
    private static final String SP_TIME_EQ = " time=\"";
    private static final String SP_MESSAGE_EQ = " message=\"";
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS");

    @Override
    public Object apply(TestTree tree) {
        return this.apply(tree, Collections.emptyMap());
    }

    @Override
    public Object apply(TestTree tree, Map<String, Object> properties) {
        IndentLevel indendLevel = new IndentLevel("\t");
        StringBuilder sb = new StringBuilder();
        String n4TestName = (String)properties.get("n4-test-name");
        String n4TestPackage = (String)properties.get("n4-test-package");
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<testsuites>\n");
        indendLevel.increase();
        tree.getSuites().forEach(suite -> sb.append((CharSequence)this.stringifyTestSuite((TestSuite)suite, indendLevel, n4TestName, n4TestPackage)));
        indendLevel.decrease();
        sb.append("</testsuites>\n");
        return sb;
    }

    private StringBuilder stringifyTestSuite(TestSuite testSuite, IndentLevel indendLevel, String n4TestName, String n4TestPackage) {
        StringBuilder sb = new StringBuilder();
        String name = n4TestName == null || n4TestName.isEmpty() ? testSuite.getName() : n4TestName;
        String packageOrEmpty = n4TestPackage == null || n4TestPackage.isEmpty() ? "" : " package=\"" + n4TestPackage + END_QUOTES;
        AtomicInteger testCases = new AtomicInteger(0);
        AtomicInteger testCasesErrors = new AtomicInteger(0);
        AtomicInteger testCasesFailures = new AtomicInteger(0);
        AtomicInteger testCasesSkipped = new AtomicInteger(0);
        AtomicLong time = new AtomicLong(0L);
        testSuite.forEach(tc -> {
            testCases.incrementAndGet();
            time.addAndGet(tc.getResult().getElapsedTime());
            switch (tc.getResult().getTestStatus()) {
                case PASSED: {
                    break;
                }
                case SKIPPED: 
                case SKIPPED_NOT_IMPLEMENTED: 
                case SKIPPED_PRECONDITION: 
                case SKIPPED_IGNORE: 
                case SKIPPED_FIXME: {
                    testCasesSkipped.incrementAndGet();
                    break;
                }
                case ERROR: {
                    testCasesErrors.incrementAndGet();
                    break;
                }
                case FAILED: {
                    testCasesFailures.incrementAndGet();
                    break;
                }
                default: {
                    throw new RuntimeException("unhandled status " + (Object)((Object)tc.getResult().getTestStatus()));
                }
            }
        });
        sb.append(START_TESTSUITE).append(packageOrEmpty).append(SP_NAME_EQ).append(name).append(END_QUOTES).append(SP_TESTS_EQ).append(testCases).append(END_QUOTES).append(SP_ERRORS_EQ).append(testCasesErrors).append(END_QUOTES).append(SP_FAILURES_EQ).append(testCasesFailures).append(END_QUOTES).append(SP_SKIPPED_EQ).append(testCasesSkipped).append(END_QUOTES).append(SP_TIME_EQ).append(this.converTime(time.get())).append(END_QUOTES).append(SP_TIMESTAMP_EQ).append(df.format(new Date())).append(END_QUOTES).append(END_NL);
        indendLevel.increase();
        testSuite.getTestCases().forEach(testCase -> {
            StringBuilder stringBuilder2 = sb.append((CharSequence)this.stringifyTestCase((TestCase)testCase, indendLevel));
        });
        indendLevel.decrease();
        sb.append(END_TESTSUITE);
        return sb;
    }

    private StringBuilder stringifyTestCase(TestCase testCase, IndentLevel indendLevel) {
        StringBuilder sb = new StringBuilder();
        TestResult result = testCase.getResult();
        TestStatus status = result.getTestStatus();
        sb.append(indendLevel.get()).append(START_TESTCASE).append(SP_NAME_EQ).append(testCase.getName()).append(END_QUOTES).append(SP_CLASSNAME_EQ).append(testCase.getClassName()).append(END_QUOTES).append(SP_TIME_EQ).append(this.converTime(testCase.getResult().getElapsedTime())).append(END_QUOTES).append(END_NL);
        switch (status) {
            case PASSED: {
                break;
            }
            case SKIPPED: 
            case SKIPPED_NOT_IMPLEMENTED: 
            case SKIPPED_PRECONDITION: 
            case SKIPPED_IGNORE: 
            case SKIPPED_FIXME: {
                indendLevel.increase();
                sb.append(indendLevel.get()).append("<skipped/>\n");
                indendLevel.decrease();
                break;
            }
            case FAILED: 
            case ERROR: {
                indendLevel.increase();
                sb.append(indendLevel.get()).append(START_ERROR).append(SP_MESSAGE_EQ).append(this.escapeString(testCase.getResult().getMessage())).append(END_QUOTES).append(END_NL);
                indendLevel.decrease();
                break;
            }
            default: {
                throw new RuntimeException("unhandled status " + (Object)((Object)status));
            }
        }
        sb.append(indendLevel.get()).append(END_TESTCASE);
        return sb;
    }

    private double converTime(long miliseconds) {
        return (double)miliseconds / 1000.0;
    }

    private String escapeString(String message) {
        return message;
    }
}

