/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.external.TargetPlatformInstallLocationProvider;
import org.eclipse.n4js.external.libraries.ExternalLibrariesActivator;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectDescription.ProjectDependency;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.internal.EclipseBasedN4JSWorkspace;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class ExternalProjectMappings {
    static final boolean REDUCE_REGISTERED_NPMS = true;
    private final EclipseBasedN4JSWorkspace userWorkspace;
    private final ExternalLibraryPreferenceStore preferenceStore;
    private final TargetPlatformInstallLocationProvider platformLocationProvider;
    final Map<URI, Pair<N4JSExternalProject, ProjectDescription>> completeCache;
    final List<Pair<URI, ProjectDescription>> completeList;
    final Map<String, List<N4JSExternalProject>> completeProjectNameMapping;
    final Map<URI, Pair<N4JSExternalProject, ProjectDescription>> reducedProjectUriMapping;
    final Map<java.net.URI, List<N4JSExternalProject>> reducedProjectsLocationMapping;
    final Set<N4JSExternalProject> reducedSet;
    final boolean initialized;

    ExternalProjectMappings(EclipseBasedN4JSWorkspace userWorkspace, ExternalLibraryPreferenceStore preferenceStore, TargetPlatformInstallLocationProvider platformLocationProvider, Map<URI, Pair<N4JSExternalProject, ProjectDescription>> completeCache) {
        this(userWorkspace, preferenceStore, platformLocationProvider, completeCache, true);
    }

    protected ExternalProjectMappings(EclipseBasedN4JSWorkspace userWorkspace, ExternalLibraryPreferenceStore preferenceStore, TargetPlatformInstallLocationProvider platformLocationProvider, Map<URI, Pair<N4JSExternalProject, ProjectDescription>> completeCache, boolean initialized) {
        this.userWorkspace = userWorkspace;
        this.preferenceStore = preferenceStore;
        this.platformLocationProvider = platformLocationProvider;
        this.completeCache = completeCache;
        Mappings mappings = this.computeMappings();
        this.completeList = mappings.completeList;
        this.completeProjectNameMapping = mappings.completeProjectNameMapping;
        this.reducedProjectUriMapping = mappings.reducedProjectUriMapping;
        this.reducedProjectsLocationMapping = mappings.reducedProjectsLocationMapping;
        this.reducedSet = mappings.reducedSet;
        this.initialized = initialized;
    }

    private Mappings computeMappings() {
        HashMap completeProjectNameMappingTmp = Maps.newHashMap();
        HashMap reducedProjectUriMappingTmp = Maps.newHashMap();
        HashMap reducedProjectsLocationMappingTmp = Maps.newHashMap();
        LinkedList<Pair> completeListTmp = new LinkedList<Pair>();
        if (this.completeCache == null) {
            Mappings mappings = new Mappings();
            mappings.completeList = Collections.emptyList();
            mappings.completeProjectNameMapping = Collections.emptyMap();
            mappings.reducedSet = Collections.emptySet();
            mappings.reducedProjectsLocationMapping = Collections.emptyMap();
            mappings.reducedProjectUriMapping = Collections.emptyMap();
            return mappings;
        }
        LinkedList<URI> allPrjLocsReversed = new LinkedList<URI>(this.completeCache.keySet());
        for (URI projectLocation : allPrjLocsReversed) {
            Pair<N4JSExternalProject, ProjectDescription> pair = this.completeCache.get(projectLocation);
            N4JSExternalProject project = (N4JSExternalProject)pair.getFirst();
            ProjectDescription prjDescr = (ProjectDescription)pair.getSecond();
            completeListTmp.add(Tuples.pair((Object)projectLocation, (Object)prjDescr));
            String projectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI((URI)projectLocation);
            if (!completeProjectNameMappingTmp.containsKey(projectName)) {
                completeProjectNameMappingTmp.put(projectName, Lists.newArrayList((Object[])new N4JSExternalProject[]{project}));
                reducedProjectUriMappingTmp.put(projectLocation, pair);
                java.net.URI rootLoc = ExternalLibraryWorkspace.getRootLocationForResource((Collection)this.preferenceStore.getLocations(), (URI)projectLocation);
                reducedProjectsLocationMappingTmp.putIfAbsent(rootLoc, new LinkedList());
                ((List)reducedProjectsLocationMappingTmp.get(rootLoc)).add(project);
                continue;
            }
            List list = (List)completeProjectNameMappingTmp.get(projectName);
            list.add(project);
        }
        Set<URI> reducedSetURIs = this.computeUserWorkspaceDependencies(completeProjectNameMappingTmp, reducedProjectsLocationMappingTmp, reducedProjectUriMappingTmp);
        HashSet<N4JSExternalProject> reducedSetTmps = new HashSet<N4JSExternalProject>();
        for (URI prjLoc : reducedSetURIs) {
            Pair pair = (Pair)reducedProjectUriMappingTmp.get(prjLoc);
            if (pair == null) continue;
            N4JSExternalProject project = (N4JSExternalProject)pair.getFirst();
            reducedSetTmps.add(project);
        }
        java.net.URI nodeModulesURI = this.platformLocationProvider.getNodeModulesURI();
        List nodeModuleProjects = (List)reducedProjectsLocationMappingTmp.get(nodeModulesURI);
        if (nodeModuleProjects != null) {
            Iterator iter = nodeModuleProjects.iterator();
            while (iter.hasNext()) {
                URI location = ((N4JSExternalProject)iter.next()).getIProject().getLocation();
                if (reducedSetURIs.contains(location)) continue;
                iter.remove();
            }
        }
        reducedProjectUriMappingTmp.keySet().retainAll(reducedSetURIs);
        Preconditions.checkState((reducedSetURIs.size() == reducedProjectUriMappingTmp.size() ? 1 : 0) != 0);
        Mappings mappings = new Mappings();
        mappings.completeList = Collections.unmodifiableList(completeListTmp);
        mappings.completeProjectNameMapping = Collections.unmodifiableMap(completeProjectNameMappingTmp);
        mappings.reducedSet = Collections.unmodifiableSet(reducedSetTmps);
        mappings.reducedProjectsLocationMapping = Collections.unmodifiableMap(reducedProjectsLocationMappingTmp);
        mappings.reducedProjectUriMapping = Collections.unmodifiableMap(reducedProjectUriMappingTmp);
        return mappings;
    }

    Set<URI> computeUserWorkspaceDependencies(Map<String, List<N4JSExternalProject>> completeProjectNameMappingTmp, Map<java.net.URI, List<N4JSExternalProject>> reducedProjectsLocationMappingTmp, Map<URI, Pair<N4JSExternalProject, ProjectDescription>> reducedProjectUriMappingTmp) {
        HashSet<URI> uwsDeps = new HashSet<URI>();
        LinkedList<URI> projectsInUserWSopen = new LinkedList<URI>();
        for (URI projectInUserWS : this.userWorkspace.getAllProjectLocations()) {
            String locStr = projectInUserWS.toPlatformString(true);
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(locStr);
            if (iProject == null || !iProject.isAccessible()) continue;
            projectsInUserWSopen.add(projectInUserWS);
        }
        this.computeNecessaryDependenciesRek(completeProjectNameMappingTmp, reducedProjectUriMappingTmp, projectsInUserWSopen, uwsDeps);
        uwsDeps.removeAll(projectsInUserWSopen);
        HashSet<String> depNames = new HashSet<String>();
        for (URI uwsDep : uwsDeps) {
            String name = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI((URI)uwsDep);
            depNames.add(name);
        }
        for (java.net.URI location : reducedProjectsLocationMappingTmp.keySet()) {
            int startLastSegment;
            String locationName;
            String locationStr = location.toString();
            if (locationStr.endsWith("/")) {
                locationStr = locationStr.substring(0, locationStr.length() - 1);
            }
            if (!ExternalLibrariesActivator.SHIPPED_ROOTS_FOLDER_NAMES.contains(locationName = locationStr.substring((startLastSegment = locationStr.lastIndexOf("/")) + 1))) continue;
            List<N4JSExternalProject> list = reducedProjectsLocationMappingTmp.get(location);
            for (N4JSExternalProject n4prj : list) {
                IN4JSProject iProject = n4prj.getIProject();
                String projectName = iProject.getProjectName();
                if (depNames.contains(projectName)) continue;
                uwsDeps.add(iProject.getLocation());
            }
        }
        return uwsDeps;
    }

    private void computeNecessaryDependenciesRek(Map<String, List<N4JSExternalProject>> projectNameMappingTmp, Map<URI, Pair<N4JSExternalProject, ProjectDescription>> projectUriMappingTmp, Collection<URI> locs, Set<URI> necessaryDeps) {
        HashSet<URI> depUris = new HashSet<URI>();
        for (URI loc : locs) {
            ProjectDescription pd = this.getProjectDescription(projectUriMappingTmp, loc);
            if (pd == null || pd.getProjectType() == ProjectType.PLAINJS) continue;
            for (ProjectDependency pDep : pd.getProjectDependencies()) {
                URI depLoc = this.getProjectLocation(projectNameMappingTmp, pDep);
                if (depLoc == null || necessaryDeps.contains(depLoc)) continue;
                depUris.add(depLoc);
                necessaryDeps.add(depLoc);
            }
        }
        if (!depUris.isEmpty()) {
            this.computeNecessaryDependenciesRek(projectNameMappingTmp, projectUriMappingTmp, depUris, necessaryDeps);
        }
    }

    private URI getProjectLocation(Map<String, List<N4JSExternalProject>> projectNameMappingTmp, ProjectDependency pDep) {
        String projectName = pDep.getProjectName();
        URI depLoc = this.userWorkspace.findProjectForName(projectName);
        if (depLoc != null) {
            String locStr = depLoc.toPlatformString(true);
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(locStr);
            if (iProject == null || !iProject.isAccessible()) {
                depLoc = null;
            }
        }
        if (depLoc == null) {
            N4JSExternalProject project;
            List<N4JSExternalProject> prjsOfName = projectNameMappingTmp.get(projectName);
            N4JSExternalProject n4JSExternalProject = project = prjsOfName == null || prjsOfName.isEmpty() ? null : prjsOfName.get(0);
            if (project != null) {
                depLoc = project.getIProject().getLocation();
            }
        }
        return depLoc;
    }

    private ProjectDescription getProjectDescription(Map<URI, Pair<N4JSExternalProject, ProjectDescription>> projectUriMappingTmp, URI loc) {
        Pair<N4JSExternalProject, ProjectDescription> pair;
        ProjectDescription pd = this.userWorkspace.getProjectDescription(loc);
        if (pd == null && (pair = projectUriMappingTmp.get(loc)) != null) {
            pd = (ProjectDescription)pair.getSecond();
        }
        return pd;
    }

    private static class Mappings {
        List<Pair<URI, ProjectDescription>> completeList;
        Map<String, List<N4JSExternalProject>> completeProjectNameMapping;
        Map<URI, Pair<N4JSExternalProject, ProjectDescription>> reducedProjectUriMapping;
        Map<java.net.URI, List<N4JSExternalProject>> reducedProjectsLocationMapping;
        Set<N4JSExternalProject> reducedSet;

        private Mappings() {
        }
    }
}

