/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class PasteBookmarkAction
extends BookmarkAction {
    private BookmarkNavigator view;

    public PasteBookmarkAction(BookmarkNavigator view) {
        super(view, BookmarkMessages.PasteBookmark_text);
        this.view = view;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.paste_bookmark_action_context");
        this.setEnabled(false);
    }

    public void run() {
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        IMarker[] markerData = (IMarker[])this.view.getClipboard().getContents((Transfer)transfer);
        if (markerData == null) {
            return;
        }
        ArrayList newMarkerAttributes = new ArrayList();
        ArrayList newMarkerResources = new ArrayList();
        try {
            ResourcesPlugin.getWorkspace().run(monitor -> {
                int i = 0;
                while (i < markerData.length) {
                    if (markerData[i].getType().equals("org.eclipse.core.resources.bookmark")) {
                        newMarkerResources.add(markerData[i].getResource());
                        newMarkerAttributes.add(markerData[i].getAttributes());
                    }
                    ++i;
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.view.getShell(), (String)BookmarkMessages.PasteBookmark_errorTitle, null, (IStatus)e.getStatus());
            return;
        }
        Map[] attrs = newMarkerAttributes.toArray(new Map[newMarkerAttributes.size()]);
        IResource[] resources = newMarkerResources.toArray(new IResource[newMarkerResources.size()]);
        CreateMarkersOperation op = new CreateMarkersOperation("org.eclipse.core.resources.bookmark", attrs, resources, BookmarkMessages.PasteBookmark_undoText);
        this.execute((IUndoableOperation)op, BookmarkMessages.PasteBookmark_errorTitle, null, WorkspaceUndoUtil.getUIInfoAdapter(this.view.getShell()));
        if (op.getMarkers() != null) {
            this.view.getShell().getDisplay().asyncExec(() -> {
                this.view.getViewer().setSelection((ISelection)new StructuredSelection((Object[])op.getMarkers()));
                this.view.updatePasteEnablement();
            });
        }
    }
}

