/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.dependencies;

import com.google.common.io.Files;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class ProjectsSettingsFilesLocator {
    private static final String GIT = ".git";
    private static final String NPMRC = "npmrc";
    private static final String NODE_MODULES = "node_modules";
    private static final Logger LOGGER = Logger.getLogger(ProjectsSettingsFilesLocator.class);
    private final Set<File> foundNPMRC = new HashSet<File>();

    private ProjectsSettingsFilesLocator() {
    }

    public Collection<File> getNPMRCs() {
        return new HashSet<File>(this.foundNPMRC);
    }

    public static ProjectsSettingsFilesLocator findFiles(IProgressMonitor monitor) {
        ProjectsSettingsFilesLocator locator = new ProjectsSettingsFilesLocator();
        if (monitor.isCanceled()) {
            return locator;
        }
        HashSet<File> files = new HashSet<File>();
        HashSet<File> roots = new HashSet<File>();
        IResource[] resources = ProjectsSettingsFilesLocator.getResources();
        if (resources == null) {
            return locator;
        }
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (monitor.isCanceled()) break;
            File file = resource.getLocation().makeAbsolute().toFile();
            if (file.isDirectory()) {
                roots.add(file);
            } else if (file.isFile()) {
                files.add(file);
            }
            ++n2;
        }
        if (!monitor.isCanceled()) {
            locator.scan(roots, files, monitor);
        }
        return locator;
    }

    private static IResource[] getResources() {
        IResource[] resources = null;
        try {
            resources = ResourcesPlugin.getWorkspace().getRoot().members();
        }
        catch (CoreException e) {
            LOGGER.error((Object)"Exception when scanning file system", (Throwable)e);
        }
        return resources;
    }

    private void scan(Set<File> roots, Set<File> files, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor shallowMonitor = subMonitor.split(10);
        shallowMonitor.beginTask("Scanning workspace roots for config files", 10);
        shallowMonitor.beginTask("Shallow workspace scan...", files.size());
        for (File file : files) {
            if (monitor.isCanceled()) break;
            this.processFile(file);
            shallowMonitor.worked(1);
        }
        Set<Path> actualRoots = this.getProjectsRoots(roots);
        SubMonitor deepMonitor = subMonitor.split(90);
        deepMonitor.beginTask("Deep workspace scan...", roots.size());
        for (Path path : actualRoots) {
            if (monitor.isCanceled()) break;
            File root = path.toFile();
            deepMonitor.setTaskName("Scanning " + root.getName() + "...");
            this.processContainer(root);
            deepMonitor.worked(1);
        }
    }

    private Set<Path> getProjectsRoots(Set<File> roots) {
        HashSet<Path> actualRoots = new HashSet<Path>();
        for (File root : roots) {
            Path actualRoot = this.getRepoRootOrArgument(root);
            if (this.isContained(actualRoot, actualRoots)) continue;
            actualRoots.add(actualRoot);
        }
        return actualRoots;
    }

    private Path getRepoRootOrArgument(File file) {
        File result = file;
        File parent = file;
        while (parent != null) {
            if (parent.isDirectory() && Arrays.asList(parent.list()).contains(GIT)) {
                result = parent;
            }
            parent = parent.getParentFile();
        }
        return result.toPath().toAbsolutePath().normalize();
    }

    private boolean isContained(Path path, Collection<Path> paths) {
        for (Path member : paths) {
            if (!path.startsWith(member)) continue;
            return true;
        }
        return false;
    }

    private void processContainer(File file) {
        if (file.isFile()) {
            this.processFile(file);
        } else if (file.isDirectory() && !file.getName().equals(GIT) && !file.getName().equals(NODE_MODULES)) {
            Arrays.asList(file.listFiles()).forEach(this::processContainer);
        }
    }

    private void processFile(File file) {
        switch (Files.getFileExtension((String)file.getAbsolutePath())) {
            case "npmrc": {
                this.foundNPMRC.add(file);
                break;
            }
        }
    }
}

