/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.hlc.base.testing;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.eclipse.n4js.generator.headless.logging.IHeadlessLogger;
import org.eclipse.n4js.hlc.base.ErrorExitCode;
import org.eclipse.n4js.hlc.base.ExitCodeException;
import org.eclipse.n4js.tester.TesterEventBus;
import org.eclipse.n4js.tester.domain.TestTree;
import org.eclipse.n4js.tester.events.SessionEndedEvent;
import org.eclipse.n4js.tester.events.SessionFailedEvent;
import org.eclipse.n4js.tester.events.SessionFinishedEvent;
import org.eclipse.n4js.tester.events.SessionPingedEvent;
import org.eclipse.n4js.tester.events.SessionStartedEvent;
import org.eclipse.n4js.tester.events.TestEndedEvent;
import org.eclipse.n4js.tester.events.TestEndedEventDispatcher;
import org.eclipse.n4js.tester.events.TestEvent;
import org.eclipse.n4js.tester.events.TestEventDispatcher;
import org.eclipse.n4js.tester.events.TestPingedEvent;
import org.eclipse.n4js.tester.events.TestStartedEvent;

public class LoggingTestListener {
    private final TestEventDispatcher<ExitCodeException> dispatchTestEvent = new TestEventDispatcher(this::handleSessionStarted, this::handleSessionFinished, this::handleSessionFailed, this::handleSessionPinged, this::handleSessionEnded, this::handleTestPinged, this::handleTestStarted, this::handleTestEndedEvent, this::handleUnmatchedTestEvent);
    private final TestEndedEventDispatcher<ExitCodeException> dispatchTestEndedEvent = new TestEndedEventDispatcher(this::handleTestPassed, this::handleTestSkipped, this::handleTestFailed, this::handleUnmatchedStatus);
    private TestTree testTree = null;
    private boolean testsOK = true;
    private boolean sessionOK = true;
    private boolean sessionFinished = false;
    private final TesterEventBus testerEventBus;
    private final IHeadlessLogger logger;

    public LoggingTestListener(TesterEventBus testerEventBus, IHeadlessLogger logger, TestTree tree) {
        this.testerEventBus = testerEventBus;
        this.logger = logger;
        this.startListening(tree);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onTestEvent(TestEvent ev) throws ExitCodeException {
        if (this.testTree.getSessionId().toString().equals(ev.getSessionId())) {
            this.handleTestEvent(ev);
        }
    }

    public boolean finished() {
        return this.sessionFinished;
    }

    public boolean isOK() {
        return this.sessionFinished && this.sessionOK && this.testsOK;
    }

    private void handleTestEndedEvent(TestEndedEvent tee) throws ExitCodeException {
        this.testTree.getTestCase(tee.getTestId()).setResult(tee.getResult());
        this.dispatchTestEndedEvent.accept(tee);
    }

    private void handleTestEvent(TestEvent event) throws ExitCodeException {
        this.dispatchTestEvent.accept(event);
    }

    private void handleSessionPinged(SessionPingedEvent event) {
        this.logger.debug(event.toString());
    }

    private void handleSessionFailed(SessionFailedEvent event) {
        this.logger.error(event.toString());
        this.sessionOK = false;
    }

    private void handleSessionFinished(SessionFinishedEvent event) {
        this.logger.info(event.toString());
        this.sessionFinished = true;
        this.stopListening();
    }

    private void handleSessionEnded(SessionEndedEvent event) {
        this.logger.info(event.toString());
        this.sessionOK = true;
    }

    private void handleSessionStarted(SessionStartedEvent event) {
        this.logger.info(event.toString());
    }

    private void handleUnmatchedTestEvent(TestEvent te) throws ExitCodeException {
        throw new ExitCodeException(ErrorExitCode.EXITCODE_TESTER_STOPPED_WITH_ERROR, "unhandled test event " + te);
    }

    private void handleTestPinged(TestPingedEvent event) {
        this.logger.debug(event.toString());
    }

    private void handleTestStarted(TestStartedEvent event) {
        this.logger.info(event.toString());
    }

    private void handleTestPassed(TestEndedEvent tee) {
        this.logger.info(String.valueOf(tee.toString()) + " => " + tee.getResult().toString());
    }

    private void handleTestSkipped(TestEndedEvent tee) {
        this.logger.warn(String.valueOf(tee.toString()) + " => " + tee.getResult().getTestStatus());
    }

    private void handleTestFailed(TestEndedEvent tee) {
        this.testsOK = false;
        this.logger.error(String.valueOf(tee.toString()) + " => " + tee.getResult().getTestStatus());
    }

    private void handleUnmatchedStatus(TestEndedEvent tee) throws ExitCodeException {
        throw new ExitCodeException(ErrorExitCode.EXITCODE_TESTER_STOPPED_WITH_ERROR, "unhandled test ended status " + tee + " => " + tee.getResult().getTestStatus());
    }

    private void stopListening() {
        this.testerEventBus.unregister((Object)this);
        this.testTree = null;
    }

    private void startListening(TestTree tree) {
        this.testerEventBus.register((Object)this);
        this.testTree = tree;
    }
}

