/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.resource.N4JSCrossReferenceComputer;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.resource.N4JSResourceDescriptionStrategy;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TEnumLiteral;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.SuperTypesList;
import org.eclipse.n4js.ts.utils.TypeHelper;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.IResourceScopeCache;

public class N4JSResourceDescription
extends DefaultResourceDescription {
    private static final Logger log = Logger.getLogger(N4JSResourceDescription.class);
    private final IQualifiedNameProvider qualifiedNameProvider;
    private final N4JSCrossReferenceComputer crossReferenceComputer;
    private final TypeHelper typeHelper;
    private final IDefaultResourceDescriptionStrategy strategy;
    private SortedSet<QualifiedName> lazyImportedNames;

    public N4JSResourceDescription(N4JSCrossReferenceComputer crossReferenceComputer, TypeHelper typeHelper, IQualifiedNameProvider qualifiedNameProvider, Resource resource, N4JSResourceDescriptionStrategy strategy, IResourceScopeCache cache) {
        super(resource, (IDefaultResourceDescriptionStrategy)strategy, cache);
        this.crossReferenceComputer = crossReferenceComputer;
        this.qualifiedNameProvider = qualifiedNameProvider;
        this.typeHelper = typeHelper;
        this.strategy = strategy;
    }

    protected List<IEObjectDescription> computeExportedObjects() {
        N4JSResource res;
        N4JSResource n4JSResource = res = this.getResource() instanceof N4JSResource ? (N4JSResource)this.getResource() : null;
        if (res == null || !res.isLoadedFromDescription()) {
            return super.computeExportedObjects();
        }
        if (!this.getResource().isLoaded()) {
            try {
                this.getResource().load(null);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        final ArrayList exportedEObjects = Lists.newArrayList();
        IAcceptor<IEObjectDescription> acceptor = new IAcceptor<IEObjectDescription>(){

            public void accept(IEObjectDescription eObjectDescription) {
                exportedEObjects.add(eObjectDescription);
            }
        };
        this.strategy.createEObjectDescriptions((EObject)res.getModule(), (IAcceptor)acceptor);
        return exportedEObjects;
    }

    protected List<IReferenceDescription> computeReferenceDescriptions() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<QualifiedName> getImportedNames() {
        if (this.lazyImportedNames == null) {
            N4JSResourceDescription n4JSResourceDescription = this;
            synchronized (n4JSResourceDescription) {
                if (this.lazyImportedNames == null) {
                    Iterable superImportedNames = super.getImportedNames();
                    TreeSet importedNames = superImportedNames != null ? Sets.newTreeSet((Iterable)superImportedNames) : Sets.newTreeSet();
                    Resource resource = this.getResource();
                    EList contents = resource.getContents();
                    if (contents.size() > 1) {
                        TModule module = (TModule)contents.get(1);
                        importedNames.add(this.qualifiedNameProvider.getFullyQualifiedName((EObject)module));
                    }
                    HashSet crossRefTypes = Sets.newHashSet();
                    IAcceptor<EObject> acceptor = this.getCrossRefTypeAcceptor(crossRefTypes);
                    this.crossReferenceComputer.computeCrossRefs(resource, acceptor);
                    for (EObject type : crossRefTypes) {
                        if (type instanceof Type) {
                            this.handleType(importedNames, type);
                            continue;
                        }
                        if (type instanceof TVariable) {
                            this.handleTVariable(importedNames, (TVariable)type);
                            continue;
                        }
                        if (!(type instanceof TEnumLiteral)) continue;
                        this.handleTEnumLiteral(importedNames, (TEnumLiteral)type);
                    }
                    this.lazyImportedNames = importedNames;
                }
            }
        }
        return this.lazyImportedNames;
    }

    private void handleTEnumLiteral(Set<QualifiedName> importedNames, TEnumLiteral literal) {
        TEnum tEnum = (TEnum)literal.eContainer();
        if (tEnum != null) {
            this.handleType(importedNames, (EObject)tEnum);
        }
    }

    private void handleTVariable(Set<QualifiedName> importedNames, TVariable var) {
        Type declType;
        TypeRef ref = var.getTypeRef();
        if (ref != null && (declType = ref.getDeclaredType()) != null) {
            this.handleType(importedNames, (EObject)declType);
        }
    }

    private void handleType(Set<QualifiedName> importedNames, EObject type) {
        SuperTypesList collected = this.typeHelper.collectAllDeclaredSuperTypes((Type)type, true);
        for (Type collectedType : collected) {
            this.collectAsImportedName(importedNames, (EObject)collectedType);
        }
    }

    private void collectAsImportedName(Set<QualifiedName> importedNames, EObject eObject) {
        QualifiedName importedName = this.qualifiedNameProvider.getFullyQualifiedName(eObject);
        if (importedName != null) {
            importedNames.add(importedName);
        }
    }

    private IAcceptor<EObject> getCrossRefTypeAcceptor(final Set<EObject> crossRefTypesAddHere) {
        IAcceptor<EObject> acceptor = new IAcceptor<EObject>(){

            public void accept(EObject to) {
                if (to instanceof Type || to instanceof TVariable || to instanceof TEnumLiteral) {
                    crossRefTypesAddHere.add(to);
                }
                if (to instanceof TFunction) {
                    TypeRef returnTypeRef = ((TFunction)to).getReturnTypeRef();
                    crossRefTypesAddHere.add(returnTypeRef.getDeclaredType());
                }
                if (to instanceof TField) {
                    TypeRef typeRef = ((TField)to).getTypeRef();
                    crossRefTypesAddHere.add(typeRef.getDeclaredType());
                }
                if (to instanceof TMember) {
                    TMember casted = (TMember)to;
                    ContainerType declaringType = casted.getContainingType();
                    crossRefTypesAddHere.add(declaringType);
                }
            }
        };
        return acceptor;
    }
}

