/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.project;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.ui.wizard.project.FileContentUtil;
import org.eclipse.n4js.ui.wizard.project.N4JSNewProjectFileTemplates;
import org.eclipse.n4js.ui.wizard.project.N4JSProjectInfo;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.util.ProjectFactory;
import org.eclipse.xtext.ui.wizard.AbstractProjectCreator;
import org.eclipse.xtext.ui.wizard.IProjectInfo;

public class N4JSProjectCreator
extends AbstractProjectCreator {
    private static Logger LOGGER = Logger.getLogger(N4JSProjectCreator.class);
    private static final String SRC_ROOT = "src";
    private static final String TEST_SRC_ROOT = "test";
    private static final String SRC_GEN = "src-gen";
    private static final String[] BUILDERS = new String[]{"org.eclipse.xtext.ui.shared.xtextBuilder"};
    private static final String[] NATURES = new String[]{"org.eclipse.xtext.ui.shared.xtextNature"};
    private static final List<String> SRC_FOLDER_LIST = ImmutableList.of((Object)"src", (Object)"src-gen");
    private static final List<String> MANGELHAFT_DEPENDENCIES = Arrays.asList("org.eclipse.n4js.mangelhaft", "org.eclipse.n4js.mangelhaft.assert");
    private String modelFolderName = "src";
    private final List<String> allFolders = new ArrayList<String>(SRC_FOLDER_LIST);
    @Inject
    private Provider<ProjectFactory> projectFactoryProvider;

    protected ProjectFactory createProjectFactory() {
        return (ProjectFactory)this.projectFactoryProvider.get();
    }

    protected IProject createProject(IProgressMonitor monitor) {
        IProject project = super.createProject(monitor);
        if (project == null) {
            throw new NullPointerException("The project could not be created.");
        }
        return project;
    }

    protected String getModelFolderName() {
        return this.modelFolderName;
    }

    protected List<String> getAllFolders() {
        return this.allFolders;
    }

    protected String[] getProjectNatures() {
        return NATURES;
    }

    protected String[] getBuilders() {
        return BUILDERS;
    }

    public void setProjectInfo(IProjectInfo projectInfo) {
        super.setProjectInfo(projectInfo);
        if (projectInfo instanceof N4JSProjectInfo && ProjectType.TEST.equals((Object)((N4JSProjectInfo)projectInfo).getProjectType())) {
            this.configureTestProject((N4JSProjectInfo)projectInfo);
        }
    }

    private void configureTestProject(N4JSProjectInfo projectInfo) {
        this.modelFolderName = TEST_SRC_ROOT;
        this.allFolders.add(TEST_SRC_ROOT);
        if (!projectInfo.getAdditionalSourceFolder()) {
            this.allFolders.remove(SRC_ROOT);
        }
    }

    protected ProjectFactory configureProjectFactory(ProjectFactory factory) {
        ProjectFactory projectFactory = super.configureProjectFactory(factory);
        N4JSProjectInfo projectInfo = (N4JSProjectInfo)this.getProjectInfo();
        if (projectInfo.getProjectLocation() != null) {
            projectFactory.setLocation(projectInfo.getProjectLocation());
        }
        return projectFactory;
    }

    protected void enhanceProject(IProject project, IProgressMonitor monitor) throws CoreException {
        N4JSProjectInfo pi = (N4JSProjectInfo)this.getProjectInfo();
        if (pi.getOutputFolder() == null) {
            pi.setOutputFolder(SRC_GEN);
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        wb.getWorkingSetManager().addToWorkingSets((IAdaptable)project, pi.getSelectedWorkingSets());
        String projectName = pi.getProjectName();
        List<String> otherFolders = Arrays.asList(new String[0]);
        for (String folderName : otherFolders) {
            IFolder folder = project.getFolder(folderName);
            folder.create(false, true, monitor);
        }
        String derivedProjectNameIdentifier = this.deriveN4JSIdentifierFromProjectName(projectName);
        Charset charset = this.getWorkspaceCharsetOrUtf8();
        HashMap<String, CharSequence> pathContentMap = new HashMap<String, CharSequence>();
        if (ProjectType.TEST.equals((Object)pi.getProjectType()) && pi.getCreateGreeterFile()) {
            pathContentMap.put(String.valueOf(this.modelFolderName) + "/" + "Test_" + derivedProjectNameIdentifier + ".n4js", N4JSNewProjectFileTemplates.getSourceFileWithTestGreeter(derivedProjectNameIdentifier));
        }
        if (!ProjectType.TEST.equals((Object)pi.getProjectType()) && pi.getCreateGreeterFile()) {
            pathContentMap.put(String.valueOf(this.modelFolderName) + "/" + "GreeterModule_" + derivedProjectNameIdentifier + ".n4js", N4JSNewProjectFileTemplates.getSourceFileWithGreeterClass(projectName, derivedProjectNameIdentifier));
        }
        for (Map.Entry entry : pathContentMap.entrySet()) {
            this.createIfNotExists(project, (String)entry.getKey(), (CharSequence)entry.getValue(), charset, monitor);
        }
        List<String> sources = pi.getSourceFolders();
        List<String> tests = pi.getTestSourceFolders();
        if (ProjectType.TEST.equals((Object)pi.getProjectType())) {
            if (pi.getAdditionalSourceFolder()) {
                sources.add(SRC_ROOT);
            }
            tests.add(this.modelFolderName);
        } else {
            sources.add(this.modelFolderName);
        }
        if (ProjectType.TEST.equals((Object)pi.getProjectType())) {
            List<String> projectDependencies = pi.getProjectDependencies();
            projectDependencies.addAll(MANGELHAFT_DEPENDENCIES);
        }
        String projectDescriptionContent = N4JSNewProjectFileTemplates.getProjectDescriptionContents(pi);
        this.createIfNotExists(project, "package.json", projectDescriptionContent, charset, monitor);
        project.refreshLocal(2, monitor);
    }

    private String deriveN4JSIdentifierFromProjectName(String projectName) {
        String n4jsProjectName = ProjectDescriptionUtils.convertEclipseProjectNameToN4JSProjectName((String)projectName);
        String plainProjectName = ProjectDescriptionUtils.getPlainProjectName((String)n4jsProjectName);
        return plainProjectName.replaceAll("\\.", "_").replaceAll("-", "_").trim();
    }

    private void createIfNotExists(IProject project, String relativePath, CharSequence contents, Charset charset, IProgressMonitor monitor) throws CoreException {
        IFile file = project.getFile(relativePath);
        if (!file.exists()) {
            file.create(FileContentUtil.from(contents, charset), false, monitor);
        }
    }

    private Charset getWorkspaceCharsetOrUtf8() {
        try {
            return Charset.forName(super.getEncoding());
        }
        catch (UnsupportedCharsetException | CoreException e) {
            LOGGER.error((Object)"Cannot obtain workspace charset", e);
            LOGGER.info((Object)("Exceptions when obtaining workspace default charset, fall back to the " + StandardCharsets.UTF_8.name()), e);
            return StandardCharsets.UTF_8;
        }
    }
}

