/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator.headless;

import com.google.inject.Inject;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.n4js.generator.CompilerDescriptor;
import org.eclipse.n4js.generator.ICompositeGenerator;
import org.eclipse.n4js.generator.headless.ConfiguredGenerator;
import org.eclipse.n4js.generator.headless.WrappedOutputConfiguration;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.utils.ComponentDescriptor;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;

public class ConfiguredGeneratorFactory {
    @Inject
    private ICompositeGenerator compositeGenerator;
    @Inject
    private JavaIoFileSystemAccess fsa;
    private Map<String, OutputConfiguration> initialOutputConfiguration;

    ConfiguredGenerator getConfiguredGenerator(IN4JSProject project) {
        this.configureFSA(project);
        return new ConfiguredGenerator((IGenerator)this.compositeGenerator, (IFileSystemAccess)this.fsa);
    }

    private void configureFSA(IN4JSProject project) {
        File currentDirectory = new File(".");
        File projectLocation = new File(project.getLocation().toFileString());
        URI projectURI = currentDirectory.toURI().relativize(projectLocation.toURI());
        String projectPath = projectURI.getPath();
        if (projectPath.length() != 0) {
            if (this.initialOutputConfiguration == null) {
                this.initialOutputConfiguration = ConfiguredGeneratorFactory.getInitialOutputConfigurations(this.compositeGenerator);
            }
            Map<String, OutputConfiguration> configs = ConfiguredGeneratorFactory.transformedOutputConfiguration(projectPath, this.initialOutputConfiguration);
            this.fsa.setOutputConfigurations(configs);
        }
    }

    private static Map<String, OutputConfiguration> transformedOutputConfiguration(String projectPath, Map<String, OutputConfiguration> outputConfigToBeWrapped) {
        HashMap<String, OutputConfiguration> result = new HashMap<String, OutputConfiguration>();
        outputConfigToBeWrapped.forEach((name, config) -> result.put((String)name, new WrappedOutputConfiguration((OutputConfiguration)config, projectPath)));
        return result;
    }

    private static Map<String, OutputConfiguration> getInitialOutputConfigurations(ICompositeGenerator generator) {
        return generator.getCompilerDescriptors().stream().collect(Collectors.toMap(ComponentDescriptor::getIdentifier, CompilerDescriptor::getOutputConfiguration));
    }
}

