/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.HlcExternalLibraryWorkspace;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.internal.InternalN4JSWorkspace;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.xtext.util.Pair;

@ImplementedBy(value=HlcExternalLibraryWorkspace.class)
public abstract class ExternalLibraryWorkspace
extends InternalN4JSWorkspace {
    @Inject
    private ExternalLibraryPreferenceStore externalLibraryPreferenceStore;

    public abstract RegisterResult registerProjects(IProgressMonitor var1, Set<URI> var2);

    public abstract RegisterResult deregisterProjects(IProgressMonitor var1, Set<URI> var2);

    public abstract RegisterResult deregisterAllProjects(IProgressMonitor var1);

    public abstract void scheduleWorkspaceProjects(IProgressMonitor var1, Set<URI> var2);

    public abstract Collection<N4JSExternalProject> getProjects();

    public abstract Map<String, VersionNumber> getProjectNameVersionMap();

    public abstract List<Pair<URI, ProjectDescription>> getProjectsIncludingUnnecessary();

    public abstract List<Pair<URI, ProjectDescription>> computeProjectsIncludingUnnecessary();

    public abstract List<N4JSExternalProject> getProjectsForName(String var1);

    public abstract Collection<N4JSExternalProject> getProjectsIn(java.net.URI var1);

    public abstract Collection<N4JSExternalProject> getProjectsIn(Collection<java.net.URI> var1);

    public abstract N4JSExternalProject getProject(String var1);

    public abstract N4JSExternalProject getProject(URI var1);

    public abstract IResource getResource(URI var1);

    public abstract void updateState();

    public java.net.URI getRootLocationForResource(URI nestedLocation) {
        return ExternalLibraryWorkspace.getRootLocationForResource(this.externalLibraryPreferenceStore.getLocations(), nestedLocation);
    }

    public static final java.net.URI getRootLocationForResource(Collection<java.net.URI> rootLocations, URI nestedLocation) {
        if (nestedLocation == null || nestedLocation.isEmpty() || !nestedLocation.isFile()) {
            return null;
        }
        TreeMap<String, java.net.URI> rootLocationMap = new TreeMap<String, java.net.URI>();
        for (java.net.URI loc : rootLocations) {
            String locStr = loc.toString();
            rootLocationMap.put(locStr, loc);
        }
        String nestedLocStr = nestedLocation.toString();
        String rootLocStr = rootLocationMap.floorKey(nestedLocStr);
        if (rootLocStr != null) {
            return (java.net.URI)rootLocationMap.get(rootLocStr);
        }
        return null;
    }

    public abstract boolean isNecessary(URI var1);

    public static class RegisterResult {
        public final Set<URI> externalProjectsDone;
        public final Set<URI> affectedWorkspaceProjects;
        public final Set<URI> wipedProjects;

        RegisterResult() {
            this.externalProjectsDone = RegisterResult.freeze(null);
            this.affectedWorkspaceProjects = RegisterResult.freeze(null);
            this.wipedProjects = RegisterResult.freeze(null);
        }

        public RegisterResult(Collection<URI> extPrjsDone, Collection<URI> wsPrjsAffected) {
            this(extPrjsDone, wsPrjsAffected, null);
        }

        public RegisterResult(Collection<URI> extPrjsDone, Collection<URI> wsPrjsAffected, Collection<URI> prjsWiped) {
            this.externalProjectsDone = RegisterResult.freeze(extPrjsDone);
            this.affectedWorkspaceProjects = RegisterResult.freeze(wsPrjsAffected);
            this.wipedProjects = RegisterResult.freeze(prjsWiped);
        }

        public RegisterResult(IProject[] allProjectsToClean, IProject[] wsPrjAffected) {
            this(allProjectsToClean, wsPrjAffected, null);
        }

        public RegisterResult(IProject[] allProjectsToClean, IProject[] wsPrjAffected, Collection<URI> prjsWiped) {
            this.externalProjectsDone = RegisterResult.freeze(RegisterResult.getURIs(allProjectsToClean));
            this.affectedWorkspaceProjects = RegisterResult.freeze(RegisterResult.getURIs(wsPrjAffected));
            this.wipedProjects = RegisterResult.freeze(prjsWiped);
        }

        private static Set<URI> freeze(Collection<URI> prjs) {
            if (prjs == null) {
                return Collections.unmodifiableSet(Collections.emptySet());
            }
            return Collections.unmodifiableSet(new HashSet<URI>(prjs));
        }

        private static Collection<URI> getURIs(IProject[] projects) {
            HashSet<URI> uris = new HashSet<URI>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                uris.add(URIUtils.convert((IResource)project));
                ++n2;
            }
            return uris;
        }
    }
}

