/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.userstorage.internal.Activator;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.spi.ISettings;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class Settings {
    public static final ISettings DEFAULT = Settings.createDefaultSettings();
    public static final ISettings NONE = new NoSettings();

    private Settings() {
    }

    private static ISettings createDefaultSettings() {
        String property = System.getProperty("org.eclipse.userstorage.settings", null);
        if (property != null) {
            try {
                Class<?> c = Class.forName(property);
                return (ISettings)c.newInstance();
            }
            catch (Throwable ex) {
                Activator.log(ex);
            }
        }
        if (Activator.PLATFORM_RUNNING) {
            try {
                return new EclipseSettings("instance");
            }
            catch (Throwable throwable) {
                try {
                    return new EclipseSettings("configuration");
                }
                catch (Throwable throwable2) {}
            }
        }
        return NONE;
    }

    public static final class EclipseSettings
    implements ISettings {
        private final Preferences node;

        public EclipseSettings(String scope, String pluginID) throws Exception {
            IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
            if (!rootNode.nodeExists(scope)) {
                throw new BackingStoreException("Invalid scope: " + scope);
            }
            this.node = rootNode.node(scope).node(pluginID);
        }

        public EclipseSettings(String scope) throws Exception {
            this(scope, "org.eclipse.userstorage");
        }

        @Override
        public String getValue(String key) throws Exception {
            return this.node.get(key, null);
        }

        @Override
        public void setValue(String key, String value) throws Exception {
            if (value == null) {
                this.node.remove(key);
            } else {
                this.node.put(key, value);
            }
            this.node.flush();
        }
    }

    public final class FileSettings
    implements ISettings {
        private final File file;

        public FileSettings(File file) {
            this.file = file;
        }

        public FileSettings(String pluginID) {
            this(new File(System.getProperty("user.home"), ".eclipse/" + pluginID + "/.settings"));
        }

        public FileSettings() {
            this("org.eclipse.userstorage");
        }

        @Override
        public String getValue(String key) throws Exception {
            Properties properties = new Properties();
            if (this.file.isFile()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(this.file);
                    properties.load(in);
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    throw throwable;
                }
                IOUtil.close(in);
            }
            return properties.getProperty(key);
        }

        @Override
        public void setValue(String key, String value) throws Exception {
            Object oldValue;
            Properties properties = new Properties();
            if (this.file.isFile()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(this.file);
                    properties.load(in);
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    throw throwable;
                }
                IOUtil.close(in);
            }
            boolean changed = false;
            if (value == null) {
                oldValue = properties.remove(key);
                if (oldValue != null) {
                    changed = true;
                }
            } else {
                oldValue = properties.setProperty(key, value);
                if (oldValue != null && !oldValue.equals(value)) {
                    changed = true;
                }
            }
            if (changed) {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(this.file);
                    properties.store(out, null);
                }
                catch (Throwable throwable) {
                    IOUtil.close(out);
                    throw throwable;
                }
                IOUtil.close(out);
            }
        }
    }

    public static final class MemorySettings
    implements ISettings {
        private final Map<String, String> map;

        public MemorySettings(Map<String, String> map) {
            this.map = map;
        }

        public MemorySettings() {
            this(new HashMap<String, String>());
        }

        @Override
        public String getValue(String key) throws Exception {
            return this.map.get(key);
        }

        @Override
        public void setValue(String key, String value) throws Exception {
            if (value == null) {
                this.map.remove(key);
            } else {
                this.map.put(key, value);
            }
        }
    }

    private static final class NoSettings
    implements ISettings {
        @Override
        public String getValue(String key) throws Exception {
            return null;
        }

        @Override
        public void setValue(String key, String value) throws Exception {
        }
    }
}

