/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.example;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.wizard.ExampleInstallerWizard;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.external.TargetPlatformInstallLocationProvider;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class N4JSTasksExampleWizard
extends ExampleInstallerWizard {
    public static final String ID = N4JSTasksExampleWizard.class.getName();
    @Inject
    private LibraryManager libManager;
    @Inject
    private TargetPlatformInstallLocationProvider installLocationProvider;
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    private SemverHelper semverHelper;

    public boolean performFinish() {
        if (super.performFinish()) {
            this.installDependencies((Map<String, NPMVersionRequirement>)ImmutableMap.of((Object)"mongodb", (Object)this.semverHelper.parse(">=2.0.0 <3.0.0"), (Object)"@n4jsd/mongodb", (Object)this.semverHelper.parse(">=2.0.0 <3.0.0"), (Object)"@n4jsd/express", (Object)this.semverHelper.parse(""), (Object)"express", (Object)this.semverHelper.parse("")));
            return true;
        }
        return false;
    }

    private void installDependencies(final Map<String, NPMVersionRequirement> namesAndVersions) {
        HashSet<String> toInstall = new HashSet<String>(namesAndVersions.keySet());
        toInstall.removeAll(this.getInstalledNpmPackages());
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.subTask("Installing dependencies");
                        IStatus status = N4JSTasksExampleWizard.this.libManager.installNPMs(namesAndVersions, true, monitor);
                        if (status.matches(4)) {
                            throw status.getException();
                        }
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e, "An error occurred while installing dependencies");
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            String pluginId = N4JSActivator.getInstance().getBundle().getSymbolicName();
            Status status = new Status(4, pluginId, e.getCause().getMessage(), e.getCause());
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage(), (IStatus)status);
            StatusManager.getManager().handle((IStatus)status);
        }
    }

    private Collection<String> getInstalledNpmPackages() {
        File root = new File(this.installLocationProvider.getNodeModulesURI());
        return FluentIterable.from((Iterable)this.externalLibraryWorkspace.getProjectsIn(root.toURI())).transform(p -> p.getName()).toSet();
    }
}

