/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.resource.N4JSEObjectDescription;
import org.eclipse.n4js.scoping.accessModifiers.AbstractTypeVisibilityChecker;
import org.eclipse.n4js.scoping.accessModifiers.InvisibleTypeOrVariableDescription;
import org.eclipse.n4js.scoping.accessModifiers.TypeVisibilityChecker;
import org.eclipse.n4js.scoping.accessModifiers.VariableVisibilityChecker;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.resource.IEObjectDescription;

public class TopLevelElementsCollector {
    @Inject
    private TypeVisibilityChecker typeVisibilityChecker;
    @Inject
    private VariableVisibilityChecker variableVisibilityChecker;

    public Iterable<IEObjectDescription> getTopLevelElements(TModule module, Resource contextResource) {
        ArrayList visible = new ArrayList();
        ArrayList invisible = new ArrayList();
        module.getTopLevelTypes().forEach(it -> {
            AbstractTypeVisibilityChecker.TypeVisibility typeVisiblity = this.typeVisibilityChecker.isVisible(contextResource, (Type)it);
            if (typeVisiblity.visibility) {
                visible.add(this.createObjectDescription((TExportableElement)it));
            } else {
                invisible.add(new InvisibleTypeOrVariableDescription(this.createObjectDescription((TExportableElement)it), typeVisiblity.accessModifierSuggestion));
            }
        });
        module.getVariables().forEach(it -> {
            AbstractTypeVisibilityChecker.TypeVisibility typeVisiblity = this.variableVisibilityChecker.isVisible(contextResource, (TVariable)it);
            if (typeVisiblity.visibility) {
                visible.add(this.createObjectDescription((TExportableElement)it));
            } else {
                invisible.add(new InvisibleTypeOrVariableDescription(this.createObjectDescription((TExportableElement)it), typeVisiblity.accessModifierSuggestion));
            }
        });
        return Iterables.concat(visible, invisible);
    }

    private IEObjectDescription createObjectDescription(TExportableElement element) {
        String exportedName = element.getExportedName();
        if (exportedName != null) {
            return N4JSEObjectDescription.create(exportedName, (EObject)element);
        }
        return N4JSEObjectDescription.create(element.getName(), (EObject)element);
    }
}

