/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;

public class TMemberEntry
implements Iterable<TMember> {
    public static final boolean CONCRETE = false;
    public static final boolean ABSTRACT = true;
    private static final int METHOD = 0;
    private static final int GETTER = 1;
    private static final int SETTER = 2;
    private static final int FIELD = 3;
    private static final int ABSTRACT_OFFSET = 4;
    private static final int LENGTH = 7;
    private final String name;
    private final boolean _static;
    private final TMember[] members = new TMember[7];
    private final MemberSource[] sources = new MemberSource[7];

    public TMemberEntry(String name, boolean _static) {
        this.name = name;
        this._static = _static;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TMemberEntry) {
            TMemberEntry other = (TMemberEntry)obj;
            return other._static == this._static && other.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() + (this._static ? 7345 : 0);
    }

    @Override
    public Iterator<TMember> iterator() {
        return new TMemberEntryIterator();
    }

    private int index(TMember m) {
        int i;
        int n = m.isField() ? 3 : (m.isGetter() ? 1 : (i = m.isSetter() ? 2 : 0));
        if (m.isAbstract() && i != 3) {
            i += 4;
        }
        return i;
    }

    public boolean add(TMember m, MemberSource source) {
        int index = this.index(m);
        if (this.members[index] == null) {
            this.members[index] = m;
            this.sources[index] = source;
            return true;
        }
        return false;
    }

    public TMethod method(boolean _abstract) {
        return (TMethod)(_abstract ? this.members[4] : this.members[0]);
    }

    public TSetter setter(boolean _abstract) {
        return (TSetter)(_abstract ? this.members[6] : this.members[2]);
    }

    public TGetter getter(boolean _abstract) {
        return (TGetter)(_abstract ? this.members[5] : this.members[1]);
    }

    public TField field() {
        return (TField)this.members[3];
    }

    public boolean hasMethod() {
        return this.method(false) != null || this.method(true) != null;
    }

    public boolean hasGetter() {
        return this.getter(false) != null || this.getter(true) != null;
    }

    public boolean hasSetter() {
        return this.setter(false) != null || this.setter(true) != null;
    }

    public boolean hasField() {
        return this.field() != null;
    }

    public boolean hasAccessor() {
        return this.hasGetter() || this.hasSetter();
    }

    public boolean hasAccessorPair() {
        return this.hasGetter() && this.hasSetter();
    }

    public boolean checkMetaTypeConsistency() {
        if (this.hasMethod()) {
            return !this.hasField() && !this.hasAccessor();
        }
        return true;
    }

    public boolean isAbstract() {
        return !this.containsConcrete();
    }

    public boolean isAbstractInherited() {
        int i = 0;
        while (i < 7) {
            if (!(this.members[i] == null || this.members[i].isAbstract() && this.sources[i] != MemberSource.OWNED)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean containsAbstract() {
        return this.method(true) != null || this.setter(true) != null || this.getter(true) != null;
    }

    public boolean containsConcrete() {
        return this.method(false) != null || this.setter(false) != null || this.getter(false) != null || this.field() != null;
    }

    public boolean hasConcreteAccessorPair() {
        return this.setter(false) != null && this.getter(false) != null;
    }

    public boolean hasSingleConcreteAccessor() {
        return this.setter(false) != null ^ this.getter(false) != null;
    }

    public MemberSource getSource(TMember member) {
        return this.sources[this.index(member)];
    }

    public String toString() {
        String pre = String.valueOf(this._static ? "static " : "") + this.name + ": {";
        ArrayList<String> out = new ArrayList<String>(8);
        int i = 0;
        while (i < 4) {
            TMember m = this.members[i];
            if (m != null) {
                out.add(m.eClass().getName());
            }
            if (i != 3 && (m = this.members[i + 4]) != null) {
                out.add("a." + m.eClass().getName());
            }
            ++i;
        }
        return String.valueOf(pre) + Joiner.on((String)", ").join(out) + "}";
    }

    public static enum MemberSource {
        OWNED,
        INHERITED,
        MIXEDIN;

    }

    private class TMemberEntryIterator
    implements Iterator<TMember> {
        private int next = 0;

        private TMemberEntryIterator() {
            this.findNext();
        }

        private void findNext() {
            while (this.next < 7 && TMemberEntry.this.members[this.next] == null) {
                ++this.next;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next < 7;
        }

        @Override
        public TMember next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TMember m = TMemberEntry.this.members[this.next];
            ++this.next;
            this.findNext();
            return m;
        }
    }
}

