/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.command;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class MassOpenHandler
implements IHandler {
    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), "Mass Open", "Enter file names to open\n(separated by space, comma, or semicolon; no paths, just files names):", "", null);
        if (dlg.open() == 0) {
            Set<String> fileNames = this.parseNamesString(dlg.getValue());
            this.openEditors(fileNames);
        }
        return null;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    private Set<String> parseNamesString(String namesStr) {
        String[] namesArr = namesStr.split("(\\s+)|(\\s*\\,\\s*)|(\\s*\\;\\s*)");
        HashSet<String> namesSet = new HashSet<String>();
        String[] stringArray = namesArr;
        int n = namesArr.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.contains(".")) {
                namesSet.add(name);
            } else {
                namesSet.add(String.valueOf(name) + "." + "n4js");
                namesSet.add(String.valueOf(name) + "." + "n4jsd");
                namesSet.add(String.valueOf(name) + "." + "n4jsx");
                namesSet.add(String.valueOf(name) + "." + "n4idl");
            }
            ++n2;
        }
        return namesSet;
    }

    private void openEditors(Set<String> fileNames) {
        try {
            this.collectFiles(fileNames, file -> {
                try {
                    this.openEditor((IFile)file);
                }
                catch (PartInitException e) {
                    System.err.println("Unable to open editor for file: " + file.getFullPath());
                    System.err.println("    " + e.getMessage());
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void openEditor(IFile file) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
    }

    private void collectFiles(Set<String> names, Consumer<IFile> consumer) throws CoreException {
        this.collectFiles((IContainer)ResourcesPlugin.getWorkspace().getRoot(), names, consumer);
    }

    private void collectFiles(IContainer container, Set<String> names, Consumer<IFile> consumer) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            IResource member = iResourceArray[n2];
            if (member instanceof IContainer) {
                if (!(member instanceof IProject) || ((IProject)member).isOpen()) {
                    this.collectFiles((IContainer)member, names, consumer);
                }
            } else if (member instanceof IFile && names.contains(fileName = member.getName())) {
                consumer.accept((IFile)member);
            }
            ++n2;
        }
    }
}

