/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitorInternal;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public abstract class BranchWalkerInternal {
    private int branchNumber = -1;
    private GraphExplorerInternal pathExplorer;
    private final LinkedList<BranchWalkerInternal> pathPredecessors = new LinkedList();
    private final LinkedList<BranchWalkerInternal> pathSuccessors = new LinkedList();
    private boolean isDeadCodeBranch = false;
    private boolean isDeadCodeNode = false;

    protected void initialize() {
    }

    protected void visit(Node node) {
    }

    protected void visit(Node lastVisitedNode, Node nextNode, ControlFlowEdge edge) {
    }

    protected abstract BranchWalkerInternal fork();

    protected void terminate() {
    }

    protected void switchedToDeadBranch() {
    }

    final void callInitialize(GraphExplorerInternal explorer, BranchWalkerInternal predecessor) {
        if (predecessor != null) {
            predecessor.pathSuccessors.add(this);
            this.pathPredecessors.add(predecessor);
        }
        this.initializeRest(explorer);
    }

    final void callInitialize(GraphExplorerInternal explorer, List<BranchWalkerInternal> predecessors) {
        for (BranchWalkerInternal pred : predecessors) {
            pred.pathSuccessors.add(this);
            this.pathPredecessors.add(pred);
        }
        this.initializeRest(explorer);
    }

    private void initializeRest(GraphExplorerInternal explorer) {
        Preconditions.checkState((this.branchNumber == -1 ? 1 : 0) != 0, (Object)"Cannot initialize twice");
        this.branchNumber = explorer.getAndIncrementBranchCounter();
        this.pathExplorer = explorer;
        this.pathExplorer.allBranches.add(this);
        this.pathExplorer.activeBranches.add(this);
        this.initialize();
    }

    final void callVisit(Node node) {
        this.isDeadCodeNode = node.isUnreachable();
        this.setDeadCode(this.isDeadCodeBranch || this.isDeadCodeNode);
        this.visit(node);
    }

    final void callVisit(Node lastVisitNode, Node end, ControlFlowEdge edge) {
        this.isDeadCodeNode = end.isUnreachable();
        this.setDeadCode(this.isDeadCodeBranch || this.isDeadCodeNode);
        this.visit(lastVisitNode, end, edge);
    }

    final void setDeadCode(boolean isDead) {
        this.isDeadCodeBranch = isDead;
        if (this.isDeadCodeBranch) {
            this.switchedToDeadBranch();
        }
    }

    final BranchWalkerInternal callFork() {
        BranchWalkerInternal forkedPath = this.fork();
        if (forkedPath != null) {
            forkedPath.callInitialize(this.pathExplorer, this);
        }
        return forkedPath;
    }

    final List<BranchWalkerInternal> getPathPredecessors() {
        return this.pathPredecessors;
    }

    final List<BranchWalkerInternal> getPathSuccessors() {
        return this.pathSuccessors;
    }

    public final GraphExplorerInternal getExplorer() {
        return this.pathExplorer;
    }

    public final GraphVisitorInternal getGraphVisitor() {
        return this.getExplorer().getGraphVisitorInternal();
    }

    public final ControlFlowElement getContainer() {
        return this.getGraphVisitor().getCurrentContainer();
    }

    public final TraverseDirection getDirection() {
        return this.getGraphVisitor().getDirection();
    }

    public final int getNumber() {
        return this.branchNumber;
    }

    public final void pass() {
        this.pathExplorer.passedBranches.add(this);
        if (this.pathExplorer.quantor == GraphExplorerInternal.Quantor.AtLeastOneBranch) {
            this.pathExplorer.deactivateAll();
        } else {
            this.deactivate();
        }
    }

    public final void fail() {
        this.pathExplorer.failedBranchs.add(this);
        if (this.pathExplorer.quantor == GraphExplorerInternal.Quantor.ForAllBranches) {
            this.pathExplorer.deactivateAll();
        } else {
            this.deactivate();
        }
    }

    public final void deactivate() {
        this.pathExplorer.activeBranches.remove(this);
        this.terminate();
        this.pathExplorer.checkExplorerDeactivation();
    }

    public final boolean isActive() {
        return this.pathExplorer.activeBranches.contains(this);
    }

    public final boolean isDeadCodeNode() {
        return this.isDeadCodeNode;
    }

    public final boolean isDeadCodeBranch() {
        return this.isDeadCodeBranch;
    }

    public final boolean isFirstDead() {
        boolean isFirstDead = this.isDeadCodeBranch();
        return isFirstDead &= !this.pathPredecessors.isEmpty() && !this.pathPredecessors.getFirst().isDeadCodeBranch();
    }

    public String toString() {
        return String.valueOf(this.isDeadCodeBranch ? "b" : "B") + this.branchNumber;
    }
}

