/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc.lookup;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.jsdoc.lookup.CommentCandidate;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.utils.nodemodel.CommentInfo;
import org.eclipse.n4js.utils.nodemodel.HiddenLeafAccess;
import org.eclipse.n4js.utils.nodemodel.HiddenLeafs;
import org.eclipse.n4js.utils.nodemodel.LeafInfo;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class DocCommentLookup {
    @Inject
    private HiddenLeafAccess hla;
    @Inject
    private N4JSGrammarAccess grammarAccess;

    public CommentCandidate findJSDocComment(EObject eObject, boolean considerDoubleStar) throws InstantiationException {
        if (eObject == null) {
            return null;
        }
        List<INode> comments = this.findMultiLineComments(eObject);
        if (comments == null || comments.isEmpty()) {
            return null;
        }
        if (considerDoubleStar) {
            return this.pickCommentConsiderDoubleStar(comments);
        }
        return this.pickCommentNoDoubleStar(comments);
    }

    protected List<INode> findMultiLineComments(EObject eObject) {
        ICompositeNode elementNode = NodeModelUtils.findActualNodeFor((EObject)eObject);
        HiddenLeafs hLeafs = this.hla.getHiddenLeafsBefore((INode)elementNode);
        if (!hLeafs.containsComment()) {
            return null;
        }
        List leafs = hLeafs.getLeafs();
        ArrayList<INode> comments = new ArrayList<INode>();
        TerminalRule SL = this.grammarAccess.getSL_COMMENTRule();
        for (LeafInfo li : leafs) {
            ILeafNode commentNode;
            EObject ge;
            if (!(li instanceof CommentInfo) || (ge = (commentNode = li.getNode()).getGrammarElement()) == SL) continue;
            comments.add((INode)commentNode);
        }
        return comments;
    }

    protected CommentCandidate pickCommentNoDoubleStar(List<INode> comments) throws InstantiationException {
        ListIterator<INode> iter = comments.listIterator(comments.size());
        String candidateTextString = null;
        while (iter.hasPrevious()) {
            candidateTextString = iter.previous().getText();
            if (candidateTextString.startsWith("/**")) continue;
            return new CommentCandidate(candidateTextString);
        }
        return null;
    }

    protected CommentCandidate pickCommentConsiderDoubleStar(List<INode> comments) throws InstantiationException {
        if (comments.size() == 1) {
            return new CommentCandidate(comments.get(0).getText());
        }
        ListIterator<INode> iter = comments.listIterator(comments.size());
        String bestCandidateString = iter.previous().getText();
        if (bestCandidateString.startsWith("/**")) {
            return new CommentCandidate(bestCandidateString);
        }
        String candidateTextString = "";
        while (iter.hasPrevious()) {
            candidateTextString = iter.previous().getText();
            if (!candidateTextString.startsWith("/**")) continue;
            bestCandidateString = candidateTextString;
            break;
        }
        return new CommentCandidate(bestCandidateString);
    }
}

