/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;

public final class ConvertProjectToFacetedFormRunnable
implements IRunnableWithProgress {
    private final IProject project;

    public static void runInProgressDialog(Shell shell, IProject project) {
        ConvertProjectToFacetedFormRunnable runnable = new ConvertProjectToFacetedFormRunnable(project);
        try {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            FacetUiPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    public ConvertProjectToFacetedFormRunnable(IProject project) {
        this.project = project;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(Resources.taskConvertingProject, 1000);
        try {
            try {
                SubProgressMonitor createProgressMonitor = new SubProgressMonitor(monitor, 100);
                IFacetedProject fpj = ProjectFacetsManager.create((IProject)this.project, (boolean)true, (IProgressMonitor)createProgressMonitor);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                monitor.setTaskName(Resources.taskDetectingTechnologies);
                SubProgressMonitor detectProgressMonitor = new SubProgressMonitor(monitor, 800);
                IFacetedProjectWorkingCopy fpjwc = fpj.createWorkingCopy();
                fpjwc.detect((IProgressMonitor)detectProgressMonitor);
                monitor.setTaskName(Resources.taskInstallingFacets);
                SubProgressMonitor commitChangesProgressMonitor = new SubProgressMonitor(monitor, 100);
                fpjwc.commitChanges((IProgressMonitor)commitChangesProgressMonitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private static final class Resources
    extends NLS {
        public static String taskConvertingProject;
        public static String taskDetectingTechnologies;
        public static String taskInstallingFacets;

        static {
            Resources.initializeMessages((String)ConvertProjectToFacetedFormRunnable.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

