/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xpect.XjmContribution;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.registry.ILanguageInfo;
import org.eclipse.xpect.setup.XpectGuiceModule;
import org.eclipse.xpect.util.EnvironmentUtil;
import org.eclipse.xpect.util.URIDelegationHandler;

public interface IXtInjectorProvider {
    public static final IXtInjectorProvider INSTANCE = EcorePlugin.IS_ECLIPSE_RUNNING ? new Delegate() : new RuntimeXtInjectorProvider();

    public Injector getInjector(XpectJavaModel var1, URI var2);

    public static class Delegate
    implements IXtInjectorProvider {
        private IXtInjectorProvider delegate;

        @Override
        public Injector getInjector(XpectJavaModel javaModel, URI uri) {
            return this.delegate.getInjector(javaModel, uri);
        }

        public void setDelegate(IXtInjectorProvider delegate) {
            this.delegate = delegate;
        }
    }

    public static class RuntimeXtInjectorProvider
    implements IXtInjectorProvider {
        protected void collectBuiltinModules(List<Class<? extends Module>> moduleClasses) {
        }

        protected void collectSetupModules(List<Class<? extends Module>> moduleClasses, XpectJavaModel javaModel) {
            if (javaModel != null) {
                Iterable<XjmContribution> contributions = javaModel.getContributions(XpectGuiceModule.class, EnvironmentUtil.ENVIRONMENT);
                for (XjmContribution contribution : contributions) {
                    Class<?> javaClass;
                    if (!contribution.isActive() || !Module.class.isAssignableFrom(javaClass = contribution.getJavaClass())) continue;
                    moduleClasses.add(javaClass);
                }
            }
        }

        @Override
        public Injector getInjector(XpectJavaModel javaModel, URI uri) {
            String ext = new URIDelegationHandler().getOriginalFileExtension(uri.lastSegment());
            ILanguageInfo info = ILanguageInfo.Registry.INSTANCE.getLanguageByFileExtension(ext);
            if (info == null) {
                return null;
            }
            ArrayList moduleClasses = Lists.newArrayList();
            this.collectBuiltinModules(moduleClasses);
            this.collectSetupModules(moduleClasses, javaModel);
            Injector injector = info.getInjector(moduleClasses);
            return injector;
        }
    }
}

