/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.ui.resource.IResourceDescriptionPersisterContribution;
import org.eclipse.n4js.utils.StatusHelper;

public class N4JSExternalLibraryResourceDescriptionsPersisterContribution
implements IResourceDescriptionPersisterContribution {
    private static final Logger LOGGER = Logger.getLogger(N4JSExternalLibraryResourceDescriptionsPersisterContribution.class);
    @Inject
    private LibraryManager libraryManager;
    @Inject
    private StatusHelper statusHelper;

    @Override
    public void scheduleRecoveryBuild() {
        Job job = new Job("Register all npms"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor progress) throws CoreException {
                            try {
                                N4JSExternalLibraryResourceDescriptionsPersisterContribution.this.libraryManager.registerAllExternalProjects(progress);
                            }
                            catch (Exception e) {
                                throw new CoreException(N4JSExternalLibraryResourceDescriptionsPersisterContribution.this.statusHelper.createError((Throwable)e));
                            }
                        }
                    };
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    if (workspace.isTreeLocked()) {
                        runnable.run(monitor);
                    } else {
                        workspace.run(runnable, null, 1, monitor);
                    }
                }
                catch (CoreException e) {
                    String message = "Unexpected error occurred while initializing N4JS Built-ins.";
                    LOGGER.error((Object)"Unexpected error occurred while initializing N4JS Built-ins.", (Throwable)e);
                    return N4JSExternalLibraryResourceDescriptionsPersisterContribution.this.statusHelper.createError("Unexpected error occurred while initializing N4JS Built-ins.", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setSystem(false);
        job.schedule();
    }
}

