/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.dataflow.Assumption;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowVisitor;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowVisitorHost;
import org.eclipse.n4js.flowgraphs.dataflow.EffectInfo;
import org.eclipse.n4js.flowgraphs.dataflow.guards.Guard;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardStructure;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardStructureFactory;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.ControlFlowElement;

class DataFlowBranchWalker
extends BranchWalkerInternal {
    final Map<Object, Assumption> assumptions = new HashMap<Object, Assumption>();
    private int forkCount = 0;

    DataFlowBranchWalker() {
    }

    @Override
    protected BranchWalkerInternal fork() {
        DataFlowBranchWalker dfb = new DataFlowBranchWalker();
        for (Map.Entry<Object, Assumption> entry : this.assumptions.entrySet()) {
            Object key = entry.getKey();
            Assumption ass = entry.getValue();
            if (ass.isOpen() && this.forkCount > 0) {
                ass = ass.copy();
            }
            dfb.assumptions.put(key, ass);
        }
        ++this.forkCount;
        return dfb;
    }

    @Override
    protected void visit(Node node) {
        if (node.effectInfos.isEmpty()) {
            return;
        }
        ControlFlowElement cfe = node.getControlFlowElement();
        Multimap<Symbol, Object> assgns = this.getDataFlowVisitorHost().getAssignmentRelationFactory().findAssignments(cfe);
        HashSet<Symbol> handledDataFlowSymbols = new HashSet<Symbol>();
        for (Symbol lhs : assgns.keySet()) {
            Collection rhss;
            boolean handledDataFlow = this.handleDataflow(lhs, rhss = assgns.get((Object)lhs));
            if (!handledDataFlow) continue;
            handledDataFlowSymbols.add(lhs);
        }
        for (EffectInfo effect : node.effectInfos) {
            this.handleVisitEffect(cfe, effect, handledDataFlowSymbols);
        }
    }

    @Override
    protected void visit(Node lastVisitNodes, Node end, ControlFlowEdge edge) {
        GuardStructure guardStructure = GuardStructureFactory.create(edge);
        if (guardStructure == null) {
            return;
        }
        guardStructure.initSymbols(this.getSymbolFactory());
        for (Assumption ass : this.assumptions.values()) {
            if (!ass.isOpen()) continue;
            for (Symbol alias : ass.aliases) {
                if (!guardStructure.hasGuards(alias)) continue;
                Collection<Guard> guards = guardStructure.getGuards(alias);
                for (Guard guard : guards) {
                    ass.callHoldsOnGuards(guard);
                }
            }
        }
        for (DataFlowVisitor dfv : this.getDataFlowVisitorHost().dfVisitors) {
            for (Guard guard : guardStructure.allGuards()) {
                dfv.visitGuard(guard);
            }
        }
    }

    @Override
    protected void terminate() {
        Iterator<Assumption> assIter = this.assumptions.values().iterator();
        while (assIter.hasNext()) {
            Assumption ass = assIter.next();
            ass.checkAndFinalize();
            if (!ass.isDone()) continue;
            assIter.remove();
        }
    }

    @Override
    protected void switchedToDeadBranch() {
        for (Assumption ass : this.assumptions.values()) {
            ass.remove();
        }
        this.assumptions.clear();
    }

    private DataFlowVisitorHost getDataFlowVisitorHost() {
        return (DataFlowVisitorHost)this.getGraphVisitor();
    }

    private SymbolFactory getSymbolFactory() {
        return this.getDataFlowVisitorHost().getSymbolFactory();
    }

    private boolean handleDataflow(Symbol lhs, Collection<Object> rhss) {
        for (Assumption ass : this.assumptions.values()) {
            this.callHoldOnDataflowOnAliases(ass, lhs, rhss);
        }
        return true;
    }

    private void handleVisitEffect(ControlFlowElement cfe, EffectInfo effect, Set<Symbol> handledDataFlowSymbols) {
        this.callHoldsOnEffect(cfe, effect);
        for (DataFlowVisitor dfv : this.getDataFlowVisitorHost().dfVisitors) {
            dfv.visitEffect(effect, cfe);
            if (handledDataFlowSymbols.contains(effect.symbol)) continue;
            Collection<Assumption> newAssumptions = dfv.moveNewAssumptions();
            for (Assumption ass : newAssumptions) {
                this.assumptions.put(ass.getKey(), ass);
            }
        }
    }

    private void callHoldsOnEffect(ControlFlowElement cfe, EffectInfo effect) {
        for (Assumption ass : this.assumptions.values()) {
            if (!ass.isApplicable(effect.symbol)) continue;
            ass.callHoldsOnEffect(effect, cfe);
        }
    }

    private boolean callHoldOnDataflowOnAliases(Assumption ass, Symbol lhs, Collection<Object> rhss) {
        if (ass.isApplicable(lhs)) {
            ass.callHoldsOnDataflow(lhs, rhss);
            return true;
        }
        return false;
    }
}

