/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpSessionAdaptor;
import org.eclipse.equinox.http.servlet.internal.util.EventListeners;
import org.eclipse.equinox.http.servlet.session.HttpSessionInvalidator;

public class HttpSessionTracker
implements HttpSessionInvalidator {
    private final ConcurrentMap<String, Set<HttpSessionAdaptor>> httpSessionAdaptorsMap = new ConcurrentHashMap<String, Set<HttpSessionAdaptor>>();
    private final HttpServiceRuntimeImpl httpServiceRuntime;

    public HttpSessionTracker(HttpServiceRuntimeImpl httpServiceRuntime) {
        this.httpServiceRuntime = httpServiceRuntime;
    }

    @Override
    public void invalidate(String sessionId, boolean invalidateParent) {
        Set httpSessionAdaptors = (Set)this.httpSessionAdaptorsMap.remove(sessionId);
        if (httpSessionAdaptors == null) {
            return;
        }
        for (HttpSessionAdaptor httpSessionAdaptor : httpSessionAdaptors) {
            ContextController contextController = httpSessionAdaptor.getController();
            EventListeners eventListeners = contextController.getEventListeners();
            List<HttpSessionListener> httpSessionListeners = eventListeners.get(HttpSessionListener.class);
            if (!httpSessionListeners.isEmpty()) {
                HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)httpSessionAdaptor);
                for (HttpSessionListener listener : httpSessionListeners) {
                    try {
                        listener.sessionDestroyed(httpSessionEvent);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            List<HttpSessionAttributeListener> httpSessionAttributeListeners = eventListeners.get(HttpSessionAttributeListener.class);
            if (!httpSessionListeners.isEmpty()) {
                Enumeration<String> enumeration = httpSessionAdaptor.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)httpSessionAdaptor, enumeration.nextElement());
                    for (HttpSessionAttributeListener httpSessionAttributeListener : httpSessionAttributeListeners) {
                        httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
                    }
                }
            }
            contextController.removeActiveSession(httpSessionAdaptor.getSession());
            if (!invalidateParent) continue;
            try {
                httpSessionAdaptor.getSession().invalidate();
            }
            catch (IllegalStateException ise) {
                this.httpServiceRuntime.log("Session was already invalidated!", ise);
            }
        }
    }

    public void addHttpSessionAdaptor(String sessionId, HttpSessionAdaptor httpSessionAdaptor) {
        Set previousHttpSessionAdaptors;
        Set httpSessionAdaptors = (Set)this.httpSessionAdaptorsMap.get(sessionId);
        if (httpSessionAdaptors == null && (previousHttpSessionAdaptors = this.httpSessionAdaptorsMap.putIfAbsent(sessionId, httpSessionAdaptors = Collections.newSetFromMap(new ConcurrentHashMap()))) != null) {
            httpSessionAdaptors = previousHttpSessionAdaptors;
        }
        httpSessionAdaptors.add(httpSessionAdaptor);
    }

    public void clear() {
        if (!this.httpSessionAdaptorsMap.isEmpty()) {
            this.httpServiceRuntime.log("There are HttpSessionAdaptors left over. There might be a context or session leak!");
        }
    }

    public boolean removeHttpSessionAdaptor(String sessionId, HttpSessionAdaptor httpSessionAdaptor) {
        Set httpSessionAdaptors = (Set)this.httpSessionAdaptorsMap.get(sessionId);
        if (httpSessionAdaptors == null) {
            return false;
        }
        try {
            boolean bl = httpSessionAdaptors.remove(httpSessionAdaptor);
            return bl;
        }
        finally {
            if (httpSessionAdaptors.isEmpty()) {
                this.httpSessionAdaptorsMap.remove(sessionId, httpSessionAdaptors);
            }
        }
    }
}

