/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.filters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.RSEPersistableObject;
import org.eclipse.rse.core.references.IRSEBaseReferencingObject;
import org.eclipse.rse.internal.core.filters.SystemFilterPool;
import org.eclipse.rse.logging.Logger;

public class SystemFilterPoolManager
extends RSEPersistableObject
implements ISystemFilterPoolManager {
    private ISystemFilterPoolManagerProvider caller = null;
    private Object poolMgrData;
    private boolean initialized = false;
    private boolean suspendCallbacks = false;
    private boolean suspendSave = false;
    private Logger logger = null;
    private ISystemProfile _profile;
    public static boolean debug = true;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final boolean SUPPORTS_NESTED_FILTERS_EDEFAULT = false;
    protected boolean supportsNestedFilters = false;
    protected static final boolean STRINGS_CASE_SENSITIVE_EDEFAULT = false;
    protected boolean stringsCaseSensitive = false;
    protected static final boolean SUPPORTS_DUPLICATE_FILTER_STRINGS_EDEFAULT = false;
    protected boolean supportsDuplicateFilterStrings = false;
    protected boolean supportsDuplicateFilterStringsESet = false;
    protected static final boolean SINGLE_FILTER_STRING_ONLY_EDEFAULT = false;
    protected boolean singleFilterStringOnly = false;
    protected List pools = new ArrayList(3);

    private SystemFilterPoolManager(ISystemProfile profile) {
        this._profile = profile;
    }

    public ISystemProfile getSystemProfile() {
        return this._profile;
    }

    public static ISystemFilterPoolManager createSystemFilterPoolManager(ISystemProfile profile, Logger logger, ISystemFilterPoolManagerProvider caller, String name, boolean allowNestedFilters) {
        SystemFilterPoolManager mgr = new SystemFilterPoolManager(profile);
        mgr.initialize(logger, caller, name, allowNestedFilters);
        return mgr;
    }

    public void initialize(Logger logger, ISystemFilterPoolManagerProvider caller, String name, boolean allowNestedFilters) {
        if (!this.initialized) {
            this.initialize(logger, caller, name);
        }
        this.setSupportsNestedFilters(allowNestedFilters);
    }

    public void initialize(Logger logger, ISystemFilterPoolManagerProvider caller, String name) {
        this.logger = logger;
        this.setProvider(caller);
        this.setName(name);
        this.setFilterPoolManager();
        this.initialized = true;
    }

    public ISystemFilterPoolManagerProvider getProvider() {
        return this.caller;
    }

    public void setProvider(ISystemFilterPoolManagerProvider caller) {
        this.caller = caller;
    }

    public void setName(String newName) {
        if (this.name == null && newName != null || !this.name.equals(newName)) {
            this.name = newName;
            this.setDirty(true);
        }
    }

    public boolean supportsNestedFilters() {
        return this.isSupportsNestedFilters();
    }

    public boolean supportsDuplicateFilterStrings() {
        return this.isSupportsDuplicateFilterStrings();
    }

    public void setSupportsNestedFilters(boolean newSupportsNestedFilters) {
        this.setSupportsNestedFiltersGen(newSupportsNestedFilters);
        ISystemFilterPool[] pools = this.getSystemFilterPools();
        int idx = 0;
        while (idx < pools.length) {
            pools[idx].setSupportsNestedFilters(newSupportsNestedFilters);
            ++idx;
        }
    }

    public void setSupportsDuplicateFilterStrings(boolean newSupportsDuplicateFilterStrings) {
        this.setSupportsDuplicateFilterStringsGen(newSupportsDuplicateFilterStrings);
        ISystemFilterPool[] pools = this.getSystemFilterPools();
        int idx = 0;
        while (idx < pools.length) {
            pools[idx].setSupportsDuplicateFilterStrings(newSupportsDuplicateFilterStrings);
            ++idx;
        }
    }

    private void setSupportsDuplicateFilterStringsGen(boolean newSupportsDuplicateFilterStrings) {
        this.supportsDuplicateFilterStrings = newSupportsDuplicateFilterStrings;
        this.supportsDuplicateFilterStringsESet = true;
    }

    public boolean isStringsCaseSensitive() {
        return this.stringsCaseSensitive;
    }

    public boolean areStringsCaseSensitive() {
        return this.isStringsCaseSensitive();
    }

    public void setStringsCaseSensitive(boolean newStringsCaseSensitive) {
        this.setStringsCaseSensitiveGen(newStringsCaseSensitive);
        ISystemFilterPool[] pools = this.getSystemFilterPools();
        int idx = 0;
        while (idx < pools.length) {
            pools[idx].setStringsCaseSensitive(newStringsCaseSensitive);
            ++idx;
        }
    }

    private void setStringsCaseSensitiveGen(boolean newStringsCaseSensitive) {
        this.stringsCaseSensitive = newStringsCaseSensitive;
    }

    protected void setFilterPoolManager() {
        ISystemFilterPool[] pools = this.getSystemFilterPools();
        int idx = 0;
        while (idx < pools.length) {
            pools[idx].setSystemFilterPoolManager(this);
            ++idx;
        }
    }

    public void setSystemFilterPoolManagerData(Object data) {
        this.poolMgrData = data;
    }

    public Object getSystemFilterPoolManagerData() {
        return this.poolMgrData;
    }

    public ISystemFilterPool[] getSystemFilterPools() {
        ISystemFilterPool[] result = new ISystemFilterPool[this.pools.size()];
        this.pools.toArray(result);
        return result;
    }

    public String[] getSystemFilterPoolNames() {
        ISystemFilterPool[] pools = this.getSystemFilterPools();
        String[] names = new String[pools.length];
        int i = 0;
        while (i < pools.length) {
            ISystemFilterPool pool = pools[i];
            names[i] = pool.getName();
            ++i;
        }
        return names;
    }

    public ISystemFilterPool createSystemFilterPool(String poolName, boolean isDeletable) throws Exception {
        SystemFilterPool pool = null;
        if (this.getSystemFilterPool(poolName = poolName.trim()) == null) {
            pool = new SystemFilterPool(poolName, this.supportsNestedFilters(), isDeletable);
            pool.setSystemFilterPoolManager(this);
            pool.setStringsCaseSensitive(this.areStringsCaseSensitive());
            pool.setSupportsDuplicateFilterStrings(this.isSetSupportsDuplicateFilterStrings() && this.supportsDuplicateFilterStrings());
            this.pools.add(pool);
            this.commit(pool);
            if (this.caller != null && !this.suspendCallbacks) {
                this.caller.filterEventFilterPoolCreated(pool);
            }
        }
        return pool;
    }

    public void deleteSystemFilterPool(ISystemFilterPool pool) throws Exception {
        IRSEBaseReferencingObject[] refs = pool.getReferencingObjects();
        if (refs != null) {
            int idx = 0;
            while (idx < refs.length) {
                ISystemFilterPoolReference fpRef;
                ISystemFilterPoolReferenceManager fprMgr;
                if (refs[idx] instanceof ISystemFilterPoolReference && (fprMgr = (fpRef = (ISystemFilterPoolReference)refs[idx]).getFilterPoolReferenceManager()) != null) {
                    fprMgr.removeSystemFilterPoolReference(fpRef, false);
                }
                ++idx;
            }
        }
        this.pools.remove(pool);
        this._profile.setDirty(true);
        this._profile.commit();
        this.getProvider().filterEventFilterPoolDeleted(pool);
    }

    public void deleteAllSystemFilterPools() {
        ISystemFilterPool[] allPools = this.getSystemFilterPools();
        int idx = 0;
        while (idx < allPools.length) {
            String name = allPools[idx].getName();
            try {
                this.deleteSystemFilterPool(allPools[idx]);
            }
            catch (Exception exc) {
                this.logError("Exception deleting filter pool " + name + " from mgr " + this.getName(), exc);
            }
            ++idx;
        }
    }

    public boolean preTestRenameFilterPool(ISystemFilterPool pool) throws Exception {
        boolean ok = true;
        return ok;
    }

    public void renameSystemFilterPool(ISystemFilterPool pool, String newName) throws Exception {
        String oldName = pool.getName();
        pool.setName(newName);
        IRSEBaseReferencingObject[] refs = pool.getReferencingObjects();
        if (refs != null) {
            int idx = 0;
            while (idx < refs.length) {
                IRSEBaseReferencingObject ref = refs[idx];
                if (ref instanceof ISystemFilterPoolReference) {
                    ISystemFilterPoolReference fpRef = (ISystemFilterPoolReference)ref;
                    ISystemFilterPoolReferenceManager fprMgr = fpRef.getFilterPoolReferenceManager();
                    fprMgr.renameReferenceToSystemFilterPool(pool);
                }
                ++idx;
            }
        }
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFilterPoolRenamed(pool, oldName);
        }
    }

    public ISystemFilterPool copySystemFilterPool(ISystemFilterPoolManager targetMgr, ISystemFilterPool oldPool, String newName) throws Exception {
        ISystemFilterPool newPool = targetMgr.createSystemFilterPool(newName, oldPool.isDeletable());
        oldPool.cloneSystemFilterPool(newPool);
        this.commit(newPool);
        return newPool;
    }

    /*
     * Unable to fully structure code
     */
    public ISystemFilterPool moveSystemFilterPool(ISystemFilterPoolManager targetMgr, ISystemFilterPool oldPool, String newName) throws Exception {
        block7: {
            block8: {
                newPool = this.copySystemFilterPool(targetMgr, oldPool, newName);
                refs = oldPool.getReferencingObjects();
                if (refs != null) {
                    idx = 0;
                    while (idx < refs.length) {
                        if (refs[idx] instanceof ISystemFilterPoolReference) {
                            fpRef = (ISystemFilterPoolReference)refs[idx];
                            fprMgr = fpRef.getFilterPoolReferenceManager();
                            fprMgr.resetSystemFilterPoolReference(fpRef, newPool);
                        }
                        ++idx;
                    }
                }
                try {
                    this.deleteSystemFilterPool(oldPool);
                    break block7;
                }
                catch (Exception exc) {
                    if (refs == null) break block8;
                    idx = 0;
                    ** while (idx < refs.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (refs[idx] instanceof ISystemFilterPoolReference) {
                        fpRef = (ISystemFilterPoolReference)refs[idx];
                        fprMgr = fpRef.getFilterPoolReferenceManager();
                        fprMgr.resetSystemFilterPoolReference(fpRef, oldPool);
                    }
                    ++idx;
                    continue;
                }
            }
            targetMgr.deleteSystemFilterPool(newPool);
            throw exc;
        }
        return newPool;
    }

    public void copySystemFilterPools(ISystemFilterPoolManager targetMgr) throws Exception {
        targetMgr.setStringsCaseSensitive(this.areStringsCaseSensitive());
        ISystemFilterPool[] pools = this.getSystemFilterPools();
        if (pools != null && pools.length > 0) {
            targetMgr.suspendCallbacks(true);
            int idx = 0;
            while (idx < pools.length) {
                ISystemFilterPool pool = pools[idx];
                this.copySystemFilterPool(targetMgr, pool, pool.getName());
                ++idx;
            }
            targetMgr.suspendCallbacks(false);
        }
    }

    public ISystemFilterPool getSystemFilterPool(String name) {
        ISystemFilterPool pool = null;
        ISystemFilterPool[] pools = this.getSystemFilterPools();
        if (pools != null) {
            int idx = 0;
            while (idx < pools.length && pool == null) {
                if (pools[idx].getName().equals(name)) {
                    pool = pools[idx];
                }
                ++idx;
            }
        }
        return pool;
    }

    public ISystemFilterPool getFirstDefaultSystemFilterPool() {
        ISystemFilterPool pool = null;
        ISystemFilterPool[] pools = this.getSystemFilterPools();
        int idx = 0;
        while (pool == null && idx < pools.length) {
            if (pools[idx].isDefault()) {
                pool = pools[idx];
            }
            ++idx;
        }
        return pool;
    }

    public ISystemFilter createSystemFilter(ISystemFilterContainer parent, String aliasName, List filterStrings, String type, boolean promptable) throws Exception {
        String[] filterStringsArray = new String[filterStrings.size()];
        filterStrings.toArray(filterStringsArray);
        ISystemFilter result = this.doCreateSystemFilter(parent, aliasName, filterStringsArray, type, promptable);
        return result;
    }

    public ISystemFilter createSystemFilter(ISystemFilterContainer parent, String aliasName, List filterStrings, String type) throws Exception {
        ISystemFilter result = this.createSystemFilter(parent, aliasName, filterStrings, type, false);
        return result;
    }

    public ISystemFilter createSystemFilter(ISystemFilterContainer parent, String aliasName, List filterStrings) throws Exception {
        ISystemFilter result = this.createSystemFilter(parent, aliasName, filterStrings, null, false);
        return result;
    }

    public ISystemFilter createSystemFilter(ISystemFilterContainer parent, String aliasName, String[] filterStrings) throws Exception {
        ISystemFilter newFilter = this.doCreateSystemFilter(parent, aliasName, filterStrings, null, false);
        return newFilter;
    }

    public ISystemFilter createSystemFilter(ISystemFilterContainer parent, String aliasName, String[] filterStrings, String type) throws Exception {
        ISystemFilter newFilter = this.doCreateSystemFilter(parent, aliasName, filterStrings, type, false);
        return newFilter;
    }

    public ISystemFilter createSystemFilter(ISystemFilterContainer parent, String aliasName, String[] filterStrings, String type, boolean promptable) throws Exception {
        ISystemFilter newFilter = this.doCreateSystemFilter(parent, aliasName, filterStrings, type, promptable);
        return newFilter;
    }

    private ISystemFilter doCreateSystemFilter(ISystemFilterContainer parent, String name, String[] filterStrings, String type, boolean promptable) {
        ISystemFilterPool parentPool = null;
        parentPool = parent instanceof ISystemFilterPool ? (ISystemFilterPool)parent : ((ISystemFilter)parent).getParentFilterPool();
        ISystemFilter newFilter = parentPool.createSystemFilter(name, filterStrings);
        newFilter.setType(type);
        newFilter.setPromptable(promptable);
        if (!this.suspendSave) {
            this.commit(parentPool);
        }
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFilterCreated(newFilter);
        }
        return newFilter;
    }

    public boolean deleteSystemFilter(ISystemFilter filter) throws Exception {
        boolean ok = true;
        ISystemFilterContainer parent = filter.getParentFilterContainer();
        parent.deleteSystemFilter(filter);
        this.commit(filter.getParentFilterPool());
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFilterDeleted(filter);
        }
        return ok;
    }

    public void renameSystemFilter(ISystemFilter filter, String newName) throws Exception {
        ISystemFilterContainer parent = filter.getParentFilterContainer();
        String oldName = filter.getName();
        parent.renameSystemFilter(filter, newName);
        try {
            this.commit(filter.getParentFilterPool());
        }
        catch (Exception exc) {
            parent.renameSystemFilter(filter, oldName);
            throw exc;
        }
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFilterRenamed(filter, oldName);
        }
    }

    public void updateSystemFilter(ISystemFilter filter, String newName, String[] strings) throws Exception {
        boolean rename;
        ISystemFilterContainer parent = filter.getParentFilterContainer();
        String oldName = filter.getName();
        boolean bl = rename = !oldName.equals(newName);
        if (rename) {
            this.renameSystemFilter(filter, newName);
        }
        parent.updateSystemFilter(filter, newName, strings);
        ISystemFilterPool parentPool = filter.getParentFilterPool();
        this.commit(parentPool);
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFilterUpdated(filter);
        }
    }

    public void setSystemFilterType(ISystemFilter filter, String newType) throws Exception {
        filter.setType(newType);
        this.commit(filter.getParentFilterPool());
    }

    public ISystemFilter copySystemFilter(ISystemFilterPool targetPool, ISystemFilter oldFilter, String newName) throws Exception {
        ISystemFilterPoolManager targetMgr = targetPool.getSystemFilterPoolManager();
        ISystemFilterPool oldPool = oldFilter.getParentFilterPool();
        targetMgr.suspendCallbacks(true);
        ISystemFilter newFilter = oldPool.copySystemFilter(targetPool, oldFilter, newName);
        this.commit(targetPool);
        targetMgr.suspendCallbacks(false);
        targetMgr.getProvider().filterEventFilterCreated(newFilter);
        return newFilter;
    }

    public ISystemFilter moveSystemFilter(ISystemFilterPool targetPool, ISystemFilter oldFilter, String newName) throws Exception {
        ISystemFilter newFilter = this.copySystemFilter(targetPool, oldFilter, newName);
        if (newFilter != null) {
            this.deleteSystemFilter(oldFilter);
        }
        return newFilter;
    }

    public int getSystemFilterPosition(ISystemFilter filter) {
        ISystemFilterContainer container = filter.getParentFilterContainer();
        int position = -1;
        boolean match = false;
        ISystemFilter[] filters = container.getSystemFilters();
        int idx = 0;
        while (!match && idx < filters.length) {
            if (filters[idx].getName().equals(filter.getName())) {
                match = true;
                position = idx;
            }
            ++idx;
        }
        return position;
    }

    public void moveSystemFilters(ISystemFilter[] filters, int delta) throws Exception {
        int[] oldPositions = new int[filters.length];
        int idx = 0;
        while (idx < filters.length) {
            oldPositions[idx] = this.getSystemFilterPosition(filters[idx]);
            ++idx;
        }
        if (delta > 0) {
            idx = filters.length - 1;
            while (idx >= 0) {
                this.moveFilter(filters[idx], oldPositions[idx] + delta);
                --idx;
            }
        } else {
            idx = 0;
            while (idx < filters.length) {
                this.moveFilter(filters[idx], oldPositions[idx] + delta);
                ++idx;
            }
        }
        this.commit(filters[0].getParentFilterPool());
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFiltersRePositioned(filters, delta);
        }
    }

    private void moveFilter(ISystemFilter filter, int newPos) {
        ISystemFilterContainer container = filter.getParentFilterContainer();
        container.moveSystemFilter(newPos, filter);
    }

    public void orderSystemFilters(ISystemFilterPool pool, String[] names) throws Exception {
        pool.orderSystemFilters(names);
        this.commit(pool);
    }

    public ISystemFilterString addSystemFilterString(ISystemFilter filter, String newString) throws Exception {
        ISystemFilterString newFilterString = filter.addFilterString(newString);
        ISystemFilterPool parentPool = filter.getParentFilterPool();
        this.commit(parentPool);
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFilterStringCreated(newFilterString);
        }
        return newFilterString;
    }

    public ISystemFilterString addSystemFilterString(ISystemFilter filter, String newString, int position) throws Exception {
        ISystemFilterString newFilterString = filter.addFilterString(newString, position);
        ISystemFilterPool parentPool = filter.getParentFilterPool();
        this.commit(parentPool);
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFilterStringCreated(newFilterString);
        }
        return newFilterString;
    }

    public boolean removeSystemFilterString(ISystemFilter filter, String oldString) throws Exception {
        ISystemFilterString oldFilterString = filter.removeFilterString(oldString);
        if (oldFilterString == null) {
            return false;
        }
        ISystemFilterPool parentPool = filter.getParentFilterPool();
        this.commit(parentPool);
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFilterStringDeleted(oldFilterString);
        }
        return true;
    }

    public boolean removeSystemFilterString(ISystemFilter filter, ISystemFilterString filterString) throws Exception {
        boolean ok = filter.removeFilterString(filterString);
        if (!ok) {
            return false;
        }
        ISystemFilterPool parentPool = filter.getParentFilterPool();
        this.commit(parentPool);
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFilterStringDeleted(filterString);
        }
        return ok;
    }

    public boolean removeSystemFilterString(ISystemFilter filter, int position) throws Exception {
        ISystemFilterString oldFilterString = filter.removeFilterString(position);
        if (oldFilterString == null) {
            return false;
        }
        ISystemFilterPool parentPool = filter.getParentFilterPool();
        this.commit(parentPool);
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFilterStringDeleted(oldFilterString);
        }
        return true;
    }

    public void updateSystemFilterString(ISystemFilterString filterString, String newValue) throws Exception {
        if (newValue.equals(filterString.getString())) {
            return;
        }
        ISystemFilter filter = filterString.getParentSystemFilter();
        filter.updateFilterString(filterString, newValue);
        ISystemFilterPool parentPool = filter.getParentFilterPool();
        this.commit(parentPool);
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFilterStringUpdated(filterString);
        }
    }

    public int getSystemFilterStringPosition(ISystemFilterString filterString) {
        ISystemFilter filter = filterString.getParentSystemFilter();
        int position = -1;
        boolean match = false;
        ISystemFilterString[] filterStrings = filter.getSystemFilterStrings();
        String matchString = filterString.getString();
        int idx = 0;
        while (!match && idx < filterStrings.length) {
            if (filterStrings[idx].getString().equals(matchString)) {
                match = true;
                position = idx;
            }
            ++idx;
        }
        return position;
    }

    public ISystemFilterString copySystemFilterString(ISystemFilter targetFilter, ISystemFilterString oldFilterString) throws Exception {
        ISystemFilterPool targetPool = targetFilter.getParentFilterPool();
        ISystemFilterPoolManager targetMgr = targetPool.getSystemFilterPoolManager();
        ISystemFilter oldFilter = oldFilterString.getParentSystemFilter();
        targetMgr.suspendCallbacks(true);
        ISystemFilterString newFilterString = oldFilter.copySystemFilterString(targetFilter, oldFilterString);
        this.commit(targetPool);
        targetMgr.suspendCallbacks(false);
        targetMgr.getProvider().filterEventFilterStringCreated(newFilterString);
        return newFilterString;
    }

    public ISystemFilterString moveSystemFilterString(ISystemFilter targetFilter, ISystemFilterString oldFilterString) throws Exception {
        ISystemFilterString newString = this.copySystemFilterString(targetFilter, oldFilterString);
        if (newString != null) {
            this.removeSystemFilterString(oldFilterString.getParentSystemFilter(), oldFilterString);
        }
        return newString;
    }

    public void moveSystemFilterStrings(ISystemFilterString[] filterStrings, int delta) throws Exception {
        ISystemFilter filter = filterStrings[0].getParentSystemFilter();
        int[] oldPositions = new int[filterStrings.length];
        int idx = 0;
        while (idx < filterStrings.length) {
            oldPositions[idx] = this.getSystemFilterStringPosition(filterStrings[idx]);
            ++idx;
        }
        if (delta > 0) {
            idx = filterStrings.length - 1;
            while (idx >= 0) {
                this.moveFilterString(filter, filterStrings[idx], oldPositions[idx] + delta);
                --idx;
            }
        } else {
            idx = 0;
            while (idx < filterStrings.length) {
                this.moveFilterString(filter, filterStrings[idx], oldPositions[idx] + delta);
                ++idx;
            }
        }
        this.commit(filter.getParentFilterPool());
        if (this.caller != null && !this.suspendCallbacks) {
            this.caller.filterEventFilterStringsRePositioned(filterStrings, delta);
        }
    }

    private void moveFilterString(ISystemFilter filter, ISystemFilterString filterString, int newPos) {
        filter.moveSystemFilterString(newPos, filterString);
    }

    public void suspendCallbacks(boolean suspend) {
        this.suspendCallbacks = suspend;
    }

    public IFile getSaveFile(ISystemFilterPool pool) {
        return null;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = RSECorePlugin.getDefault().getLogger();
        }
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void logInfo(String message) {
        if (this.logger != null) {
            this.logger.logInfo(message);
        } else {
            System.out.println(String.valueOf(this.getClass().getName()) + ": INFO: " + message);
        }
    }

    public void logWarning(String message) {
        if (this.logger != null) {
            this.logger.logWarning(message);
        } else {
            System.out.println(String.valueOf(this.getClass().getName()) + ": WARNING: " + message);
        }
    }

    public void logError(String message, Throwable exception) {
        if (this.logger != null) {
            this.logger.logError(message, exception);
        } else {
            String msg = exception.getMessage();
            if (msg == null) {
                msg = exception.getClass().getName();
            }
            System.out.println(String.valueOf(this.getClass().getName()) + ": " + message + ": " + msg);
            exception.printStackTrace();
        }
    }

    public void logDebugMessage(String prefix, String message) {
        if (this.logger != null) {
            this.logger.logDebugMessage(prefix, message);
        } else {
            System.out.println(String.valueOf(this.getClass().getName()) + ": DEBUG: " + message);
        }
    }

    public void logMessage(String msg) {
        if (this.logger != null) {
            this.logger.logInfo(msg);
        } else {
            System.out.println(String.valueOf(this.getClass().getName()) + ": " + msg);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public boolean isSupportsNestedFilters() {
        return this.supportsNestedFilters;
    }

    public void setSupportsNestedFiltersGen(boolean newSupportsNestedFilters) {
        this.supportsNestedFilters = newSupportsNestedFilters;
    }

    public boolean isSupportsDuplicateFilterStrings() {
        return this.supportsDuplicateFilterStrings;
    }

    public void unsetSupportsDuplicateFilterStrings() {
        this.supportsDuplicateFilterStrings = false;
        this.supportsDuplicateFilterStringsESet = false;
    }

    public boolean isSetSupportsDuplicateFilterStrings() {
        return this.supportsDuplicateFilterStringsESet;
    }

    public boolean isSingleFilterStringOnly() {
        return this.singleFilterStringOnly;
    }

    public void setSingleFilterStringOnly(boolean newSingleFilterStringOnly) {
        boolean oldSingleFilterStringOnly = this.singleFilterStringOnly;
        if (oldSingleFilterStringOnly != newSingleFilterStringOnly) {
            this.singleFilterStringOnly = newSingleFilterStringOnly;
            this.setDirty(true);
        }
    }

    public boolean commit() {
        ISystemProfile profile = this.getSystemProfile();
        boolean result = profile.commit();
        return result;
    }

    public boolean commit(ISystemFilterPool pool) {
        pool.setDirty(true);
        boolean result = pool.commit();
        return result;
    }

    public IRSEPersistableContainer getPersistableParent() {
        return null;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        return IRSEPersistableContainer.NO_CHILDREN;
    }
}

