/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;

class BufferedUpdatesStream
implements Accountable {
    private final Set<FrozenBufferedUpdates> updates = new HashSet<FrozenBufferedUpdates>();
    private long nextGen = 1L;
    private final FinishedSegments finishedSegments;
    private final InfoStream infoStream;
    private final AtomicLong bytesUsed = new AtomicLong();
    private final AtomicInteger numTerms = new AtomicInteger();
    private final IndexWriter writer;
    private boolean closed;

    public BufferedUpdatesStream(IndexWriter writer) {
        this.writer = writer;
        this.infoStream = writer.infoStream;
        this.finishedSegments = new FinishedSegments(this.infoStream);
    }

    public synchronized long push(FrozenBufferedUpdates packet) {
        packet.setDelGen(this.nextGen++);
        assert (packet.any());
        assert (this.checkDeleteStats());
        this.updates.add(packet);
        this.numTerms.addAndGet(packet.numTermDeletes);
        this.bytesUsed.addAndGet(packet.bytesUsed);
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "push new packet (%s), packetCount=%d, bytesUsed=%.3f MB", packet, this.updates.size(), (double)this.bytesUsed.get() / 1024.0 / 1024.0));
        }
        assert (this.checkDeleteStats());
        return packet.delGen();
    }

    public synchronized int getPendingUpdatesCount() {
        return this.updates.size();
    }

    public synchronized void clear() {
        this.updates.clear();
        this.nextGen = 1L;
        this.finishedSegments.clear();
        this.numTerms.set(0);
        this.bytesUsed.set(0L);
    }

    public boolean any() {
        return this.bytesUsed.get() != 0L;
    }

    public int numTerms() {
        return this.numTerms.get();
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get();
    }

    private synchronized void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitApplyAll() throws IOException {
        HashSet<FrozenBufferedUpdates> waitFor;
        assert (!Thread.holdsLock(this.writer));
        long t0 = System.nanoTime();
        BufferedUpdatesStream bufferedUpdatesStream = this;
        synchronized (bufferedUpdatesStream) {
            waitFor = new HashSet<FrozenBufferedUpdates>(this.updates);
        }
        this.waitApply(waitFor);
    }

    public boolean stillRunning(long delGen) {
        return this.finishedSegments.stillRunning(delGen);
    }

    public void finishedSegment(long delGen) {
        this.finishedSegments.finishedSegment(delGen);
    }

    public synchronized void finished(FrozenBufferedUpdates packet) {
        assert (packet.applied.getCount() == 1L) : "packet=" + packet;
        packet.applied.countDown();
        this.updates.remove(packet);
        this.numTerms.addAndGet(-packet.numTermDeletes);
        assert (this.numTerms.get() >= 0) : "numTerms=" + this.numTerms + " packet=" + packet;
        this.bytesUsed.addAndGet(-packet.bytesUsed);
        this.finishedSegment(packet.delGen());
    }

    public long getCompletedDelGen() {
        return this.finishedSegments.getCompletedDelGen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitApplyForMerge(List<SegmentCommitInfo> mergeInfos) throws IOException {
        assert (!Thread.holdsLock(this.writer));
        long t0 = System.nanoTime();
        long maxDelGen = Long.MIN_VALUE;
        for (SegmentCommitInfo info : mergeInfos) {
            maxDelGen = Math.max(maxDelGen, info.getBufferedDeletesGen());
        }
        HashSet<FrozenBufferedUpdates> waitFor = new HashSet<FrozenBufferedUpdates>();
        BufferedUpdatesStream bufferedUpdatesStream = this;
        synchronized (bufferedUpdatesStream) {
            for (FrozenBufferedUpdates packet : this.updates) {
                if (packet.delGen() > maxDelGen) continue;
                waitFor.add(packet);
            }
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "waitApplyForMerge: " + waitFor.size() + " packets, " + mergeInfos.size() + " merging segments");
        }
        this.waitApply(waitFor);
    }

    private void waitApply(Set<FrozenBufferedUpdates> waitFor) throws IOException {
        long startNS = System.nanoTime();
        int packetCount = waitFor.size();
        if (waitFor.isEmpty()) {
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "waitApply: no deletes to apply");
            }
            return;
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "waitApply: " + waitFor.size() + " packets: " + waitFor);
        }
        long totalDelCount = 0L;
        for (FrozenBufferedUpdates packet : waitFor) {
            packet.apply(this.writer);
            totalDelCount += packet.totalDelCount;
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "waitApply: done %d packets; totalDelCount=%d; totBytesUsed=%d; took %.2f msec", packetCount, totalDelCount, this.bytesUsed.get(), (double)(System.nanoTime() - startNS) / 1000000.0));
        }
    }

    synchronized long getNextGen() {
        return this.nextGen++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentState[] openSegmentStates(IndexWriter.ReaderPool pool, List<SegmentCommitInfo> infos, Set<SegmentCommitInfo> alreadySeenSegments, long delGen) throws IOException {
        this.ensureOpen();
        ArrayList<SegmentState> segStates = new ArrayList<SegmentState>();
        boolean success = false;
        try {
            for (SegmentCommitInfo info : infos) {
                if (info.getBufferedDeletesGen() > delGen || alreadySeenSegments.contains(info)) continue;
                segStates.add(new SegmentState(pool, info));
                alreadySeenSegments.add(info);
            }
            success = true;
        }
        finally {
            if (!success) {
                for (SegmentState segState : segStates) {
                    try {
                        segState.finish(pool);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return segStates.toArray(new SegmentState[0]);
    }

    public ApplyDeletesResult closeSegmentStates(IndexWriter.ReaderPool pool, SegmentState[] segStates, boolean success) throws IOException {
        int count = segStates.length;
        Throwable firstExc = null;
        ArrayList<SegmentCommitInfo> allDeleted = null;
        long totDelCount = 0L;
        for (int j = 0; j < count; ++j) {
            SegmentState segState = segStates[j];
            if (success) {
                totDelCount += (long)(segState.rld.getPendingDeleteCount() - segState.startDelCount);
                int fullDelCount = segState.rld.info.getDelCount() + segState.rld.getPendingDeleteCount();
                assert (fullDelCount <= segState.rld.info.info.maxDoc());
                if (fullDelCount == segState.rld.info.info.maxDoc()) {
                    if (allDeleted == null) {
                        allDeleted = new ArrayList<SegmentCommitInfo>();
                    }
                    allDeleted.add(segState.reader.getSegmentInfo());
                }
            }
            try {
                segStates[j].finish(pool);
                continue;
            }
            catch (Throwable th) {
                if (firstExc != null) continue;
                firstExc = th;
            }
        }
        if (success && firstExc != null) {
            throw IOUtils.rethrowAlways(firstExc);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "closeSegmentStates: " + totDelCount + " new deleted documents; pool " + this.updates.size() + " packets; bytesUsed=" + pool.ramBytesUsed());
        }
        return new ApplyDeletesResult(totDelCount > 0L, allDeleted);
    }

    private boolean checkDeleteStats() {
        int numTerms2 = 0;
        long bytesUsed2 = 0L;
        for (FrozenBufferedUpdates packet : this.updates) {
            numTerms2 += packet.numTermDeletes;
            bytesUsed2 += (long)packet.bytesUsed;
        }
        assert (numTerms2 == this.numTerms.get()) : "numTerms2=" + numTerms2 + " vs " + this.numTerms.get();
        assert (bytesUsed2 == this.bytesUsed.get()) : "bytesUsed2=" + bytesUsed2 + " vs " + this.bytesUsed;
        return true;
    }

    public static class ApplyDeletesResult {
        public final boolean anyDeletes;
        public final List<SegmentCommitInfo> allDeleted;

        ApplyDeletesResult(boolean anyDeletes, List<SegmentCommitInfo> allDeleted) {
            this.anyDeletes = anyDeletes;
            this.allDeleted = allDeleted;
        }
    }

    private static class FinishedSegments {
        private long completedDelGen;
        private final Set<Long> finishedDelGens = new HashSet<Long>();
        private final InfoStream infoStream;

        public FinishedSegments(InfoStream infoStream) {
            this.infoStream = infoStream;
        }

        public synchronized void clear() {
            this.finishedDelGens.clear();
            this.completedDelGen = 0L;
        }

        public synchronized boolean stillRunning(long delGen) {
            return delGen > this.completedDelGen && !this.finishedDelGens.contains(delGen);
        }

        public synchronized long getCompletedDelGen() {
            return this.completedDelGen;
        }

        public synchronized void finishedSegment(long delGen) {
            this.finishedDelGens.add(delGen);
            while (this.finishedDelGens.contains(this.completedDelGen + 1L)) {
                this.finishedDelGens.remove(this.completedDelGen + 1L);
                ++this.completedDelGen;
            }
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "finished packet delGen=" + delGen + " now completedDelGen=" + this.completedDelGen);
            }
        }
    }

    public static final class SegmentState {
        final long delGen;
        final ReadersAndUpdates rld;
        final SegmentReader reader;
        final int startDelCount;
        TermsEnum termsEnum;
        PostingsEnum postingsEnum;
        BytesRef term;

        public SegmentState(IndexWriter.ReaderPool pool, SegmentCommitInfo info) throws IOException {
            this.rld = pool.get(info, true);
            this.startDelCount = this.rld.getPendingDeleteCount();
            this.reader = this.rld.getReader(IOContext.READ);
            this.delGen = info.getBufferedDeletesGen();
        }

        public void finish(IndexWriter.ReaderPool pool) throws IOException {
            try {
                this.rld.release(this.reader);
            }
            finally {
                pool.release(this.rld);
            }
        }

        public String toString() {
            return "SegmentState(" + this.rld.info + ")";
        }
    }
}

