/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.languages;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class N4LanguageUtils {
    public static <T extends EObject> ParseResult<T> parseXtextLanguage(String fileExtOfLanguage, Class<T> expectedTypeOfRoot, String source) {
        return N4LanguageUtils.parseXtextLanguage(fileExtOfLanguage, null, expectedTypeOfRoot, source);
    }

    public static <T extends EObject> ParseResult<T> parseXtextLanguage(String fileExtOfLanguage, ParserRule parserRuleOrNull, Class<T> expectedTypeOfRoot, String source) {
        IParser parser = N4LanguageUtils.getServiceForContext(fileExtOfLanguage, IParser.class).orElseThrow(() -> new RuntimeException("Cannot obtain Xtext parser for language with file extension: " + fileExtOfLanguage));
        IParseResult result = parserRuleOrNull != null ? parser.parse(parserRuleOrNull, (Reader)new StringReader(source)) : parser.parse((Reader)new StringReader(source));
        Iterable errors = Iterables.transform((Iterable)result.getSyntaxErrors(), node -> node.getSyntaxErrorMessage());
        EObject root = result.getRootASTElement();
        if (root != null && expectedTypeOfRoot.isInstance(root)) {
            EObject rootCasted = root;
            return new ParseResult<EObject>(rootCasted, errors);
        }
        return new ParseResult<Object>(null, errors);
    }

    public static <T> Optional<T> getServiceForContext(EObject context, Class<T> serviceType) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(serviceType);
        Resource res = context.eResource();
        URI uri = res != null ? res.getURI() : null;
        return uri != null ? N4LanguageUtils.getServiceForContext(uri, serviceType) : Optional.empty();
    }

    public static <T> Optional<T> getServiceForContext(IFile iFile, Class<T> serviceType) {
        return N4LanguageUtils.getServiceForContext((IResource)iFile, serviceType);
    }

    public static <T> Optional<T> getServiceForContext(IResource iResource, Class<T> serviceType) {
        Objects.requireNonNull(iResource);
        Objects.requireNonNull(serviceType);
        URI uri = URI.createPlatformResourceURI((String)iResource.getFullPath().toString(), (boolean)true);
        return uri != null ? N4LanguageUtils.getServiceForContext(uri, serviceType) : Optional.empty();
    }

    public static <T> Optional<T> getServiceForContext(String fileExtOfContextLanguage, Class<T> serviceType) {
        String uriStr = "__synthetic_" + new Random().nextInt(Integer.MAX_VALUE) + "." + fileExtOfContextLanguage;
        URI uri = URI.createURI((String)uriStr);
        return N4LanguageUtils.getServiceForContext(uri, serviceType);
    }

    public static <T> Optional<T> getServiceForContext(URI uri, Class<T> serviceType) {
        Objects.requireNonNull(uri);
        Objects.requireNonNull(serviceType);
        IResourceServiceProvider serviceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri);
        return serviceProvider != null ? Optional.ofNullable(serviceProvider.get(serviceType)) : Optional.empty();
    }

    public static final class ParseResult<T extends EObject> {
        public final T ast;
        public final List<SyntaxErrorMessage> errors;

        public ParseResult(T ast, Iterable<SyntaxErrorMessage> errors) {
            this.ast = ast;
            this.errors = Lists.newArrayList(errors);
        }
    }
}

