/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.antlr.compressor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.n4js.antlr.compressor.IfElseCascade;

class IfElseCascadeParser {
    private final String grammarContent;
    private int offset;
    private Map<String, Integer> tokenToStateMap;
    private String tokenVarName;
    private String condition;
    private boolean bElse;
    private List<IfElseCascade> cascades;
    private int start;

    public IfElseCascadeParser(String grammarContent) {
        this.grammarContent = grammarContent;
    }

    List<IfElseCascade> findCascades(int i_offset) {
        int oldOffset;
        this.cascades = new ArrayList<IfElseCascade>();
        this.tokenToStateMap = null;
        this.start = this.offset = i_offset;
        this.skipWS();
        if (!this.firstIf()) {
            return null;
        }
        do {
            oldOffset = this.offset;
        } while (this.nextIf());
        this.offset = oldOffset;
        this.addCascade(this.start, this.offset);
        return this.cascades;
    }

    private void addCascade(int cStart, int cEnd) {
        if (this.tokenToStateMap != null && this.tokenToStateMap.size() > 1) {
            IfElseCascade cascade = new IfElseCascade(cStart, cEnd, this.bElse, this.tokenVarName, this.condition, this.tokenToStateMap);
            this.cascades.add(cascade);
            this.tokenToStateMap = new HashMap<String, Integer>();
        }
    }

    private boolean firstIf() {
        this.bElse = this.next("else");
        if (!this.next("if", "(", "(")) {
            return false;
        }
        this.tokenVarName = this.findVar();
        if (this.tokenVarName.isEmpty()) {
            return false;
        }
        if (!this.next("==")) {
            return false;
        }
        String tokenName = this.findVar();
        if (tokenName.isEmpty()) {
            return false;
        }
        if (!this.next(")")) {
            return false;
        }
        this.condition = this.findCondition();
        if (!this.next(")", "{", "s", "=")) {
            return false;
        }
        Integer stateValue = this.findIntValue();
        if (stateValue == null) {
            return false;
        }
        this.tokenToStateMap = new HashMap<String, Integer>();
        this.tokenToStateMap.put(tokenName, stateValue);
        return this.next(";", "}");
    }

    private boolean nextIf() {
        int ifStart = this.offset;
        if (!this.next("else", "if", "(", "(", this.tokenVarName, "==")) {
            return false;
        }
        String tokenName = this.findVar();
        if (tokenName.isEmpty()) {
            return false;
        }
        if (!this.next(")")) {
            return false;
        }
        String nextCondition = this.findCondition();
        if (!this.condition.equals(nextCondition)) {
            this.addCascade(this.start, ifStart);
            this.condition = nextCondition;
            this.start = ifStart;
            this.bElse = true;
        }
        if (!this.next(")", "{", "s", "=")) {
            return false;
        }
        Integer stateValue = this.findIntValue();
        if (stateValue == null) {
            return false;
        }
        this.tokenToStateMap.put(tokenName, stateValue);
        return this.next(";", "}");
    }

    private String findCondition() {
        int o = this.offset;
        int parenthesisCount = 0;
        while (true) {
            char c = this.grammarContent.charAt(o);
            switch (c) {
                case '(': {
                    ++parenthesisCount;
                    break;
                }
                case ')': {
                    if (--parenthesisCount >= 0) break;
                    String cond = this.grammarContent.substring(this.offset, o);
                    this.offset = o;
                    return cond.trim();
                }
            }
            ++o;
        }
    }

    private String findVar() {
        int o = this.offset;
        while (Character.isJavaIdentifierPart(this.grammarContent.charAt(o))) {
            ++o;
        }
        String varName = this.grammarContent.substring(this.offset, o);
        this.offset = o;
        return varName;
    }

    private Integer findIntValue() {
        int o = this.offset;
        while (Character.isDigit(this.grammarContent.charAt(o))) {
            ++o;
        }
        if (o == this.offset) {
            return null;
        }
        String value = this.grammarContent.substring(this.offset, o);
        this.offset = o;
        return Integer.parseInt(value);
    }

    private void skipWS() {
        while (Character.isWhitespace(this.grammarContent.charAt(this.offset))) {
            ++this.offset;
        }
    }

    private boolean next(String ... tokens) {
        int oldOffset = this.offset;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!token.isEmpty()) {
                if (this.grammarContent.startsWith(token, this.offset)) {
                    this.offset += token.length();
                    this.skipWS();
                } else {
                    this.offset = oldOffset;
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        int from = this.offset - 10;
        int to = this.offset + 10;
        if (from < 0) {
            from = 0;
        }
        if (to > this.grammarContent.length()) {
            to = this.grammarContent.length();
        }
        StringBuilder strb = new StringBuilder();
        int i = from;
        while (i < to) {
            char c = this.grammarContent.charAt(i);
            if (i == this.offset) {
                strb.append("\u00ab");
            }
            if (c == '\n') {
                strb.append("\\n");
            } else if (c == '\r') {
                strb.append("\\r");
            } else if (c == '\t') {
                strb.append("\\t");
            } else {
                strb.append(c);
            }
            if (i == this.offset) {
                strb.append("\u00bb");
            }
            ++i;
        }
        return strb.toString();
    }
}

